/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

public class PropertyFilter {
    public static final String SYSTEM_PROPERTY_PREFIX = "${";
    public static final String SYSTEM_PROPERTY_SUFFIX = "}";

    public static String filterProperties(String string) {
        String resStr = string;
        if (string != null) {
            int x = string.indexOf(SYSTEM_PROPERTY_PREFIX);
            int y = string.indexOf(SYSTEM_PROPERTY_SUFFIX);
            if (x == -1 || y == -1) {
                return resStr;
            }
            String a = string.substring(0, x);
            String property = string.substring(x + 2, y);
            StringBuffer strBuf = new StringBuffer(a);
            strBuf.append(System.getProperty(property));
            if (y < string.length()) {
                String remainder = string.substring(y + 1);
                strBuf.append(PropertyFilter.filterProperties(remainder));
            }
            resStr = strBuf.toString();
        }
        return resStr;
    }

    public static String replacePropertyValues(String string, String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return string;
        }
        String resStr = string;
        if (string != null) {
            string = string.trim();
            String normalizedString = PropertyFilter.normalizeString(string);
            if (key != null) {
                String normalizedValue = PropertyFilter.normalizeString(value);
                int x = normalizedString.indexOf(normalizedValue);
                int y = x + normalizedValue.length() - 1;
                if (x == -1 || y == -1) {
                    return resStr;
                }
                String a = string.substring(0, x);
                StringBuffer strBuf = new StringBuffer(a);
                strBuf.append(SYSTEM_PROPERTY_PREFIX);
                strBuf.append(key);
                strBuf.append(SYSTEM_PROPERTY_SUFFIX);
                if (y < normalizedString.length()) {
                    String remainder = string.substring(y + 1);
                    strBuf.append(PropertyFilter.replacePropertyValues(remainder, key));
                }
                resStr = strBuf.toString();
            }
        }
        return resStr;
    }

    private static String normalizeString(String srcStr) {
        return srcStr.replace('\\', '/');
    }
}

