/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class FileTransferManager {
    private static final String DOWNLOAD_MBEAN_NAME = "com.sun.jbi:Target=domain,ServiceName=FileTransferService,ServiceType=Download";
    private static final String UPLOAD_MBEAN_NAME = "com.sun.jbi:Target=domain,ServiceName=FileTransferService,ServiceType=Upload";
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final String UPLOAD_INITIATE = "initiateUpload";
    private static final String UPLOAD_TRANSFER = "uploadBytes";
    private static final String GET_ARCHIVE_FILE_PATH = "getArchiveFilePath";
    private static final String UPLOAD_TERMINATE = "terminateUpload";
    private static final String REMOVE_ARCHIVE = "removeArchive";
    private static final String DOWNLOAD_INITIATE = "initiateDownload";
    private static final String DOWNLOAD_TRANSFER = "downloadBytes";
    private static final String DOWNLOAD_TERMINATE = "terminateDownload";
    private MBeanServerConnection mServer;
    private ObjectName mDownloadMBean;
    private ObjectName mUploadMBean;
    private int mChunkSize = 8192;
    private Logger mLog = Logger.getLogger("com.sun.jbi.management.repository");
    private Object mLastUploadId = null;

    public FileTransferManager(MBeanServerConnection server) {
        this.mServer = server;
        try {
            this.mDownloadMBean = new ObjectName(DOWNLOAD_MBEAN_NAME);
            this.mUploadMBean = new ObjectName(UPLOAD_MBEAN_NAME);
        }
        catch (MalformedObjectNameException monEx) {
            this.mLog.severe(monEx.getMessage());
        }
    }

    public String uploadArchive(File archive) throws Exception {
        Object uploadId;
        FileInputStream fis = new FileInputStream(archive);
        this.mLastUploadId = uploadId = this.mServer.invoke(this.mUploadMBean, UPLOAD_INITIATE, new Object[]{archive.getName()}, new String[]{"java.lang.String"});
        Object uploadFilePathObj = this.mServer.invoke(this.mUploadMBean, GET_ARCHIVE_FILE_PATH, new Object[]{uploadId}, new String[]{"java.lang.Object"});
        byte[] chunk = new byte[this.mChunkSize];
        int count = 0;
        while ((count = fis.read(chunk)) != -1) {
            this.mServer.invoke(this.mUploadMBean, UPLOAD_TRANSFER, new Object[]{uploadId, this.trim(chunk, count)}, new String[]{"java.lang.Object", "[B"});
        }
        this.mServer.invoke(this.mUploadMBean, UPLOAD_TERMINATE, new Object[]{uploadId}, new String[]{"java.lang.Object"});
        String uploadFilePath = null;
        if (uploadFilePathObj != null) {
            uploadFilePath = uploadFilePathObj.toString();
        }
        return uploadFilePath;
    }

    public Object getLastUploadId() {
        return this.mLastUploadId;
    }

    public void removeUploadedArchive(Object uploadId) {
        if (uploadId == null) {
            return;
        }
        try {
            this.mServer.invoke(this.mUploadMBean, REMOVE_ARCHIVE, new Object[]{uploadId}, new String[]{"java.lang.Object"});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void downloadArchive(String archiveLocation, File target) throws Exception {
        byte[] chunk;
        FileOutputStream fos = new FileOutputStream(target);
        Object downloadId = this.mServer.invoke(this.mDownloadMBean, DOWNLOAD_INITIATE, new Object[]{archiveLocation}, new String[]{"java.lang.Object"});
        do {
            chunk = (byte[])this.mServer.invoke(this.mDownloadMBean, DOWNLOAD_TRANSFER, new Object[]{downloadId, new Integer(this.mChunkSize)}, new String[]{"java.lang.Object", "int"});
            fos.write(chunk);
            fos.flush();
        } while (chunk.length > 0);
        this.mServer.invoke(this.mDownloadMBean, DOWNLOAD_TERMINATE, new Object[]{downloadId}, new String[]{"java.lang.Object"});
        fos.close();
    }

    public int getChunkSize() {
        return this.mChunkSize;
    }

    public void setChunkSize(int size) {
        this.mChunkSize = size;
    }

    private byte[] trim(byte[] source, int size) {
        byte[] trimmed;
        if (source.length == size) {
            trimmed = source;
        } else {
            trimmed = new byte[size];
            System.arraycopy(source, 0, trimmed, 0, size);
        }
        return trimmed;
    }
}

