/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime.mbeans;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.runtime.mbeans.AbstractUIMBeanImpl;
import com.sun.jbi.ui.runtime.mbeans.JBIAdminCommandsUIMBean;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIAdminCommandsUIMBeanImpl
extends AbstractUIMBeanImpl
implements JBIAdminCommandsUIMBean {
    private static final String NO_OPERATION = "Not Implemented";
    private static final String LOG_LEVEL_KEY = "LogLevel";
    private static final String LOGGER_NAME_KEY = "LoggerName";

    public JBIAdminCommandsUIMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    @Override
    public String deployServiceAssembly(String zipFilePath, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("deploying Service Assembly Zip file " + zipFilePath);
        String result = null;
        Object resultObject = null;
        String assemblyName = this.validateServiceAssembly(zipFilePath);
        File file = new File(zipFilePath);
        String fileURLString = null;
        fileURLString = file.getAbsolutePath();
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "deploy", fileURLString);
        if (resultObject != null) {
            result = resultObject.toString();
            result = assemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : assemblyName;
        } else {
            Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
            throw new JBIRemoteException(exception);
        }
        return result;
    }

    String validateServiceAssembly(String zipFilePath) {
        JBIArchive archive = null;
        ServiceAssemblyDD descriptor = null;
        String name = null;
        try {
            archive = new JBIArchive(zipFilePath);
            if (archive.isServiceAssemblyArchive()) {
                descriptor = (ServiceAssemblyDD)archive.getJbiDescriptor();
                name = descriptor.getName();
            }
        }
        catch (IOException ioException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    public Map<String, String> deployServiceAssembly(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.deployServiceAssembly(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String getComponentInstallationDescriptor(String componentName) throws JBIRemoteException {
        String targetName = "domain";
        String jbiXml = this.getInstallationDescriptor(componentName, targetName);
        return jbiXml;
    }

    @Override
    public String getServiceAssemblyDeploymentDescriptor(String serviceAssemblyName) throws JBIRemoteException {
        String targetName = "domain";
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "getServiceAssemblyDescriptor", serviceAssemblyName);
        if (resultObject != null) {
            return resultObject.toString();
        }
        Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
        throw new JBIRemoteException(exception);
    }

    @Override
    public String getSharedLibraryInstallationDescriptor(String sharedLibraryName) throws JBIRemoteException {
        String targetName = "domain";
        String jbiXml = this.getSharedLibraryDescriptor(sharedLibraryName, targetName);
        return jbiXml;
    }

    @Override
    public String getServiceUnitDeploymentDescriptor(String serviceAssemblyName, String serviceUnitName) throws JBIRemoteException {
        String targetName = "domain";
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object[] params = new Object[]{serviceAssemblyName, serviceUnitName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "getServiceUnitDescriptor", params, signature);
        if (resultObject != null) {
            return resultObject.toString();
        }
        Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
        throw new JBIRemoteException(exception);
    }

    boolean unloadComponentInstaller(String componentName, boolean isRemoveComponent, boolean isIgnoreExceptions, String targetName) throws JBIRemoteException {
        boolean retainInDomain = false;
        if (retainInDomain) {
            isRemoveComponent = false;
            return this.unloadComponentInstallerInternal(componentName, isRemoveComponent, isIgnoreExceptions, targetName);
        }
        return this.unloadComponentInstallerInternal(componentName, isRemoveComponent, isIgnoreExceptions, targetName);
    }

    boolean unloadComponentInstallerInternal(String componentName, boolean isRemoveComponent, boolean isIgnoreExceptions, String targetName) throws JBIRemoteException {
        boolean result = false;
        JBIAdminCommandsUIMBeanImpl.logDebug("unloadComponentInstaller ComponentName: " + componentName + " isremoveComponent " + isRemoveComponent + " isIgnoreExceptions " + isIgnoreExceptions + " targetName " + targetName);
        try {
            ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
            Object[] params = new Object[]{componentName, isRemoveComponent};
            String[] signature = new String[]{"java.lang.String", "boolean"};
            JBIAdminCommandsUIMBeanImpl.logDebug("Calling unloadInstaller with params ( " + params[0] + " , " + params[1] + " ) on InstallerServiceMBean : " + installerServiceObjectName.toString());
            Object resultObject = this.invokeMBeanOperation(installerServiceObjectName, "unloadInstaller", params, signature);
            result = (Boolean)resultObject;
        }
        catch (Exception ex) {
            if (isIgnoreExceptions) {
                JBIAdminCommandsUIMBeanImpl.logError(ex);
            }
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
        return result;
    }

    public boolean unloadComponentInstaller(ObjectName installerObjectName, boolean isRemoveComponent, boolean isIgnoreExceptions, String targetName) throws JBIRemoteException {
        String componentName = null;
        if (installerObjectName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.installer.mbean.not.exist", null, null);
            throw new JBIRemoteException(exception);
        }
        componentName = this.getComponentNameFromJmxObjectName(installerObjectName);
        if (componentName == null || componentName.trim().length() <= 0) {
            String[] args = new String[]{installerObjectName.toString()};
            Exception exception = this.createManagementException("ui.mbean.install.installer.mbean.has.no.component.name", args, null);
            throw new JBIRemoteException(exception);
        }
        return this.unloadComponentInstaller(componentName, isRemoveComponent, isIgnoreExceptions, targetName);
    }

    public void configureComponentInstaller(ObjectName installerObjectName, Properties paramProps) throws JBIRemoteException {
        if (paramProps == null || paramProps.size() == 0) {
            JBIAdminCommandsUIMBeanImpl.logDebug("No Installer Params for " + installerObjectName);
            return;
        }
        ObjectName configObjectName = null;
        configObjectName = (ObjectName)this.getMBeanAttribute(installerObjectName, "InstallerConfigurationMBean");
        if (configObjectName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.not.exist", null, null);
            throw new JBIRemoteException(exception);
        }
        if (!this.isMBeanRegistered(configObjectName)) {
            JBIAdminCommandsUIMBeanImpl.logDebug("Configuration MBean for " + installerObjectName);
            JBIAdminCommandsUIMBeanImpl.logDebug("No ConfigurationMBean registered with name: " + configObjectName);
            return;
        }
        JBIAdminCommandsUIMBeanImpl.logDebug("Setting the Installer Params on ConfigMBean " + configObjectName);
        AttributeList attrList = this.constructMBeanAttributes(configObjectName, paramProps);
        try {
            this.setMBeanAttributes(configObjectName, attrList);
        }
        catch (Exception ex) {
            Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.set.attrs.error", null, ex);
            throw new JBIRemoteException(exception);
        }
    }

    void checkForValidTarget(ObjectName objectName, String targetName) throws JBIRemoteException {
        boolean isRegistered = this.isValidTarget(objectName);
        if (!isRegistered) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", args, null);
            throw new JBIRemoteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String installComponent(String zipFilePath, Properties paramProps, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Installing Component zip file " + zipFilePath);
        String fileURIString = null;
        File file = new File(zipFilePath);
        fileURIString = file.getAbsolutePath();
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        ObjectName installerObjectName = null;
        ObjectName lifecycleObjectName = null;
        String componentName = null;
        JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 1 : Calling loadNewInstaller on InstallerServiceMBean : " + installerServiceObjectName);
        installerObjectName = (ObjectName)this.invokeMBeanOperation(installerServiceObjectName, "loadNewInstaller", fileURIString);
        if (installerObjectName == null) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.install.comp.error.installerMBean", args, null);
            throw new JBIRemoteException(exception);
        }
        try {
            JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 2 : Configuring Installer Configuration Parameters if present");
            this.configureComponentInstaller(installerObjectName, paramProps);
            JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 3 : Calling Install on InstallerMbean : " + installerObjectName);
            lifecycleObjectName = (ObjectName)this.invokeMBeanOperation(installerObjectName, "install");
            componentName = this.getComponentNameFromJmxObjectName(installerObjectName);
            if (!"domain".equals(targetName)) {
                if (lifecycleObjectName == null) {
                    String[] args = new String[]{installerObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.lifecycleMBean", args, null);
                    throw new JBIRemoteException(exception);
                }
                componentName = this.getComponentNameFromJmxObjectName(lifecycleObjectName);
                if (componentName == null) {
                    String[] args = new String[]{lifecycleObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.compId", args, null);
                    throw new JBIRemoteException(exception);
                }
            }
        }
        finally {
            boolean isRemoveComponent = false;
            boolean ignoreExceptions = false;
            if (componentName == null) {
                ignoreExceptions = true;
                isRemoveComponent = true;
            }
            JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 4 : unloading component installer " + installerObjectName);
            this.unloadComponentInstaller(installerObjectName, isRemoveComponent, ignoreExceptions, targetName);
        }
        return componentName;
    }

    @Override
    public String installComponent(String zipFilePath, String targetName) throws JBIRemoteException {
        Properties params = new Properties();
        return this.installComponent(zipFilePath, params, targetName);
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, Properties paramProps, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponent(zipFilePath, paramProps, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponent(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String installSharedLibrary(String zipFilePath, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Installing Shared Library " + zipFilePath);
        File file = new File(zipFilePath);
        String fileURIString = null;
        fileURIString = file.getAbsolutePath();
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling installSharedLibrary on Installation Service MBean = " + installerServiceObjectName);
        Object sharedLibName = null;
        sharedLibName = this.invokeMBeanOperation(installerServiceObjectName, "installSharedLibrary", fileURIString);
        if (sharedLibName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.sns.error", null, null);
            throw new JBIRemoteException(exception);
        }
        return sharedLibName.toString();
    }

    @Override
    public Map<String, String> installSharedLibrary(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installSharedLibrary(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public boolean isJBIRuntimeEnabled() throws JBIRemoteException {
        return true;
    }

    protected String listComponents(ComponentType type, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiJBIComponentInfoState(state);
        ComponentState frameworkCompState = ComponentState.UNKNOWN;
        if (state != null) {
            frameworkCompState = AbstractUIMBeanImpl.toFrameworkComponentInfoState(state);
        }
        return JBIComponentInfo.writeAsXmlText(this.toUiComponentInfoList(this.getFrameworkComponentInfoListForEnginesAndBindings(type, frameworkCompState, sharedLibraryName, serviceAssemblyName, targetName), targetName));
    }

    @Override
    public String listBindingComponents(String targetName) throws JBIRemoteException {
        return this.listBindingComponents(null, null, null, targetName);
    }

    @Override
    public String listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        return this.listComponents(ComponentType.BINDING, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public Map<String, String> listBindingComponents(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listBindingComponents(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listBindingComponents(state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listServiceAssemblies(String targetName) throws JBIRemoteException {
        return this.listServiceAssemblies(null, targetName);
    }

    @Override
    public String listServiceAssemblies(String componentName, String targetName) throws JBIRemoteException {
        return this.listServiceAssemblies(null, componentName, targetName);
    }

    @Override
    public String listServiceAssemblies(String state, String componentName, String targetName) throws JBIRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiServiceAssemblyInfoState(state);
        List saInfoList = this.getServiceAssemblyInfoList(AbstractUIMBeanImpl.toFrameworkServiceAssemblyState(state), componentName, targetName);
        return ServiceAssemblyInfo.writeAsXmlTextWithProlog(saInfoList);
    }

    @Override
    public Map<String, String> listServiceAssemblies(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String state, String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(state, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listServiceEngines(String targetName) throws JBIRemoteException {
        return this.listServiceEngines(null, null, null, targetName);
    }

    @Override
    public String listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        return this.listComponents(ComponentType.ENGINE, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public Map<String, String> listServiceEngines(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceEngines(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceEngines(state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listSharedLibraries(String targetName) throws JBIRemoteException {
        return this.listSharedLibraries(null, targetName);
    }

    @Override
    public String listSharedLibraries(String componentName, String targetName) throws JBIRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        List frameworkCompInfoList = this.getFrameworkComponentInfoListForSharedLibraries(componentName, targetName);
        List uiCompInfoList = new ArrayList();
        uiCompInfoList = this.toUiComponentInfoList(frameworkCompInfoList, targetName);
        return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
    }

    @Override
    public Map<String, String> listSharedLibraries(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraries(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listSharedLibraries(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraries(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listSharedLibraryDependents(String sharedLibraryName, String targetName) throws JBIRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        Collection compNames = this.getComponentNamesDependentOnSharedLibrary(sharedLibraryName, targetName);
        return JBIComponentInfo.writeAsXmlText(this.toUiComponentInfoList(this.getFrameworkComponentInfoList(compNames, targetName), targetName));
    }

    @Override
    public Map<String, String> listSharedLibraryDependents(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraryDependents(sharedLibraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    protected String showComponent(String name, ComponentType type, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        List compInfoList;
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiJBIComponentInfoState(state);
        ArrayList<JBIComponentInfo> uiCompInfoList = new ArrayList<JBIComponentInfo>();
        if (name == null || name.trim().length() <= 0) {
            return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
        }
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        ComponentInfo componentInformation = null;
        if (componentQuery != null) {
            componentInformation = componentQuery.getComponentInfo(name);
        }
        if (componentInformation == null) {
            return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
        }
        ComponentType frameworkCompType = ComponentType.BINDINGS_AND_ENGINES;
        ComponentState frameworkCompState = ComponentState.UNKNOWN;
        frameworkCompType = type != ComponentType.ENGINE && type != ComponentType.BINDING ? ComponentType.BINDINGS_AND_ENGINES : type;
        if (state != null) {
            frameworkCompState = AbstractUIMBeanImpl.toFrameworkComponentInfoState(state);
        }
        if ((compInfoList = this.getFrameworkComponentInfoListForEnginesAndBindings(frameworkCompType, frameworkCompState, sharedLibraryName, serviceAssemblyName, targetName)) == null || compInfoList.size() <= 0) {
            return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
        }
        Iterator itr = compInfoList.iterator();
        while (itr.hasNext()) {
            String compName = ((ComponentInfo)itr.next()).getName();
            if (!compName.equals(componentInformation.getName())) continue;
            uiCompInfoList.add(this.toUiComponentInfo(componentInformation, targetName));
            break;
        }
        return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
    }

    @Override
    public String showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        return this.showComponent(name, ComponentType.BINDING, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public Map<String, String> showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showBindingComponent(name, state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String showServiceAssembly(String name, String state, String componentName, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("show ServiceAssembly info for : " + name);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiServiceAssemblyInfoState(state);
        String saName = null;
        if (null != name && name.trim().length() > 0) {
            saName = name.trim();
        }
        ArrayList<ServiceAssemblyInfo> uiInfoList = new ArrayList<ServiceAssemblyInfo>();
        if (saName == null) {
            return ServiceAssemblyInfo.writeAsXmlTextWithProlog(uiInfoList);
        }
        List saInfoList = this.getServiceAssemblyInfoList(AbstractUIMBeanImpl.toFrameworkServiceAssemblyState(state), componentName, targetName);
        for (ServiceAssemblyInfo saInfo : saInfoList) {
            if (!saInfo.getName().equals(saName)) continue;
            uiInfoList.add(saInfo);
            break;
        }
        return ServiceAssemblyInfo.writeAsXmlTextWithProlog(uiInfoList);
    }

    @Override
    public Map<String, String> showServiceAssembly(String name, String state, String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showServiceAssembly(name, state, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        return this.showComponent(name, ComponentType.ENGINE, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public Map<String, String> showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showServiceEngine(name, state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String showSharedLibrary(String name, String componentName, String targetName) throws JBIRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        ArrayList<JBIComponentInfo> uiCompInfoList = new ArrayList<JBIComponentInfo>();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        ComponentInfo componentInformation = null;
        if (componentQuery != null && (componentInformation = componentQuery.getSharedLibraryInfo(name)) != null && ComponentType.SHARED_LIBRARY == componentInformation.getComponentType()) {
            uiCompInfoList.add(this.toUiComponentInfo(componentInformation, targetName));
        }
        return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
    }

    @Override
    public Map<String, String> showSharedLibrary(String name, String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showSharedLibrary(name, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String shutdownComponent(String componentName, String targetName) throws JBIRemoteException {
        boolean force = false;
        return this.shutdownComponent(componentName, force, targetName);
    }

    @Override
    public String shutdownComponent(String componentName, boolean force, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("shutting down Component " + componentName);
        ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
        this.checkForValidTarget(lifecycleObjectName, targetName);
        Object result = null;
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling shutDown on Component LifecycleMBean " + lifecycleObjectName);
        if (force) {
            Object[] params = new Object[]{force};
            String[] signature = new String[]{"boolean"};
            result = this.invokeMBeanOperation(lifecycleObjectName, "shutDown", params, signature);
        } else {
            result = this.invokeMBeanOperation(lifecycleObjectName, "shutDown");
        }
        return componentName;
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, boolean force, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownComponent(componentName, force, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        boolean force = false;
        return this.shutdownServiceAssemblyInternal(serviceAssemblyName, force, targetName);
    }

    String shutdownServiceAssemblyInternal(String serviceAssemblyName, boolean force, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Shutting down Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling shutdown on Deployment Service MBean = " + deploymentServiceObjectName.toString());
        Object resultObject = null;
        if (!force) {
            resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "shutDown", serviceAssemblyName);
        } else {
            Object[] params = new Object[]{serviceAssemblyName, force};
            String[] signature = new String[]{"java.lang.String", "boolean"};
            resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "shutDown", params, signature);
        }
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.sasm.shutdown.error", null, null);
        throw new JBIRemoteException(exception);
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String targetName) throws JBIRemoteException {
        return this.shutdownServiceAssemblyInternal(serviceAssemblyName, forceShutdown, targetName);
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownServiceAssembly(serviceAssemblyName, forceShutdown, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String startComponent(String componentName, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("starting Component " + componentName);
        ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
        this.checkForValidTarget(lifecycleObjectName, targetName);
        Object result = null;
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling start on Component LifecycleMBean " + lifecycleObjectName);
        result = this.invokeMBeanOperation(lifecycleObjectName, "start");
        return componentName;
    }

    @Override
    public Map<String, String> startComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.startComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String startServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Starting Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling start on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "start", serviceAssemblyName);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.sasm.start.error", null, null);
        throw new JBIRemoteException(exception);
    }

    @Override
    public Map<String, String> startServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.startServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String stopComponent(String componentName, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("stopping Component " + componentName);
        ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
        this.checkForValidTarget(lifecycleObjectName, targetName);
        Object result = null;
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling stop on Component LifecycleMBean " + lifecycleObjectName);
        result = this.invokeMBeanOperation(lifecycleObjectName, "stop");
        return componentName;
    }

    @Override
    public Map<String, String> stopComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.stopComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String stopServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Stopping Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling stop on Deployment Service MBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "stop", serviceAssemblyName);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.sasm.stop.error", null, null);
        throw new JBIRemoteException(exception);
    }

    @Override
    public Map<String, String> stopServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.stopServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    String undeployServiceAssemblyInternal(String serviceAssemblyName, boolean force, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Undeploying Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling undeploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object[] params = new Object[]{serviceAssemblyName, force};
        String[] signature = new String[]{"java.lang.String", "boolean"};
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "undeploy", params, signature);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.undeploy.error", null, null);
        throw new JBIRemoteException(exception);
    }

    String undeployServiceAssemblyInternal(String serviceAssemblyName, boolean force, boolean retainInDomain, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Undeploying Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling undeploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object[] params = new Object[]{serviceAssemblyName, force, retainInDomain};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean"};
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "undeploy", params, signature);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.undeploy.error", null, null);
        throw new JBIRemoteException(exception);
    }

    String undeployServiceAssemblyInternal(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Undeploying Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling undeploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "undeploy", serviceAssemblyName);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.undeploy.error", null, null);
        throw new JBIRemoteException(exception);
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        return this.undeployServiceAssemblyInternal(serviceAssemblyName, targetName);
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String uninstallComponent(String componentName, String targetName) throws JBIRemoteException {
        boolean force = false;
        boolean retainInDomain = false;
        return this.uninstallComponentInternal(componentName, force, targetName);
    }

    String uninstallComponentInternal(String componentName, boolean force, String targetName) throws JBIRemoteException {
        boolean retainInDomain = false;
        return this.uninstallComponentInternal(componentName, force, retainInDomain, targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String uninstallComponentInternal(String componentName, boolean force, boolean retainInDomain, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Uninstalling Component " + componentName);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Uninstall Step 1 : Calling loadInstaller on InstallerServiceMBean : " + installerServiceObjectName);
        ObjectName installerObjectName = null;
        installerObjectName = (ObjectName)this.invokeMBeanOperation(installerServiceObjectName, "loadInstaller", componentName);
        if (installerObjectName == null) {
            Exception exception = this.createManagementException("ui.mbean.uninstall.comp.error.installerMBean", null, null);
            throw new JBIRemoteException(exception);
        }
        boolean uninstalled = false;
        try {
            JBIAdminCommandsUIMBeanImpl.logDebug("Uninstall Step 2 : Calling Unisntall on InstallerMbean : " + installerObjectName);
            Object[] params = new Object[]{force};
            String[] signature = new String[]{"boolean"};
            this.invokeMBeanOperation(installerObjectName, "uninstall", params, signature);
            uninstalled = true;
        }
        finally {
            boolean isRemoveComponent = true;
            boolean ignoreExceptions = false;
            if (!uninstalled) {
                ignoreExceptions = true;
                isRemoveComponent = false;
            }
            JBIAdminCommandsUIMBeanImpl.logDebug("Uninstall Step 2 : unloading component installer " + installerObjectName);
            if (retainInDomain) {
                isRemoveComponent = false;
            }
            this.unloadComponentInstaller(installerObjectName, isRemoveComponent, ignoreExceptions, targetName);
        }
        return componentName;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("uninstalling shared library " + sharedLibraryName);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling uninstallSharedLibrary on InstallerServiceMBean = " + installerServiceObjectName);
        Object resultObject = null;
        resultObject = this.invokeMBeanOperation(installerServiceObjectName, "uninstallSharedLibrary", sharedLibraryName);
        if (resultObject == null || !(resultObject instanceof Boolean) || !((Boolean)resultObject).booleanValue()) {
            Exception exception = this.createManagementException("ui.mbean.uninstall.sns.error", null, null);
            throw new JBIRemoteException(exception);
        }
        return sharedLibraryName;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String installComponentFromDomain(String componentName, String targetName) throws JBIRemoteException {
        if (targetName.equals("domain")) {
            return componentName;
        }
        Properties params = new Properties();
        return this.installComponentFromDomain(componentName, params, targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String installComponentFromDomain(String componentName, Properties properties, String targetName) throws JBIRemoteException {
        if (targetName.equals("domain")) {
            return componentName;
        }
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        ObjectName installerObjectName = null;
        ObjectName lifecycleObjectName = null;
        JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 1 : Calling loadInstallerFromRepository which internally performs loadNewInstaller on InstallerServiceMBean : " + installerServiceObjectName);
        installerObjectName = (ObjectName)this.invokeMBeanOperation(installerServiceObjectName, "loadInstallerFromRepository", componentName);
        if (installerObjectName == null) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.install.comp.error.installerMBean", args, null);
            throw new JBIRemoteException(exception);
        }
        try {
            JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 2 : Configuring Installer Configuration Parameters if present");
            this.configureComponentInstaller(installerObjectName, properties);
            JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 3 : Calling Install on InstallerMbean : " + installerObjectName);
            lifecycleObjectName = (ObjectName)this.invokeMBeanOperation(installerObjectName, "install");
            componentName = this.getComponentNameFromJmxObjectName(installerObjectName);
            if (!"domain".equals(targetName)) {
                if (lifecycleObjectName == null) {
                    String[] args = new String[]{installerObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.lifecycleMBean", args, null);
                    throw new JBIRemoteException(exception);
                }
                componentName = this.getComponentNameFromJmxObjectName(lifecycleObjectName);
                if (componentName == null) {
                    String[] args = new String[]{lifecycleObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.compId", args, null);
                    throw new JBIRemoteException(exception);
                }
            }
        }
        finally {
            boolean isRemoveComponent = false;
            boolean ignoreExceptions = false;
            if (componentName == null) {
                ignoreExceptions = true;
                isRemoveComponent = true;
            }
            JBIAdminCommandsUIMBeanImpl.logDebug("Install Step 4 : unloading component installer " + installerObjectName);
            this.unloadComponentInstaller(installerObjectName, isRemoveComponent, ignoreExceptions, targetName);
        }
        return componentName;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, String targetName) throws JBIRemoteException {
        if (!forceDelete) {
            return this.uninstallComponent(componentName, targetName);
        }
        return this.uninstallComponentInternal(componentName, forceDelete, targetName);
    }

    @Override
    public String installSharedLibraryFromDomain(String libraryName, String targetName) throws JBIRemoteException {
        if (targetName.equals("domain")) {
            return libraryName;
        }
        ObjectName installerServiceObjectName = null;
        Object sharedLibName = null;
        installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        if (installerServiceObjectName == null) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.install.comp.error.installerMBean", args, null);
            throw new JBIRemoteException(exception);
        }
        this.checkForValidTarget(installerServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Invoking installSharedLibraryFromRepository which internally invokes installSharedLibrary on Installation Service MBean = " + installerServiceObjectName);
        sharedLibName = this.invokeMBeanOperation(installerServiceObjectName, "installSharedLibraryFromRepository", libraryName);
        if (sharedLibName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.sns.error", null, null);
            throw new JBIRemoteException(exception);
        }
        return sharedLibName.toString();
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String targetName) throws JBIRemoteException {
        if (!forceDelete) {
            return this.uninstallSharedLibrary(sharedLibraryName, targetName);
        }
        return this.uninstallSharedLibraryInternal(sharedLibraryName, forceDelete, targetName);
    }

    public String uninstallSharedLibraryInternal(String sharedLibraryName, boolean forceDelete, String targetName) throws JBIRemoteException {
        return this.uninstallSharedLibrary(sharedLibraryName, targetName);
    }

    @Override
    public String deployServiceAssemblyFromDomain(String assemblyName, String targetName) throws JBIRemoteException {
        if (targetName.equals("domain")) {
            return assemblyName;
        }
        String result = null;
        Object resultObject = null;
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        if (deploymentServiceObjectName != null) {
            this.checkForValidTarget(deploymentServiceObjectName, targetName);
            JBIAdminCommandsUIMBeanImpl.logDebug("Invoking deployServiceAssemblyFromRepository which internally invokes deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
            resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "deployFromRepository", assemblyName);
        }
        if (resultObject != null) {
            result = resultObject.toString();
            result = assemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : assemblyName;
        } else {
            Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
            throw new JBIRemoteException(exception);
        }
        return result;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String targetName) throws JBIRemoteException {
        if (!forceDelete) {
            return this.undeployServiceAssembly(serviceAssemblyName, targetName);
        }
        return this.undeployServiceAssembly(serviceAssemblyName, targetName);
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponentFromDomain(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, Properties properties, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponentFromDomain(componentName, properties, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installSharedLibraryFromDomain(String libraryName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installSharedLibraryFromDomain(libraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> deployServiceAssemblyFromDomain(String assemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.deployServiceAssemblyFromDomain(assemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        return this.uninstallComponentInternal(componentName, forceDelete, retainInDomain, targetName);
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("uninstalling shared library " + sharedLibraryName);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling uninstallSharedLibrary on InstallerServiceMBean = " + installerServiceObjectName);
        Object resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, retainInDomain};
        String[] signature = new String[]{"java.lang.String", "boolean"};
        resultObject = this.invokeMBeanOperation(installerServiceObjectName, "uninstallSharedLibrary", params, signature);
        if (resultObject == null || !(resultObject instanceof Boolean) || !((Boolean)resultObject).booleanValue()) {
            Exception exception = this.createManagementException("ui.mbean.uninstall.sns.error", null, null);
            throw new JBIRemoteException(exception);
        }
        return sharedLibraryName;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        return this.undeployServiceAssemblyInternal(serviceAssemblyName, forceDelete, retainInDomain, targetName);
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, Level> getComponentLoggerLevels(String componentName, String targetName, String targetInstanceName) throws JBIRemoteException {
        HashMap<String, Level> resultObject = new HashMap<String, Level>();
        JBIAdminCommandsUIMBeanImpl.logDebug("Get Component Logger Levels ");
        ObjectName extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, "domain");
        this.checkForValidTarget(extensionMBeanObjectName, "domain");
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling getLoggerMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        Map loggerMBeansMap = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getLoggerMBeanNames");
        if (loggerMBeansMap != null && (targetName != null || targetInstanceName != null)) {
            ObjectName[] filteredLoggerObjectNames = null;
            filteredLoggerObjectNames = targetInstanceName != null ? (ObjectName[])loggerMBeansMap.get(targetInstanceName) : (ObjectName[])loggerMBeansMap.get(targetName);
            if (filteredLoggerObjectNames != null && filteredLoggerObjectNames.length > 0) {
                for (int index = 0; index < filteredLoggerObjectNames.length; ++index) {
                    String loggerName = null;
                    String logLevelString = null;
                    try {
                        this.checkForValidTarget(filteredLoggerObjectNames[index], "domain");
                        loggerName = (String)this.invokeMBeanOperation(filteredLoggerObjectNames[index], "getLoggerName");
                        logLevelString = (String)this.invokeMBeanOperation(filteredLoggerObjectNames[index], "getLogLevel");
                        resultObject.put(loggerName, Level.parse(logLevelString));
                        continue;
                    }
                    catch (JBIRemoteException exception) {
                        JBIAdminCommandsUIMBeanImpl.logDebug(exception.getMessage());
                        continue;
                    }
                    catch (RuntimeException exception) {
                        JBIAdminCommandsUIMBeanImpl.logDebug(exception.getMessage());
                    }
                }
            }
        } else {
            Exception exception = this.createManagementException("ui.mbean.extension.getLoggerMBeanNames.error", null, null);
            throw new JBIRemoteException(exception);
        }
        return resultObject;
    }

    @Override
    public void setComponentLoggerLevel(String componentName, String loggerCustomName, Level logLevel, String targetName, String targetInstanceName) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Set Component Logger Levels ");
        ObjectName extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, "domain");
        this.checkForValidTarget(extensionMBeanObjectName, "domain");
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling getLoggerMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        Map loggerMBeansMap = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getLoggerMBeanNames", loggerCustomName);
        if (loggerMBeansMap != null && (targetName != null || targetInstanceName != null)) {
            ObjectName[] filteredLoggerObjectNames = null;
            filteredLoggerObjectNames = targetInstanceName != null ? (ObjectName[])loggerMBeansMap.get(targetInstanceName) : (ObjectName[])loggerMBeansMap.get(targetName);
            if (filteredLoggerObjectNames != null && filteredLoggerObjectNames.length > 0) {
                for (int index = 0; index < filteredLoggerObjectNames.length; ++index) {
                    try {
                        this.checkForValidTarget(filteredLoggerObjectNames[index], "domain");
                        if (null == logLevel) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setDefault");
                        }
                        if (Level.ALL.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setAll");
                        }
                        if (Level.CONFIG.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setConfig");
                        }
                        if (Level.FINE.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setFine");
                        }
                        if (Level.FINER.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setFiner");
                        }
                        if (Level.FINEST.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setFinest");
                        }
                        if (Level.INFO.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setInfo");
                        }
                        if (Level.OFF.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setOff");
                        }
                        if (Level.SEVERE.equals(logLevel)) {
                            this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setSevere");
                        }
                        if (!Level.WARNING.equals(logLevel)) continue;
                        this.invokeMBeanOperation(filteredLoggerObjectNames[index], "setWarning");
                        continue;
                    }
                    catch (JBIRemoteException exception) {
                        JBIAdminCommandsUIMBeanImpl.logDebug(exception.getMessage());
                        continue;
                    }
                    catch (RuntimeException exception) {
                        JBIAdminCommandsUIMBeanImpl.logDebug(exception.getMessage());
                    }
                }
            }
        } else {
            Exception exception = this.createManagementException("ui.mbean.extension.getLoggerMBeanNames.error", null, null);
            throw new JBIRemoteException(exception);
        }
    }

    @Override
    public Map<String, ObjectName[]> getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws JBIRemoteException {
        Map resultObject = null;
        JBIAdminCommandsUIMBeanImpl.logDebug("Get Component Extension MBeans ");
        ObjectName extensionMBeanObjectName = null;
        try {
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, "domain");
        }
        catch (JBIRemoteException exception) {
            // empty catch block
        }
        if (extensionMBeanObjectName == null) {
            return resultObject;
        }
        this.checkForValidTarget(extensionMBeanObjectName, "domain");
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling getCustomMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        resultObject = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getCustomMBeanNames", extensionName);
        return resultObject;
    }

    @Override
    public ObjectName[] getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName, String targetInstanceName) throws JBIRemoteException {
        ObjectName[] resultObject = null;
        Map customMBeansMap = null;
        JBIAdminCommandsUIMBeanImpl.logDebug("Get Component Extension MBeans ");
        ObjectName extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, "domain");
        if (extensionMBeanObjectName == null) {
            return resultObject;
        }
        this.checkForValidTarget(extensionMBeanObjectName, "domain");
        JBIAdminCommandsUIMBeanImpl.logDebug("Calling getCustomMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        customMBeansMap = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getCustomMBeanNames", extensionName);
        if (customMBeansMap != null && (targetName != null || targetInstanceName != null)) {
            resultObject = targetInstanceName != null ? (ObjectName[])customMBeansMap.get(targetInstanceName) : (ObjectName[])customMBeansMap.get(targetName);
        }
        return resultObject;
    }

    @Override
    public Map<String, Properties> getComponentConfiguration(String componentName, String targetName) throws JBIRemoteException {
        HashMap<String, Properties> result = new HashMap();
        result = this.getComponentConfigurationProperties(componentName, targetName);
        Map<String, ObjectName[]> extensionMBeanObjectNamesMap = null;
        extensionMBeanObjectNamesMap = this.getComponentExtensionMBeanObjectNames(componentName, "Configuration", targetName);
        if (extensionMBeanObjectNamesMap == null || extensionMBeanObjectNamesMap.isEmpty()) {
            return result;
        }
        Set<Map.Entry<String, ObjectName[]>> entrySet = extensionMBeanObjectNamesMap.entrySet();
        for (Map.Entry<String, ObjectName[]> targetExtensionEntry : entrySet) {
            ObjectName[] objectNames;
            String targetInstanceName = targetExtensionEntry.getKey();
            for (ObjectName objectName : objectNames = targetExtensionEntry.getValue()) {
                if (objectName == null || !this.isValidTarget(objectName)) continue;
                Properties properties = this.getExtensionMBeanAttributeValues(objectName);
                Properties originalProperties = (Properties)result.get(targetInstanceName);
                if (originalProperties != null && null == originalProperties.getProperty("com.sun.jbi.cluster.instance.error")) {
                    for (Object keyObject : properties.keySet()) {
                        String value;
                        String key = (String)keyObject;
                        if (key == null || (value = properties.getProperty(key)) == null) continue;
                        originalProperties.put(key, value);
                    }
                    if (targetInstanceName == null || originalProperties == null) continue;
                    result.put(targetInstanceName, originalProperties);
                    continue;
                }
                if (targetInstanceName == null || originalProperties == null) continue;
                result.put(targetInstanceName, properties);
            }
        }
        return result;
    }

    @Override
    public Properties setComponentConfiguration(String componentName, Properties configurationValues, String targetName) throws JBIRemoteException {
        Properties result = null;
        result = this.setComponentConfigurationProperties(componentName, configurationValues, targetName);
        AttributeList list = null;
        Map<String, ObjectName[]> extensionMBeanObjectNamesMap = null;
        extensionMBeanObjectNamesMap = this.getComponentExtensionMBeanObjectNames(componentName, "Configuration", targetName);
        if (extensionMBeanObjectNamesMap == null || extensionMBeanObjectNamesMap.isEmpty()) {
            return result;
        }
        Set<Map.Entry<String, ObjectName[]>> entrySet = extensionMBeanObjectNamesMap.entrySet();
        for (Map.Entry<String, ObjectName[]> targetExtensionEntry : entrySet) {
            ObjectName[] objectNames;
            String targetInstanceName = targetExtensionEntry.getKey();
            for (ObjectName objectName : objectNames = targetExtensionEntry.getValue()) {
                if (objectName == null || !this.isValidTarget(objectName)) continue;
                try {
                    list = this.constructMBeanAttributes(objectName, configurationValues);
                    this.setMBeanAttributes(objectName, list);
                    result.put(targetInstanceName, componentName);
                }
                catch (Exception ex) {
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.set.attrs.error", null, ex);
                    JBIRemoteException remoteException = new JBIRemoteException(exception);
                    result.put(targetInstanceName, remoteException.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public String updateComponent(String componentName, String zipFilePath) throws JBIRemoteException {
        JBIAdminCommandsUIMBeanImpl.logDebug("Updating Component zip file " + zipFilePath);
        String fileURIString = null;
        File file = new File(zipFilePath);
        fileURIString = file.getAbsolutePath();
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName("domain");
        this.checkForValidTarget(installerServiceObjectName, "domain");
        Object[] params = new Object[]{componentName, fileURIString};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        this.invokeMBeanOperation(installerServiceObjectName, "upgradeComponent", params, signature);
        return componentName;
    }

    @Override
    public boolean isTargetUp(String targetName) throws JBIRemoteException {
        boolean isTargetUp = false;
        Set<String> clusters = this.getPlatformContext().getClusterNames();
        Set<String> servers = this.getPlatformContext().getStandaloneServerNames();
        if (clusters.contains(targetName)) {
            Set<String> serversInCluster = this.getPlatformContext().getServersInCluster(targetName);
            for (String instanceName : serversInCluster) {
                if (!this.getPlatformContext().isInstanceUp(instanceName)) continue;
                isTargetUp = true;
                break;
            }
        } else if (servers.contains(targetName)) {
            isTargetUp = this.getPlatformContext().isInstanceUp(targetName);
        }
        return isTargetUp;
    }

    @Override
    public Properties getRuntimeConfigurationMetaData(String propertyKeyName) throws JBIRemoteException {
        Map<String, Properties> metadata = null;
        metadata = this.getRuntimeConfigurationMetadataInternal("domain");
        return metadata.get(propertyKeyName);
    }

    @Override
    public boolean setRuntimeConfiguration(Properties parameters, String targetName) throws JBIRemoteException {
        return this.setRuntimeConfigurationInternal(parameters, targetName);
    }

    @Override
    public Properties getRuntimeConfiguration(String targetName) throws JBIRemoteException {
        return this.getRuntimeConfigurationInternal(targetName);
    }

    @Override
    public Properties getDefaultRuntimeConfiguration() throws JBIRemoteException {
        return this.getDefaultRuntimeConfigurationInternal("domain");
    }

    @Override
    public boolean isServerRestartRequired() throws JBIRemoteException {
        return false;
    }

    private String getStackTrace(JBIRemoteException exception) {
        String buffer = "";
        if (exception != null) {
            JBIManagementMessage message = exception.extractJBIManagementMessage();
            if (message != null) {
                buffer = message.getStackTrace();
            }
            if (buffer == null || buffer.trim().length() == 0) {
                int index;
                Object[] elements;
                buffer = "";
                StringBuffer cause = exception.getCauseStackTrace();
                if (cause != null) {
                    buffer = buffer + AbstractUIMBeanImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.caused.by.info") + ":\n" + cause.toString();
                    buffer = buffer + "\n";
                } else {
                    elements = exception.getCauseMessageTrace();
                    if (elements != null) {
                        buffer = buffer + AbstractUIMBeanImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.caused.by.info") + ":\n";
                        for (index = 0; index < elements.length; ++index) {
                            if (elements[index] == null) continue;
                            buffer = buffer + ((String)elements[index]).toString();
                            buffer = buffer + "\n";
                        }
                    }
                }
                elements = exception.getStackTrace();
                if (elements != null) {
                    buffer = buffer + AbstractUIMBeanImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.stack.trace.info") + ":\n";
                    for (index = 0; index < elements.length; ++index) {
                        if (elements[index] == null) continue;
                        buffer = buffer + ((StackTraceElement)elements[index]).toString();
                        buffer = buffer + "\n";
                    }
                }
            }
        }
        return buffer;
    }

    public static void main(String[] args) {
    }
}

