/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl2.impl;

import com.sun.jbi.wsdl2.Binding;
import com.sun.jbi.wsdl2.Endpoint;
import com.sun.jbi.wsdl2.Interface;
import com.sun.jbi.wsdl2.impl.BindingImpl;
import com.sun.jbi.wsdl2.impl.DescriptionImpl;
import com.sun.jbi.wsdl2.impl.EndpointImpl;
import com.sun.jbi.wsdl2.impl.Service;
import com.sun.jbi.wsdl2.impl.XmlBeansUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlOptions;
import org.w3.x2006.x01.wsdl.EndpointType;
import org.w3.x2006.x01.wsdl.ServiceType;
import org.w3c.dom.DocumentFragment;

final class ServiceImpl
extends Service {
    private DescriptionImpl mContainer;
    private static Map sWsdlAttributeQNames = null;

    protected DescriptionImpl getContainer() {
        return this.mContainer;
    }

    private ServiceImpl(ServiceType bean, DescriptionImpl defs) {
        super(bean);
        this.mContainer = defs;
    }

    static synchronized Map getAttributeNameMap() {
        if (sWsdlAttributeQNames == null) {
            sWsdlAttributeQNames = XmlBeansUtil.getAttributesMap(ServiceType.type);
        }
        return sWsdlAttributeQNames;
    }

    public Map getWsdlAttributeNameMap() {
        return ServiceImpl.getAttributeNameMap();
    }

    public QName getQName() {
        return new QName(this.mContainer.getTargetNamespace(), this.getName());
    }

    public String getName() {
        return this.getBean().getName();
    }

    public void setName(String theName) {
        this.getBean().setName(theName);
    }

    public String getTargetNamespace() {
        return this.mContainer.getTargetNamespace();
    }

    public Interface getInterface() {
        QName name = this.getBean().getInterface();
        return this.mContainer.findInterface(name);
    }

    public void setInterface(Interface theInterface) {
        QName name = null;
        if (theInterface != null) {
            name = new QName(theInterface.getTargetNamespace(), theInterface.getName());
        }
        this.getBean().setInterface(name);
    }

    public int getEndpointsLength() {
        return this.getBean().sizeOfEndpointArray();
    }

    public Endpoint getEndpoint(int index) {
        return EndpointImpl.Factory.getInstance(this.getBean().getEndpointArray(index), this.mContainer);
    }

    public void setEndpoint(int index, Endpoint theEndpoint) {
        this.getBean().setEndpointArray(index, theEndpoint != null ? ((EndpointImpl)theEndpoint).getBean() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendEndpoint(Endpoint theEndpoint) {
        Object object = this.getBean().monitor();
        synchronized (object) {
            this.setEndpoint(this.getEndpointsLength(), theEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint removeEndpoint(int index) {
        Endpoint result;
        Object object = this.getBean().monitor();
        synchronized (object) {
            result = this.getEndpoint(index);
            this.getBean().removeEndpoint(index);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint addNewEndpoint(String name, Binding binding) {
        EndpointType epBean = this.getBean().addNewEndpoint();
        Object object = epBean.monitor();
        synchronized (object) {
            epBean.setName(name);
            if (binding != null) {
                epBean.setBinding(((BindingImpl)binding).getQName());
            }
        }
        return EndpointImpl.Factory.getInstance(epBean, this.mContainer);
    }

    public String toXmlString() {
        StringWriter sw = new StringWriter();
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        options.setSaveOuter();
        try {
            this.getBean().save(sw, options);
            sw.close();
        }
        catch (IOException ex) {
            sw.write("\n<!-- IO error: ");
            sw.write(ex.getMessage());
            sw.write("\n     Document fragment truncated. -->\n");
        }
        return sw.getBuffer().toString();
    }

    public DocumentFragment toXmlDocumentFragment() {
        XmlOptions options = new XmlOptions();
        options.setSaveOuter();
        return (DocumentFragment)this.getBean().newDomNode(options);
    }

    static class Factory {
        Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ServiceImpl getInstance(ServiceType bean, DescriptionImpl defs) {
            ServiceImpl result;
            if (bean != null) {
                Map map;
                Map map2 = map = defs.getServiceMap();
                synchronized (map2) {
                    result = (ServiceImpl)map.get(bean);
                    if (result == null) {
                        result = new ServiceImpl(bean, defs);
                        map.put(bean, result);
                    }
                }
            } else {
                result = null;
            }
            return result;
        }
    }
}

