/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class Util {
    public static ClassLoader getClassLoader(Object obj) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = obj != null ? obj.getClass().getClassLoader() : ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static Class getClass(Object obj) throws ClassNotFoundException {
        if (obj == null || obj instanceof Class) {
            return (Class)obj;
        }
        Class<?> cls = null;
        if (obj instanceof String) {
            ClassLoader loader = Util.getClassLoader(obj);
            cls = loader.loadClass((String)obj);
        } else {
            cls = obj.getClass();
        }
        return cls;
    }

    public static Properties mapToProperties(Map map) {
        if (map == null || map instanceof Properties) {
            return (Properties)map;
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)map);
        return props;
    }

    public static Locale getLocale(FacesContext context) {
        UIViewRoot root;
        Locale locale = null;
        if (context != null && (root = context.getViewRoot()) != null) {
            locale = root.getLocale();
        }
        return locale == null ? Locale.getDefault() : locale;
    }

    public static String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        block5: for (char ch : str.toCharArray()) {
            switch (ch) {
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    protected static String stripLeadingDelimeter(String str, char ch) {
        if (str == null || str.equals("")) {
            return str;
        }
        int j = 0;
        char[] strArr = str.toCharArray();
        for (int i = 0; i < strArr.length; ++i) {
            j = i;
            if (strArr[i] != ch) break;
        }
        return str.substring(j);
    }
}

