/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.GenericHttpNotificationForwarder;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpsConnectorServerMBean;
import com.sun.jdmk.comm.HttpsNotificationForwarder;
import com.sun.jdmk.comm.HttpsSocket;
import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HttpsConnectorServer
extends GenericHttpConnectorServer
implements HttpsConnectorServerMBean {
    private int timeout = 60000;
    private boolean needClientAuth = true;

    public HttpsConnectorServer() {
        super(5, 8084);
    }

    public HttpsConnectorServer(int port) {
        super(5, port);
    }

    public HttpsConnectorServer(int port, AuthInfo[] authInfoList) {
        super(5, port, authInfoList);
    }

    public HttpsConnectorServer(int port, InetAddress bindAddr) {
        super(5, port, bindAddr);
    }

    public HttpsConnectorServer(int port, AuthInfo[] authInfoList, InetAddress bindAddr) {
        super(5, port, authInfoList, bindAddr);
    }

    public HttpsConnectorServer(int port, AuthInfo[] authInfoList, InetAddress bindAddr, boolean needClientAuth) {
        super(5, port, authInfoList, bindAddr);
        this.needClientAuth = needClientAuth;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            name = new ObjectName("DefaultDomain:name=HttpsConnectorServer");
        }
        return super.preRegister(server, name);
    }

    GenericHttpSocket createSocket() {
        HttpsSocket https_socket = new HttpsSocket(0, null, this.getNeedClientAuth());
        https_socket.setTimeout(this.getTimeout());
        return https_socket;
    }

    GenericHttpNotificationForwarder getNotificationForwarder(GenericHttpConnectorAddress address) {
        return new HttpsNotificationForwarder(address);
    }

    public String getProtocol() {
        return "https";
    }

    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int value) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = value;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(value);
        }
    }

    public final boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    String makeDebugTag() {
        return "HttpsConnectorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

