/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.launch;

import com.sun.enterprise.admin.servermgmt.launch.ASLauncherConfig;
import com.sun.enterprise.admin.servermgmt.launch.ASLauncherException;
import com.sun.enterprise.admin.servermgmt.launch.TokenResolver;
import com.sun.enterprise.admin.util.JvmOptionsHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.natives.NativeUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;

public class ASLauncher {
    protected static final String RELATIVE_LOCATION_DOMAIN_XML = "/config/domain.xml";
    protected static final String CLASSPATH_ENV_NAME = "CLASSPATH";
    protected static final String LAUNCHER_SCRIPT_LOCATION = "bin";
    protected static final String LAUNCHER_START_ACTION = "start";
    protected static final String LAUNCHER_STOP_ACTION = "stop";
    protected static final String INTERNAL_SERVER_PROFILE = "s1as8-server";
    protected static final String AS9_INTERNAL_SERVER_PROFILE = "as9-server";
    protected static final String INTERNAL_NODE_AGENT_PROFILE = "s1as8-nodeagent";
    protected static final int SLEEP_TIME_FOR_PROCESS_START = 2000;
    protected static final String COMMAND_LINE_ARG_VERBOSE = "verbose";
    protected static final String COMMAND_LINE_ARG_DEBUG = "debug";
    protected static final String COMMAND_LINE_ARG_DISPLAY = "display";
    protected static final String COMMAND_LINE_ARG_NATIVE = "native";
    protected static final char[] COMMAND_DELIMITER_LIST = new char[]{'|', '+', '^', '@', '!', '?', '*', '%', '$', '#', '(', ')', '~', '`', '{', '}', '[', ']', '<', '>', '\u007f'};
    public static final String DEBUG_OPTIONS = "com.sun.aas.jdwpOptions";
    public static final String VERBOSE_SYSTEM_PROPERTY = "com.sun.aas.verboseMode";
    public static final String LOGFILE_SYSTEM_PROPERTY = "com.sun.aas.defaultLogFile";
    public static final String PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY = "com.sun.aas.promptForIdentity";
    public static final String SPARC = "sparc";
    public static final String SPARCV9 = "sparcv9";
    public static final String X86 = "x86";
    public static final String AMD64 = "amd64";
    public static final String JVM_OPTION_FOR_64BIT = "-d64";
    private static final String CLASSPATH_PREFIX_PROPERTY = "com.sun.aas.ClassPathPrefix";
    private static final String CLASSPATH_SUFFIX_PROPERTY = "com.sun.aas.ClassPathSuffix";
    private static final String SERVER_CLASSPATH_PROPERTY = "com.sun.aas.ServerClassPath";
    private static final String UNDEFINED_ACTION = "undefined_action";
    private static final String ERROR_FLUSHER = "Error Stream Flusher";
    private static final String OUT_FLUSHER = "Output Stream Flusher";
    private static final String DOMAIN_NAME_XML_PROPERTY = "administrative.domain.name";
    private static final String DOMAIN_NAME_SYSTEM_PROPERTY = "domain.name";
    private static final String SCRIPT_PATH_SYSTEM_PROPERTY = "com.sun.aas.scriptpath";
    int _returnValue = 1;
    String[] securityInfo;
    private static final Level FINE_LEVEL = Level.FINE;
    private Logger _logger = null;
    private String[] _args = null;
    private static boolean bDebug = false;
    private boolean refreshConfigContext = true;
    FileHandler externalLogfileHandler;
    private static final String APPSERV_LAUNCH_JAR = "appserv-launch.jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int returnValue = 1;
        ASLauncher pl = null;
        try {
            pl = new ASLauncher();
            pl.preProcess(args);
            pl.getSecurityFromUser(args);
            Process process = pl.process(args, pl.securityInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pl != null) {
                returnValue = pl.getReturnValue();
            }
        }
        System.exit(returnValue);
    }

    int getReturnValue() {
        return this._returnValue;
    }

    public static void bootstrap(String[] args) {
        ASLauncher pl = new ASLauncher();
        String profile = "s1as-deploytool";
        if (args != null && args.length >= 1) {
            profile = args[0];
            String[] newArgs = new String[args.length - 1];
            for (int ii = 0; ii < newArgs.length; ++ii) {
                newArgs[ii] = args[ii + 1];
            }
            args = newArgs;
        }
        System.setProperty("com.sun.aas.processName", profile);
        if (bDebug) {
            System.out.println("bootstrapping profile - " + profile);
        }
        pl.process(args);
    }

    public void preProcess(String[] args, Properties extraProps) throws ASLauncherException {
        boolean nativeLauncher = false;
        boolean verbose = false;
        this.readASEnv();
        for (String arg : args) {
            if (COMMAND_LINE_ARG_DISPLAY.equalsIgnoreCase(arg)) {
                nativeLauncher = true;
            }
            if (!COMMAND_LINE_ARG_VERBOSE.equalsIgnoreCase(arg)) continue;
            verbose = true;
        }
        Enumeration<?> keys = extraProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = extraProps.getProperty(key);
            System.setProperty(key, value);
        }
        this.setInstanceRoot(extraProps);
        if (extraProps.getProperty("JAVA_HOME") == null) {
            System.setProperty("JAVA_HOME", System.getProperty("com.sun.aas.javaRoot"));
        }
        if (extraProps.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", "com.sun.enterprise.server.logging.ServerLogManager");
        }
        if (extraProps.getProperty("com.sun.enterprise.config.config_environment_factory_class") == null) {
            System.setProperty("com.sun.enterprise.config.config_environment_factory_class", "com.sun.enterprise.config.serverbeans.AppserverConfigEnvironmentFactory");
        }
        if (extraProps.getProperty("com.sun.aas.processName") == null) {
            System.setProperty("com.sun.aas.processName", AS9_INTERNAL_SERVER_PROFILE);
        }
        if (extraProps.getProperty("com.sun.aas.launcherReturn") == null) {
            if (verbose && nativeLauncher) {
                System.setProperty("com.sun.aas.launcherReturn", "hold");
            } else {
                System.setProperty("com.sun.aas.launcherReturn", "return");
            }
        }
    }

    public void setRefreshConfigContext(boolean refresh) {
        this.refreshConfigContext = refresh;
    }

    public boolean getRefreshConfigContext() {
        return this.refreshConfigContext;
    }

    void preProcess(String[] args) throws ASLauncherException {
        String irpTag = "com.sun.aas.instanceRoot";
        String procNameTag = "com.sun.aas.processName";
        String inTag = "com.sun.aas.instanceName";
        String rootTag = "com.sun.aas.installRoot";
        String retTag = "com.sun.aas.launcherReturn";
        Properties props = new Properties();
        this.copySystemProp(props, irpTag);
        this.copySystemProp(props, procNameTag);
        this.copySystemProp(props, inTag);
        this.copySystemProp(props, rootTag);
        this.copySystemProp(props, retTag);
        this.preProcess(args, props);
    }

    private void copySystemProp(Properties to, String name) {
        String val = System.getProperty(name);
        if (val != null) {
            to.setProperty(name, val);
        }
    }

    public void process(String[] args) {
        this.process(args, null);
    }

    public Process process(String[] args, String[] SecurityInfo) {
        Process process = null;
        try {
            this._returnValue = 1;
            this.securityInfo = SecurityInfo;
            if (this.securityInfo != null) {
                System.setProperty(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY, "true");
            }
            this.setArgs(args);
            if (System.getProperty("Debug") != null) {
                bDebug = true;
            }
            if (this.isVerboseEnabled() && !this.isDisplayEnabled()) {
                System.setProperty(VERBOSE_SYSTEM_PROPERTY, "true");
            }
            String passArg = null;
            passArg = args != null && args.length >= 1 ? args[0] : LAUNCHER_START_ACTION;
            if (bDebug) {
                System.out.println("ASLauncher Building command ..");
            }
            Command command = this.buildCommand(passArg);
            if (bDebug) {
                System.out.println("ASLauncher Executing command ..");
            }
            this._returnValue = 0;
            if (this.externalLogfileHandler != null) {
                this.getLogger().removeHandler(this.externalLogfileHandler);
                this.externalLogfileHandler.close();
                this.externalLogfileHandler = null;
            }
            process = this.executeCommand(command, passArg);
        }
        catch (ConfigException ce) {
            this.getLogger().log(Level.SEVERE, "launcher.config_exception", ce);
            ce.printStackTrace();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "enterprise.launcher_exception_startup", e);
            e.printStackTrace();
        }
        return process;
    }

    public Process executeCommand(Command command, String action) throws IOException {
        int ii;
        String[] cmd = null;
        if (!this.isDisplayEnabled()) {
            return this.executeBackgroundCommand(command, this.isVerboseEnabled(), action);
        }
        command.removeArg(COMMAND_LINE_ARG_DISPLAY);
        command.removeArg(COMMAND_LINE_ARG_NATIVE);
        String launcherRet = System.getProperty("com.sun.aas.launcherReturn");
        if (launcherRet != null) {
            if (bDebug) {
                System.out.println("-Dcom.sun.aas.launcherReturn=" + launcherRet);
            }
            command.addSystemVariable("com.sun.aas.launcherReturn", launcherRet);
        }
        cmd = command.getCommandInJNIFormatAsArray();
        boolean found = false;
        String sxDelim = "|";
        for (ii = 0; ii < COMMAND_DELIMITER_LIST.length; ++ii) {
            found = false;
            for (int jj = 0; jj < cmd.length; ++jj) {
                if (bDebug) {
                    System.out.println(COMMAND_DELIMITER_LIST[ii] + " - " + cmd[jj]);
                }
                if (cmd[jj].indexOf(COMMAND_DELIMITER_LIST[ii]) < 0) continue;
                found = true;
                break;
            }
            if (bDebug) {
                System.out.println("\n***Delimiter = " + found + "\n");
            }
            if (found) continue;
            sxDelim = String.valueOf(COMMAND_DELIMITER_LIST[ii]);
            break;
        }
        if (found) {
            this.getLogger().log(Level.SEVERE, "launcher.native_launcher_delimiter_error");
        }
        System.out.print("STARTOFCOMMAND" + sxDelim);
        for (ii = 0; ii < cmd.length; ++ii) {
            System.out.print(cmd[ii] + sxDelim);
        }
        System.out.print("ENDOFCOMMAND" + sxDelim);
        return null;
    }

    protected void preBuildProcessing() {
    }

    public Process executeBackgroundCommand(Command command, boolean verbose, String action) throws IOException {
        this.getLogger().log(FINE_LEVEL, "ASLauncher: executing Runtime execute...");
        String[] cmd = command.getCommandAsArray();
        ProcessBuilder pb = new ProcessBuilder(cmd);
        File configDir = new File(System.getProperty("com.sun.aas.instanceRoot") + "/config");
        if (FileUtils.safeIsDirectory(configDir)) {
            pb.directory(configDir);
        }
        Process process = pb.start();
        if (Boolean.getBoolean(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY) && action.equals(LAUNCHER_START_ACTION)) {
            if (this.securityInfo == null) {
                this.sendInputToProcessInput(System.in, process);
            } else {
                this.writeSecurityInfoToProcess(process);
            }
        }
        StreamFlusher sfErr = new StreamFlusher(process.getErrorStream(), System.err, command.getLogFile());
        Thread sfErrThread = new Thread((Runnable)sfErr, ERROR_FLUSHER);
        sfErrThread.setDaemon(true);
        sfErrThread.start();
        if (verbose || this.isWaitEnabled()) {
            StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), System.out, command.getLogFile());
            Thread sfOutThread = new Thread((Runnable)sfOut, OUT_FLUSHER);
            sfOutThread.setDaemon(true);
            sfOutThread.start();
            try {
                process.waitFor();
                sfOutThread.join();
                sfErrThread.join();
            }
            catch (InterruptedException ie) {
                System.out.println("While waiting in verbose mode, an InterruptedException was thrown ");
            }
        } else {
            StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), System.out);
            Thread sfOutThread = new Thread((Runnable)sfOut, OUT_FLUSHER);
            sfOutThread.setDaemon(true);
            sfOutThread.start();
            String logFile = command.getLogFile();
            if (logFile != null) {
                System.out.println(StringManager.getManager(ASLauncher.class).getString("launcher.redirecting.output", (Object)logFile));
            }
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInputToProcessInput(InputStream in, Process subProcess) {
        if (in == null || subProcess == null) {
            return;
        }
        PrintWriter out = null;
        BufferedReader br = null;
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(subProcess.getOutputStream())));
            br = new BufferedReader(new InputStreamReader(System.in));
            if (br.ready()) {
                String sxLine = null;
                while ((sxLine = br.readLine()) != null) {
                    out.println(sxLine);
                    if (!bDebug) continue;
                    System.out.println("Feeding in Line:" + sxLine);
                }
            } else {
                out.println("");
                out.println("");
                out.println("changeit");
            }
            out.flush();
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "WRITE TO INPUT ERROR", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    public Command buildCommand(String action) throws ConfigException {
        this.preBuildProcessing();
        String processName = System.getProperty("com.sun.aas.processName", INTERNAL_SERVER_PROFILE);
        Command command = null;
        command = this.isServerProfile() ? this.buildInternalCommand(action) : this.buildExternalCommand(action);
        command.reorder();
        String finalCommand = command.toStringWithLines();
        this.getLogger().log(Level.INFO, finalCommand);
        return command;
    }

    public Command buildInternalCommand(String action) throws ConfigException {
        String locale;
        StringManager _strMgr = StringManager.getManager(ASLauncher.class);
        String domainXMLLocation = System.getProperty("com.sun.aas.instanceRoot") + RELATIVE_LOCATION_DOMAIN_XML;
        ConfigContext configCtxt = this.getRefreshConfigContext() ? ConfigFactory.createConfigContext((String)domainXMLLocation, (boolean)true, (boolean)false, (boolean)false) : ConfigFactory.createConfigContext((String)domainXMLLocation, (boolean)true, (boolean)false, (boolean)true);
        Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configCtxt);
        this.setDomainName(domain);
        String serverName = System.getProperty("com.sun.aas.instanceName");
        Server server = ServerHelper.getServerByName((ConfigContext)configCtxt, (String)serverName);
        String configRef = server.getConfigRef();
        Command command = new Command();
        Config config = ServerHelper.getConfigForServer((ConfigContext)configCtxt, (String)serverName);
        String logFile = this.configureLogService(config);
        if (bDebug) {
            System.out.println("LOGFILE = " + logFile);
        }
        this.createFileStructure(logFile);
        command.setLogFile(logFile);
        this.addLogFileToLogger(logFile);
        command.addSystemVariable(LOGFILE_SYSTEM_PROPERTY, logFile);
        this.getLogger().log(FINE_LEVEL, "Retrieved domain.xml from " + domainXMLLocation);
        this.getLogger().log(FINE_LEVEL, "Start building the command the to execute.");
        if (this.isVerboseEnabled()) {
            command.addSystemVariable(VERBOSE_SYSTEM_PROPERTY, "true");
            System.setProperty(VERBOSE_SYSTEM_PROPERTY, "true");
        }
        String launcherConfigFile = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "processLauncher.xml";
        String processName = System.getProperty("com.sun.aas.processName", INTERNAL_SERVER_PROFILE);
        this.getLogger().log(FINE_LEVEL, "Loading ASLauncher config from: " + launcherConfigFile + " - for the process named: " + processName);
        ASLauncherConfig plConfig = new ASLauncherConfig(launcherConfigFile, processName);
        Properties systemProperties = plConfig.getSystemProperties();
        this.addSystemProperties(domain.getSystemProperty(), systemProperties);
        System.setProperty("com.sun.aas.configName", configRef);
        systemProperties.put("com.sun.aas.configName", configRef);
        JavaConfig javaConfig = config.getJavaConfig();
        String jvmCmd = javaConfig.getJavaHome() + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + "java";
        command.setJavaCommand(jvmCmd);
        Profiler profiler = javaConfig.getProfiler();
        String profilerClasspath = null;
        if (!action.equals(LAUNCHER_STOP_ACTION)) {
            if (javaConfig.isDebugEnabled() || this.isDebugEnabled()) {
                this.addDebugOptions(command, javaConfig.getDebugOptions());
            }
            if (profiler != null && profiler.isEnabled()) {
                this.addElementProperties(profiler.getElementProperty(), systemProperties);
                String[] jvmOptions = profiler.getJvmOptions();
                this.addJvmOptions(command, jvmOptions, action);
                profilerClasspath = profiler.getClasspath();
            }
        }
        if ((locale = domain.getLocale()) == null || locale.equals("")) {
            locale = System.getProperty("com.sun.aas.defaultLocale");
        }
        if (locale != null && !locale.equals("")) {
            command.addSystemVariable("com.sun.aas.defaultLocale", locale);
        }
        String[] jvmOptions = javaConfig.getJvmOptions();
        this.addJvmOptions(command, jvmOptions, action);
        this.addSystemProperties(config.getSystemProperty(), systemProperties);
        if (ServerHelper.isServerClustered((ConfigContext)configCtxt, (Server)server)) {
            Cluster cluster = ClusterHelper.getClusterForInstance((ConfigContext)configCtxt, (String)server.getName());
            this.addSystemProperties(cluster.getSystemProperty(), systemProperties);
        }
        this.addSystemProperties(server.getSystemProperty(), systemProperties);
        if (OS.isWindows()) {
            jvmCmd = jvmCmd.replace('/', '\\');
        }
        if (jvmCmd.startsWith(System.getProperty("com.sun.aas.javaRoot"))) {
            jvmCmd = null;
        }
        String classpath = this.deriveClasspath(plConfig, jvmCmd, javaConfig, profilerClasspath);
        this.getLogger().log(FINE_LEVEL, "Complete process classpath = " + classpath);
        command.setClasspath(classpath);
        command.setMainClass(plConfig.getMainClass());
        this.deriveNativeClasspath(command, javaConfig, profiler, systemProperties);
        Iterator<Object> it = systemProperties.keySet().iterator();
        String key = null;
        String property = null;
        String value = null;
        while (it.hasNext()) {
            key = (String)it.next();
            value = systemProperties.getProperty(key);
            if (key.startsWith("-")) {
                property = key;
                if (value != null && !value.equals("")) {
                    property = property + "=" + value;
                }
                command.addJvmOption(property);
                this.getLogger().log(FINE_LEVEL, "JVM Option: " + property);
                continue;
            }
            property = "-D" + key + "=" + value;
            command.addSystemVariable(key, value);
            this.getLogger().log(FINE_LEVEL, "System Property: " + property);
        }
        if (this.getProcessLauncherProfile().equals(AS9_INTERNAL_SERVER_PROFILE)) {
            String classpathPrefix = javaConfig.getClasspathPrefix();
            String classpathSuffix = this.getClasspathSuffix(javaConfig);
            String serverClasspath = javaConfig.getServerClasspath();
            this.getLogger().log(FINE_LEVEL, " prefix :: " + classpathPrefix + " suffix :: " + classpathSuffix);
            if (classpathPrefix == null) {
                classpathPrefix = "";
            }
            command.addSystemVariable(CLASSPATH_PREFIX_PROPERTY, classpathPrefix);
            if (classpathSuffix == null) {
                classpathSuffix = "";
            }
            command.addSystemVariable(CLASSPATH_SUFFIX_PROPERTY, classpathSuffix);
            if (serverClasspath == null) {
                serverClasspath = "";
            }
            command.addSystemVariable(SERVER_CLASSPATH_PROPERTY, serverClasspath);
        }
        this.setPromptForIdentity(command);
        String[] args = this.getArgs();
        for (int ii = 0; ii < args.length; ++ii) {
            command.addArg(args[ii]);
        }
        return command;
    }

    public Command buildExternalCommand(String action) throws ConfigException {
        Command command = new Command();
        this.getLogger().log(FINE_LEVEL, "Start building the command the to execute.");
        String launcherConfigFile = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "processLauncher.xml";
        String processName = System.getProperty("com.sun.aas.processName", INTERNAL_NODE_AGENT_PROFILE);
        this.getLogger().log(FINE_LEVEL, "Loading ProcessLauncher config from: " + launcherConfigFile + " - for the process named: " + processName);
        String configRoot = System.getProperty("com.sun.aas.configRoot");
        if (configRoot == null) {
            configRoot = System.getProperty("com.sun.aas.installRoot") + File.separator + "config";
        }
        if (this.isVerboseEnabled()) {
            command.addSystemVariable(VERBOSE_SYSTEM_PROPERTY, "true");
            System.setProperty(VERBOSE_SYSTEM_PROPERTY, "true");
        }
        ASLauncherConfig plConfig = new ASLauncherConfig(launcherConfigFile, processName);
        Properties systemProperties = plConfig.getSystemProperties();
        String logFile = systemProperties.getProperty(LOGFILE_SYSTEM_PROPERTY);
        if (bDebug) {
            System.out.println("Is external command nodeagent - " + this.isNodeAgentProfile());
        }
        if (this.isNodeAgentProfile()) {
            this.getLogger().log(FINE_LEVEL, "BuildExternalCommand for NodeAgent");
            try {
                String domainXMLLocation = System.getProperty("com.sun.aas.instanceRoot") + RELATIVE_LOCATION_DOMAIN_XML;
                ConfigContext configCtxt = ConfigFactory.createConfigContext((String)domainXMLLocation);
                Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configCtxt);
                this.setDomainName(domain);
                String nodeAgentName = System.getProperty("com.sun.aas.instanceName");
                NodeAgent nodeAgent = NodeAgentHelper.getNodeAgentByName((ConfigContext)configCtxt, (String)nodeAgentName);
                LogService logService = nodeAgent.getLogService();
                if (logService != null) {
                    this.getLogger().log(FINE_LEVEL, "LogService found for nodeagent");
                    String logFileX = logService.getFile();
                    if (logFileX != null) {
                        logFile = logFileX;
                        systemProperties.setProperty(LOGFILE_SYSTEM_PROPERTY, logFile);
                    }
                    String logLevel = logService.getModuleLogLevels().getNodeAgent();
                    this.getLogger().setLevel(Level.parse(logLevel));
                }
            }
            catch (ConfigException ce) {
                this.getLogger().log(FINE_LEVEL, "domain.xml does not exist yet for the nodeagent");
            }
        }
        if (logFile != null) {
            if (this.createFileStructure(logFile)) {
                this.addLogFileToLogger(logFile);
            }
            command.setLogFile(logFile);
        }
        String javaHome = System.getProperty("JAVA_HOME");
        String javaCall = "java";
        String javaCmd = null;
        if (OS.isWindows()) {
            javaCall = "javaw";
        }
        if (javaHome != null) {
            javaCmd = javaHome + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + javaCall;
        } else {
            String javaInt = System.getProperty("java.home");
            javaCmd = javaInt + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + javaCall;
        }
        command.setJavaCommand(javaCmd);
        String classpath = this.deriveClasspath(plConfig, null);
        command.setClasspath(classpath);
        command.setMainClass(plConfig.getMainClass());
        Iterator<Object> it = systemProperties.keySet().iterator();
        String key = null;
        String property = null;
        String value = null;
        while (it.hasNext()) {
            key = (String)it.next();
            value = systemProperties.getProperty(key);
            if (key.startsWith("-")) {
                property = key;
                if (value != null && !value.equals("")) {
                    property = property + "=" + value;
                }
                if (key.equals("-client") || key.equals("-server")) {
                    command.setMode(key);
                    continue;
                }
                command.addJvmOption(property);
                continue;
            }
            property = "-D" + key + "=" + value;
            command.addSystemVariable(key, value);
        }
        command.addSystemVariable("java.library.path", this.deriveNativeClasspath(command, null, null, systemProperties));
        String[] args = this.getArgs();
        for (int ii = 0; ii < args.length; ++ii) {
            command.addArg(args[ii]);
        }
        return command;
    }

    protected String configureLogService(Config config) {
        String logFile = "";
        LogService logService = config.getLogService();
        if (logService != null) {
            logFile = logService.getFile();
            String logLevel = logService.getModuleLogLevels().getAdmin();
            this.getLogger().setLevel(Level.parse(logLevel));
        }
        return logFile;
    }

    protected String deriveClasspath(ASLauncherConfig plConfig, String jvmCmd) {
        return this.deriveClasspath(plConfig, jvmCmd, null, null);
    }

    protected String deriveClasspath(ASLauncherConfig plConfig, String jvmCmd, JavaConfig javaConfig, String profilerClasspath) {
        String libDir = RelativePathResolver.resolvePath((String)plConfig.getClasspathLibDir());
        String classpath = this.getPELauncherJarPath();
        String libClasspath = Classpath.getLibClasspath(libDir, plConfig.getClasspathIncludes(), plConfig.getClasspathExcludes());
        if (this.isValidString(libClasspath)) {
            classpath = classpath + File.pathSeparator + libClasspath;
        }
        this.getLogger().log(FINE_LEVEL, "Derived Classpath from " + libDir + " - \n" + classpath);
        String javaVersion = System.getProperty("java.version");
        if (jvmCmd != null) {
            try {
                Process process = Runtime.getRuntime().exec(jvmCmd + " -version");
                ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
                ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
                StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), baosOut);
                StreamFlusher sfErr = new StreamFlusher(process.getErrorStream(), baosErr);
                new Thread((Runnable)sfOut, OUT_FLUSHER).start();
                new Thread((Runnable)sfErr, ERROR_FLUSHER).start();
                process.waitFor();
                javaVersion = baosErr.toString();
            }
            catch (Exception e) {
                this.getLogger().log(FINE_LEVEL, "Java version retrieving error, will default to 1.5 or later!", e);
            }
        }
        String prefix = "";
        String jvmv = "";
        if (javaVersion.indexOf("1.4") >= 0) {
            jvmv = "j2se 1.4";
            prefix = plConfig.getClasspathJ2se14Prefix();
        } else {
            jvmv = "j2se 1.5 or later";
            prefix = plConfig.getClasspathJ2se15OrLaterPrefix();
        }
        this.getLogger().log(FINE_LEVEL, "Java version being used is: ->" + jvmv + "<- based on ->" + javaVersion + "<-");
        if (prefix != null && !prefix.equals("")) {
            prefix = RelativePathResolver.resolvePath((String)prefix);
            classpath = classpath.equals("") ? prefix : prefix + File.pathSeparator + classpath;
        }
        if ((prefix = plConfig.getClasspathPrefix()) != null && !prefix.equals("")) {
            prefix = RelativePathResolver.resolvePath((String)prefix);
            classpath = classpath.equals("") ? prefix : prefix + File.pathSeparator + classpath;
        }
        if (javaConfig != null) {
            String classpathPrefix = javaConfig.getClasspathPrefix();
            String classpathSystem = javaConfig.getSystemClasspath();
            String classpathSuffix = this.getClasspathSuffix(javaConfig);
            if (this.isValidString(classpathSystem)) {
                classpath = classpath + File.pathSeparator + classpathSystem;
            }
            if (this.getProcessLauncherProfile().equals(INTERNAL_SERVER_PROFILE)) {
                if (this.isValidString(classpathPrefix)) {
                    classpath = classpathPrefix + File.pathSeparator + classpath;
                }
                if (this.isValidString(classpathSuffix)) {
                    classpath = classpath + File.pathSeparator + classpathSuffix;
                }
            }
            if (profilerClasspath != null) {
                classpath = classpath + File.pathSeparator + profilerClasspath;
            }
        }
        this.getLogger().log(FINE_LEVEL, "Final classpath - \n" + classpath);
        if (bDebug) {
            System.out.println("Final classpath=" + classpath);
        }
        return classpath;
    }

    private boolean isValidString(String s) {
        return s != null && !s.trim().equals("");
    }

    protected String deriveNativeClasspath(Command command, JavaConfig javaConfig, Profiler profiler, Properties systemProperties) {
        String javaLibPath = System.getProperty("java.library.path");
        if (bDebug) {
            System.out.println("Current java.library.path=" + javaLibPath + "\n");
        }
        if (javaLibPath == null) {
            javaLibPath = "";
        }
        String libDirFor64Bit = "";
        if (javaConfig != null) {
            String[] jvmOptions;
            String nativePrefix = javaConfig.getNativeLibraryPathPrefix();
            String nativeSuffix = javaConfig.getNativeLibraryPathSuffix();
            String nativeProfiler = null;
            if (profiler != null && profiler.isEnabled()) {
                nativeProfiler = profiler.getNativeLibraryPath();
            }
            if (nativePrefix != null && !nativePrefix.trim().equals("")) {
                javaLibPath = nativePrefix + (javaLibPath.equals("") ? "" : File.pathSeparator + javaLibPath);
            }
            if (nativeSuffix != null && !nativeSuffix.trim().equals("")) {
                javaLibPath = (javaLibPath.equals("") ? "" : javaLibPath + File.pathSeparator) + nativeSuffix;
            }
            if (nativeProfiler != null && !nativeProfiler.trim().equals("")) {
                javaLibPath = (javaLibPath.equals("") ? "" : javaLibPath + File.pathSeparator) + nativeProfiler;
            }
            for (String s : jvmOptions = javaConfig.getJvmOptions()) {
                if (s.indexOf(JVM_OPTION_FOR_64BIT) == -1) continue;
                String osArch = System.getProperty("os.arch");
                if (osArch.equals(SPARC)) {
                    libDirFor64Bit = SPARCV9;
                } else if (osArch.equals(X86)) {
                    libDirFor64Bit = AMD64;
                }
                String nssRoot = System.getProperty("com.sun.aas.nssRoot");
                String installRoot = System.getProperty("com.sun.aas.installRoot");
                String imqLib = System.getProperty("com.sun.aas.imqLib");
                String java64BitLibPath = "";
                if (installRoot == null) continue;
                if (imqLib != null) {
                    java64BitLibPath = imqLib + File.separator + libDirFor64Bit + File.pathSeparator + java64BitLibPath;
                }
                if (installRoot != null) {
                    java64BitLibPath = installRoot + File.separator + "lib" + File.separator + libDirFor64Bit + File.pathSeparator + java64BitLibPath;
                }
                if (nssRoot != null) {
                    java64BitLibPath = nssRoot + File.separator + libDirFor64Bit + File.pathSeparator + java64BitLibPath;
                }
                javaLibPath = java64BitLibPath + File.pathSeparator + javaLibPath;
            }
        }
        if (OS.isWindows()) {
            String nssRoot = System.getProperty("com.sun.aas.nssRoot");
            String installRoot = System.getProperty("com.sun.aas.installRoot");
            if (installRoot != null && nssRoot != null) {
                javaLibPath = nssRoot + File.pathSeparator + installRoot + File.separator + "lib" + File.pathSeparator + javaLibPath;
            }
        }
        if (this.isDisplayEnabled()) {
            String java_home = null;
            java_home = javaConfig != null && javaConfig.getJavaHome() != null ? javaConfig.getJavaHome() : "com.sun.aas.javaRoot";
            String jvmLibPath = java_home + System.getProperty("com.sun.aas.nativeLauncherLibPrefix");
            if (command.getMode() != null) {
                jvmLibPath = jvmLibPath.substring(0, jvmLibPath.lastIndexOf(File.separator) + 1) + command.getMode().substring(1);
            }
            javaLibPath = javaLibPath != null ? jvmLibPath + File.pathSeparator + javaLibPath : jvmLibPath;
        }
        if (javaLibPath.indexOf(" ") >= 0) {
            String items = this.getPathItemsWithSpaces(javaLibPath);
            this.getLogger().log(FINE_LEVEL, "launcher.spacesInPath", new Object[]{items});
            javaLibPath = javaLibPath.replaceAll("\"", "");
        }
        systemProperties.put("java.library.path", javaLibPath);
        System.setProperty("java.library.path", javaLibPath);
        command.setNativeClasspath(javaLibPath);
        if (bDebug) {
            System.out.println("Final java.library.path=" + javaLibPath + "\n");
        }
        return javaLibPath;
    }

    protected void addSystemProperties(SystemProperty[] sp, Properties systemProperties) {
        if (sp != null) {
            for (int ii = 0; ii < sp.length; ++ii) {
                systemProperties.put(sp[ii].getName(), sp[ii].getValue());
            }
        }
    }

    protected void addElementProperties(ElementProperty[] ep, Properties systemProperties) {
        if (ep != null) {
            for (int ii = 0; ii < ep.length; ++ii) {
                systemProperties.put(ep[ii].getName(), ep[ii].getValue());
            }
        }
    }

    protected Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger("javax.enterprise.tools.launcher", "com.sun.logging.enterprise.system.tools.launcher.LogStrings");
            if (!this.isVerboseEnabled()) {
                Handler[] h = this._logger.getParent().getHandlers();
                for (int ii = 0; ii < h.length; ++ii) {
                    if (!h[ii].getClass().getName().equals("java.util.logging.ConsoleHandler")) continue;
                    this._logger.getParent().removeHandler(h[ii]);
                }
            }
        }
        if (bDebug) {
            this._logger.setLevel(Level.FINEST);
        }
        return this._logger;
    }

    protected boolean isInternalLogger() {
        boolean bRet = false;
        String logManager = System.getProperty("java.util.logging.manager");
        if (logManager != null && logManager.equals("com.sun.enterprise.server.logging.ServerLogManager")) {
            bRet = true;
        }
        return bRet;
    }

    protected void addLogFileToLogger(String logFile) {
        if (logFile == null) {
            return;
        }
        this.getLogger().log(FINE_LEVEL, "*** Adding logFileHandler - " + logFile);
        try {
            this.externalLogfileHandler = new FileHandler(logFile, true);
            this.externalLogfileHandler.setFormatter(new SimpleFormatter());
            this.externalLogfileHandler.setLevel(Level.ALL);
            this.getLogger().addHandler(this.externalLogfileHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addJvmOptions(Command command, String[] args, String action) {
        String systemProperty = null;
        Object property = null;
        Object value = null;
        String[] jvmOptions = null;
        try {
            jvmOptions = new JvmOptionsHelper(args).getJvmOptions();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (jvmOptions != null) {
            for (int i = 0; i < jvmOptions.length; ++i) {
                this.addJvmArg(command, jvmOptions[i], action);
            }
            return;
        }
        if (args != null) {
            block3: for (int ii = 0; ii < args.length; ++ii) {
                systemProperty = args[ii].trim();
                if (bDebug) {
                    System.out.println("addJvmOptions: IN Property " + systemProperty);
                }
                if (systemProperty.trim().equals("")) continue;
                int iSpace = 0;
                int iQuote1 = 0;
                int iQuote2 = 0;
                block4: while (systemProperty.length() > 0) {
                    iSpace = systemProperty.indexOf(" -");
                    iQuote1 = systemProperty.indexOf("\"");
                    if (iSpace >= 0) {
                        if (iQuote1 >= 0) {
                            if (iQuote1 > iSpace && iSpace >= 0) {
                                this.addJvmArg(command, systemProperty.substring(0, iSpace), action);
                                systemProperty = systemProperty.substring(iSpace + 1).trim();
                                if (!bDebug) continue;
                                System.out.println("*** left 1:" + systemProperty);
                                continue;
                            }
                            int iQuoteStartPos = iQuote1 + 1;
                            while (true) {
                                if ((iQuote2 = systemProperty.indexOf("\"", iQuoteStartPos)) < 0) {
                                    this.getLogger().log(Level.WARNING, "launcher.missMatchQuotesInArg", systemProperty);
                                    systemProperty = "";
                                    continue block4;
                                }
                                if (systemProperty.charAt(iQuote2 - 1) != '\\') break;
                                iQuoteStartPos = iQuote2 + 1;
                            }
                            if (systemProperty.indexOf(" -", iQuote2) < 0) {
                                this.addJvmArg(command, systemProperty, action);
                                systemProperty = "";
                                continue;
                            }
                            this.addJvmArg(command, systemProperty.substring(0, ++iQuote2), action);
                            if (iQuote2 < systemProperty.length()) {
                                systemProperty = systemProperty.substring(iQuote2 + 1).trim();
                                if (!bDebug) continue;
                                System.out.println("*** left 2:" + systemProperty);
                                continue;
                            }
                            systemProperty = "";
                            continue;
                        }
                        int iDel = systemProperty.indexOf(" -");
                        while (iDel >= 0) {
                            this.addJvmArg(command, systemProperty.substring(0, iDel), action);
                            systemProperty = systemProperty.substring(iDel + 1).trim();
                            iDel = systemProperty.indexOf(" -");
                        }
                        if (systemProperty.equals("")) continue block3;
                        this.addJvmArg(command, systemProperty, action);
                        continue block3;
                    }
                    this.addJvmArg(command, systemProperty, action);
                    continue block3;
                }
            }
        }
    }

    protected void addJvmArg(Command command, String option, String action) {
        if (option == null) {
            return;
        }
        if (LAUNCHER_STOP_ACTION.equals(action) && (option = this.removeJVMStopOption(option)).equals("")) {
            return;
        }
        if (option.startsWith("-D")) {
            command.addSystemVariable(option);
        } else if (option.equals("-client") || option.equals("-server")) {
            command.setMode(option);
        } else {
            command.addJvmOption(option);
        }
        if (bDebug) {
            System.out.println("addJvmOptions: OUT Property " + option);
        }
    }

    protected void addDebugOptions(Command command, String debug_options) {
        command.addDebugOption("-Xdebug");
        debug_options = debug_options.trim();
        if (debug_options.startsWith("-Xdebug")) {
            debug_options = debug_options.substring("-Xdebug".length()).trim();
        }
        String transport = this.getDebugProperty(debug_options, "transport");
        String addr = this.getDebugProperty(debug_options, "address");
        if (transport == null || transport.equals("")) {
            System.out.println("Cannot start server in debug mode: no transport specified in debug-options in domain.xml.");
        }
        if (transport.equals("dt_socket") && (addr == null || addr.equals(""))) {
            int port = NetUtils.getFreePort();
            if (port == 0) {
                System.out.println("Cannot start server in debug mode: unable to obtain a free port for transport dt_socket.");
            }
            addr = String.valueOf(port);
            debug_options = debug_options + ",address=" + addr;
        }
        command.addDebugOption(debug_options);
        String jdwpOptions = debug_options.substring(debug_options.indexOf("-Xrunjdwp:") + "-Xrunjdwp:".length());
        command.addSystemVariable(DEBUG_OPTIONS, jdwpOptions);
    }

    protected String getDebugProperty(String debug_options, String name) {
        int nameIndex = debug_options.indexOf(name);
        if (nameIndex != -1) {
            String value = debug_options.substring(nameIndex + name.length() + 1);
            int commaIndex = value.indexOf(",");
            if (commaIndex != -1) {
                value = value.substring(0, commaIndex);
            }
            return value;
        }
        return null;
    }

    protected boolean isWaitEnabled() {
        boolean bRet = false;
        String launcherRet = System.getProperty("com.sun.aas.launcherReturn");
        if (launcherRet != null && launcherRet.equals("hold")) {
            bRet = true;
        }
        return bRet;
    }

    protected boolean isVerboseEnabled() {
        return this.argExists(COMMAND_LINE_ARG_VERBOSE);
    }

    protected boolean isDebugEnabled() {
        return this.argExists(COMMAND_LINE_ARG_DEBUG);
    }

    protected boolean isDisplayEnabled() {
        return this.argExists(COMMAND_LINE_ARG_DISPLAY);
    }

    protected boolean isServerProfile() {
        String processName = this.getProcessLauncherProfile();
        return processName.equals(INTERNAL_SERVER_PROFILE) || processName.equals(AS9_INTERNAL_SERVER_PROFILE);
    }

    protected boolean isNodeAgentProfile() {
        String processName = this.getProcessLauncherProfile();
        return processName.equals(INTERNAL_NODE_AGENT_PROFILE);
    }

    protected String getFiletRelativeName(String action) {
        return System.getProperty("com.sun.aas.instanceRoot") + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + action;
    }

    protected String getProcessLauncherProfile() {
        return System.getProperty("com.sun.aas.processName", INTERNAL_SERVER_PROFILE);
    }

    protected String getScriptRelativeName(String action) {
        String sxRet = this.getFiletRelativeName(action);
        sxRet = OS.isWindows() ? sxRet + "_temp.bat" : sxRet + "_temp.sh";
        return sxRet;
    }

    protected void setArgs(String[] args) {
        ArrayList<String> processedArgs = new ArrayList<String>(args.length);
        for (String arg : args) {
            if (arg.equalsIgnoreCase(COMMAND_LINE_ARG_DEBUG)) {
                System.setProperty("Debug", "true");
            }
            processedArgs.add(arg);
        }
        this._args = processedArgs.toArray(new String[processedArgs.size()]);
    }

    protected String[] getArgs() {
        return this._args;
    }

    protected boolean argExists(String arg) {
        boolean bRet = false;
        String[] args = this.getArgs();
        if (args != null) {
            for (int ii = 0; ii < args.length; ++ii) {
                if (!args[ii].equals(arg)) continue;
                bRet = true;
                break;
            }
        }
        return bRet;
    }

    protected boolean createFileStructure(String logFile) {
        boolean bRet = false;
        File outputFile = new File(logFile);
        try {
            File parentFile = new File(outputFile.getParent());
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            if (outputFile.canWrite()) {
                bRet = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!bRet) {
            this.getLogger().log(Level.WARNING, "launcher.logWriteFailure", logFile);
        }
        return bRet;
    }

    private String getPathItemsWithSpaces(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        String ret = "";
        boolean firstItem = true;
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            if (item.indexOf(32) < 0) continue;
            if (!firstItem) {
                ret = ret + File.pathSeparator;
            } else {
                firstItem = false;
            }
            ret = ret + item;
        }
        return ret;
    }

    private String removeJVMStopOption(String jvmOption) {
        if (jvmOption.startsWith("-X")) {
            jvmOption = "";
        }
        if (jvmOption.startsWith("-server")) {
            jvmOption = "-client";
        }
        return jvmOption;
    }

    private void setPromptForIdentity(Command command) {
        String prompt = null;
        String actual = System.getProperty(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY);
        String startsWith = "-Dcom.sun.aas.promptForIdentity";
        for (String o : command._systemVariables) {
            String s = o;
            if (!s.startsWith(startsWith)) continue;
            prompt = o;
            break;
        }
        if (prompt != null) {
            command._systemVariables.remove(prompt);
        }
        if (actual != null) {
            command.addSystemVariable(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY, actual);
        }
    }

    private void readASEnv() throws ASLauncherException {
        String configRoot = System.getProperty("com.sun.aas.configRoot");
        if (configRoot == null) {
            configRoot = System.getProperty("com.sun.aas.installRoot") + File.separator + "config";
            System.setProperty("com.sun.aas.configRoot", configRoot);
        }
        if (!FileUtils.safeIsDirectory(configRoot)) {
            String message = "Can't find the AS configuration script.  This script normally lives in <install>/config and is named asenv";
            if (OS.isWindows()) {
                message = message + ".bat";
            }
            message = message + "\nYou need to set these 2 System Properties: \ncom.sun.aas.installRoot=your-install-directory\ncom.sun.aas.configRoot=your-config-directory\n";
            throw new ASLauncherException(message);
        }
        ASenvPropertyReader reader = new ASenvPropertyReader(configRoot);
        reader.setSystemProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSecurityInfoToProcess(Process p) {
        if (this.securityInfo == null) {
            return;
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(p.getOutputStream())));
            for (String s : this.securityInfo) {
                if (bDebug) {
                    System.out.println("InputLine ->" + s + "<-");
                }
                out.println(s);
            }
            out.flush();
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void setDomainName(Domain domain) throws ConfigException {
        try {
            ElementProperty ep = domain.getElementPropertyByName(DOMAIN_NAME_XML_PROPERTY);
            if (ep == null) {
                throw new ConfigException("The property, administrative.domain.name, was null");
            }
            String domainName = ep.getValue();
            if (domainName == null || domainName.length() < 1) {
                throw new ConfigException("The value of the property, administrative.domain.name, was null or empty");
            }
            System.setProperty(DOMAIN_NAME_SYSTEM_PROPERTY, domainName);
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigException("Error getting administrative.domain.name from domain.xml", (Throwable)e);
        }
    }

    void getSecurityFromUser(String[] args) throws IOException {
        if (System.getProperty("caller", "not-cli").equals("cli")) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        this.securityInfo = new String[3];
        System.out.print("admin username:");
        this.securityInfo[0] = reader.readLine();
        this.securityInfo[1] = this.getPassword(reader, "admin password:  ");
        this.securityInfo[2] = this.getPassword(reader, "master password: ");
        System.setProperty(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY, "true");
    }

    private String getPassword(BufferedReader stdin, String prompt) throws IOException {
        try {
            NativeUtils nativeUtils = new NativeUtils();
            return NativeUtils.getPassword((String)prompt);
        }
        catch (Throwable throwable) {
            System.out.print(prompt);
            return stdin.readLine();
        }
    }

    private void setInstanceRoot(Properties callerProps) throws ASLauncherException {
        String irpTag = "com.sun.aas.instanceRoot";
        String irp = callerProps.getProperty(irpTag);
        if (irp != null) {
            System.setProperty(irpTag, irp);
        }
        if ((irp = System.getProperty(irpTag)) == null || irp.length() <= 0) {
            throw new ASLauncherException("Missing System Property: " + irpTag);
        }
        File f = new File(irp);
        try {
            irp = f.getCanonicalPath();
        }
        catch (Exception e) {
            irp = f.getAbsolutePath();
        }
        System.setProperty(irpTag, irp);
    }

    private String getPELauncherJarPath() {
        return System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + APPSERV_LAUNCH_JAR;
    }

    private String getClasspathSuffix(JavaConfig cfg) {
        String userCP;
        String suffix = cfg.getClasspathSuffix();
        if (suffix == null || suffix.equals("null")) {
            suffix = "";
        }
        if (!cfg.isEnvClasspathIgnored() && (userCP = System.getenv(CLASSPATH_ENV_NAME)) != null && userCP.length() > 0) {
            if (this.isValidString(suffix)) {
                suffix = suffix + File.pathSeparator;
            }
            suffix = suffix + userCP;
            this.getLogger().log(Level.INFO, "Environmental Variable CLASSPATH's value was appended to classpath-suffix.  Here is the final classpath-suffix:\n" + suffix);
        }
        return suffix;
    }

    protected class StreamFlusher
    implements Runnable {
        private InputStream _input = null;
        private OutputStream _output = null;
        private String _logFile = null;

        public StreamFlusher(InputStream input, OutputStream output) {
            this(input, output, null);
        }

        public StreamFlusher(InputStream input, OutputStream output, String logFile) {
            this._input = input;
            this._output = output;
            this._logFile = logFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this._input == null) {
                return;
            }
            PrintStream printStream = null;
            if (this._logFile != null) {
                try {
                    if (ASLauncher.this.createFileStructure(this._logFile)) {
                        printStream = new PrintStream(new FileOutputStream(this._logFile, true), true);
                    } else {
                        this._logFile = null;
                    }
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                    this._logFile = null;
                }
            }
            try {
                int byteCnt = 0;
                byte[] buffer = new byte[4096];
                while ((byteCnt = this._input.read(buffer)) != -1) {
                    if (this._output == null || byteCnt <= 0) continue;
                    this._output.write(buffer, 0, byteCnt);
                    this._output.flush();
                    if (this._logFile == null) continue;
                    printStream.write(buffer, 0, byteCnt);
                    printStream.flush();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }
    }

    protected static class Classpath {
        protected Classpath() {
        }

        protected static String getLibClasspath(String libDir, String includes, String excludes) {
            ArrayList<String> arIncludes = new ArrayList<String>();
            ArrayList<String> arExcludes = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(includes, ",");
            while (st.hasMoreTokens()) {
                arIncludes.add(st.nextToken().trim());
            }
            st = new StringTokenizer(excludes, ",");
            while (st.hasMoreTokens()) {
                arExcludes.add(st.nextToken().trim());
            }
            String path = "";
            if (libDir != null && !libDir.equals("")) {
                File dir = new File(libDir);
                String[] filenames = dir.list();
                for (int ii = 0; ii < filenames.length; ++ii) {
                    if (!Classpath.matchStringToList(filenames[ii], arIncludes) || Classpath.matchStringToList(filenames[ii], arExcludes)) continue;
                    path = path + libDir + File.separator + filenames[ii] + File.pathSeparator;
                }
                if (path.endsWith(File.pathSeparator)) {
                    path = path.substring(0, path.length() - 1);
                }
            }
            return path;
        }

        protected static boolean matchStringToList(String filename, ArrayList list) {
            boolean bRet = false;
            String criteria2 = null;
            String endMatch = null;
            for (String criteria2 : list) {
                if (criteria2.startsWith("*")) {
                    endMatch = criteria2.substring(1);
                    if (!filename.endsWith(endMatch)) continue;
                    bRet = true;
                    break;
                }
                if (Classpath.isRegularExpression(criteria2)) {
                    if (!Pattern.matches(criteria2, filename)) continue;
                    bRet = true;
                    break;
                }
                if (!filename.equals(criteria2)) continue;
                bRet = true;
                break;
            }
            return bRet;
        }

        protected static boolean isRegularExpression(String criteria) {
            boolean bRet = false;
            if (criteria.indexOf("^") > -1 || criteria.indexOf("$") > -1 || criteria.indexOf("[") > -1 || criteria.indexOf("]") > -1 || criteria.indexOf("*") > -1) {
                bRet = true;
            }
            return bRet;
        }
    }

    protected class Command {
        private final Properties _sysProps = new Properties();
        private final ArrayList<String> _jvmOptions = new ArrayList();
        private final ArrayList<String> _systemVariables = new ArrayList();
        private final ArrayList<String> _args = new ArrayList();
        private final ArrayList<String> _debugOptions = new ArrayList();
        private String _mainClass;
        private String _classpath;
        private String _javaCommand;
        private String _mode;
        private String _logFile;
        private String _nativeClasspath;

        protected Command() {
        }

        private void resolveAll() {
            TokenResolver resolver = new TokenResolver(this._sysProps);
            resolver.resolve(this._jvmOptions);
            resolver.resolve(this._systemVariables);
            resolver.resolve(this._debugOptions);
            resolver.resolve(this._args);
            this._classpath = resolver.resolve(this._classpath);
            this._javaCommand = resolver.resolve(this._javaCommand);
            this._mode = resolver.resolve(this._mode);
            this._logFile = resolver.resolve(this._logFile);
            this._nativeClasspath = resolver.resolve(this._nativeClasspath);
            this._mainClass = resolver.resolve(this._mainClass);
        }

        protected void addJvmOption(String jvmOptions) {
            this._jvmOptions.add(jvmOptions.trim());
        }

        protected void addSystemVariable(String systemVariable) {
            if (systemVariable.length() < 3) {
                return;
            }
            String s = systemVariable.substring(2);
            int index = s.indexOf("=");
            if (index <= 0) {
                this.addSystemVariable(s, null);
            } else {
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                this.addSystemVariable(name, value);
            }
        }

        void addSystemVariable(String name, String value) {
            name = name.trim();
            if (value == null) {
                this.overwriteSystemVariable(name);
            } else {
                value = value.trim();
                this._sysProps.setProperty(name, value);
                this.overwriteSystemVariable(name, value);
            }
        }

        private void overwriteSystemVariable(String name) {
            String nameValue = "-D" + name;
            int index = this.findSystemVariable(nameValue, false);
            if (index < 0) {
                this._systemVariables.add(nameValue);
            }
        }

        private void overwriteSystemVariable(String name, String value) {
            String nameValue = "-D" + name + "=";
            int index = this.findSystemVariable(nameValue, true);
            nameValue = nameValue + value;
            if (index >= 0) {
                this._systemVariables.set(index, nameValue);
            } else {
                this._systemVariables.add(nameValue);
            }
        }

        private int findSystemVariable(String name, boolean startsWith) {
            for (int i = 0; i < this._systemVariables.size(); ++i) {
                String s = this._systemVariables.get(i);
                if (s == null) continue;
                if (startsWith && s.startsWith(name)) {
                    return i;
                }
                if (startsWith || !s.equals(name)) continue;
                return i;
            }
            return -1;
        }

        protected void addArg(String arg) {
            this._args.add(arg);
        }

        protected String[] getArgs() {
            return this._args.toArray(new String[this._args.size()]);
        }

        protected void removeArg(String arg) {
            this._args.remove(arg);
        }

        protected void addDebugOption(String debugOption) {
            this._debugOptions.add(debugOption);
        }

        protected String[] getDebugOptions() {
            return this._debugOptions.toArray(new String[this._debugOptions.size()]);
        }

        protected void setMode(String mode) {
            this._mode = mode;
        }

        protected String getMode() {
            return this._mode;
        }

        protected void setMainClass(String mainClass) {
            this._mainClass = mainClass;
        }

        protected String getMainClass() {
            return this._mainClass;
        }

        protected void setNativeClasspath(String classpath) {
            this._nativeClasspath = classpath;
        }

        protected String getNativeClasspath() {
            return this._nativeClasspath;
        }

        protected void setClasspath(String classpath) {
            this._classpath = classpath;
        }

        protected String getClasspath() {
            return this._classpath;
        }

        protected void setJavaCommand(String javaCommand) {
            this._javaCommand = javaCommand;
        }

        protected String getJavaCommand() {
            return this._javaCommand;
        }

        protected void setLogFile(String logFile) {
            if (bDebug) {
                System.out.println("Logfile set to " + logFile);
            }
            this._logFile = logFile;
        }

        protected String getLogFile() {
            return this._logFile;
        }

        protected String[] getCommandAsArray() {
            this.resolveAll();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this._javaCommand);
            cmd.addAll(this._systemVariables);
            if (this._mode != null) {
                cmd.add(this._mode);
            }
            cmd.addAll(this._debugOptions);
            cmd.addAll(this._jvmOptions);
            cmd.add("-cp");
            cmd.add(this._classpath);
            cmd.add(this._mainClass);
            cmd.addAll(this._args);
            return cmd.toArray(new String[cmd.size()]);
        }

        protected String[] getLimitedCommandAsArray() {
            this.resolveAll();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this._javaCommand);
            cmd.addAll(this._systemVariables);
            if (this._mode != null) {
                cmd.add(this._mode);
            }
            cmd.addAll(this._debugOptions);
            cmd.addAll(this._jvmOptions);
            cmd.add(this._mainClass);
            cmd.addAll(this._args);
            return cmd.toArray(new String[cmd.size()]);
        }

        protected String[] getCommandInJNIFormatAsArray() {
            this.resolveAll();
            String jniMainClassName = this._mainClass;
            int iPos = 0;
            while ((iPos = jniMainClassName.indexOf(".")) >= 0) {
                jniMainClassName = jniMainClassName.substring(0, iPos) + "/" + jniMainClassName.substring(iPos + 1);
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.addAll(this._systemVariables);
            if (this._mode != null) {
                cmd.add(this._mode);
            }
            cmd.addAll(this._debugOptions);
            cmd.addAll(this._jvmOptions);
            cmd.add("-Djava.class.path=" + this._classpath);
            cmd.add(this._mainClass);
            cmd.addAll(this._args);
            return cmd.toArray(new String[cmd.size()]);
        }

        protected String[] getSystemVariablesAsArray() {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.addAll(this._systemVariables);
            return cmd.toArray(new String[cmd.size()]);
        }

        public String toString() {
            StringBuffer cmd = new StringBuffer();
            String[] ret = this.getCommandAsArray();
            for (int ii = 0; ii < ret.length; ++ii) {
                cmd.append(ret[ii]);
            }
            return cmd.toString();
        }

        public String toStringWithLines() {
            StringBuffer cmd = new StringBuffer();
            String[] ret = this.getCommandAsArray();
            for (int ii = 0; ii < ret.length; ++ii) {
                cmd.append("\n" + ret[ii]);
            }
            return cmd.toString();
        }

        void reorder() {
            this.reorderJVMOptions();
            this.reorderSystemProps();
        }

        private void reorderJVMOptions() {
            String opt = "-XX:+UnlockDiagnosticVMOptions";
            int index = this._jvmOptions.indexOf(opt);
            if (index > 0) {
                this._jvmOptions.remove(index);
                this._jvmOptions.add(0, opt);
            }
        }

        private void reorderSystemProps() {
            Collections.sort(this._systemVariables);
            String irp = "com.sun.aas.instanceRoot";
            for (int i = 0; i < this._systemVariables.size(); ++i) {
                String s = this._systemVariables.get(i);
                if (s == null || !s.startsWith("-Dcom.sun.aas.instanceRoot=")) continue;
                this._systemVariables.remove(i);
                this._systemVariables.add(0, s);
                break;
            }
        }
    }
}

