/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;

public class AttrInt
extends AttrType {
    public static final int IGNORE_LOW = Integer.MIN_VALUE;
    public static final int IGNORE_HIGH = 0x7FFFFFF6;
    int highRange = 0x7FFFFFF6;
    int lowRange = Integer.MIN_VALUE;

    public AttrInt(String name, String type, boolean optional) {
        super(name, type, optional);
    }

    public int getHighRange() {
        return this.highRange;
    }

    public int getLowRange() {
        return this.lowRange;
    }

    public void setHighRange(int high) {
        this.highRange = high;
    }

    public void setLowRange(int low) {
        this.lowRange = low;
    }

    public void validate(Object value, ValidationContext valCtx) {
        super.validate(value, valCtx);
        int tmp = 0;
        boolean success = true;
        if (value == null || value.equals("")) {
            return;
        }
        if (valCtx.isDELETE()) {
            return;
        }
        try {
            tmp = Integer.parseInt(value.toString());
        }
        catch (NumberFormatException n) {
            this.reportAttributeError(valCtx, "invalidInteger", "Attribute({0}={1}) : {2} Invalid integer", new Object[]{valCtx.attrName, value, value});
            success = false;
        }
        if (success) {
            String compValue;
            if (this.lowRange != Integer.MIN_VALUE && tmp < this.lowRange || this.highRange != 0x7FFFFFF6 && tmp > this.highRange) {
                if (this.lowRange == 0 && this.highRange == 0x7FFFFFF6) {
                    this.reportAttributeError(valCtx, "invalidIntegerNegative", "Attribute({0}={1}) : {2} Invalid Value, Cannot be a negative number", new Object[]{valCtx.attrName, String.valueOf(tmp), String.valueOf(tmp)});
                } else {
                    this.reportAttributeError(valCtx, "invalidIntegerRange", "Attribute({0}={1}) : {2} Invalid Value, Valid Range {3},{4}", new Object[]{valCtx.attrName, String.valueOf(tmp), String.valueOf(tmp), String.valueOf(this.lowRange), String.valueOf(this.highRange)});
                }
            }
            if ((compValue = this.getValueForAttribute((String)this.getRuleValue("le-than"), valCtx)) != null && !compValue.trim().equals("0") && this.compareIntWithStr(tmp, compValue) > 0) {
                this.reportAttributeError(valCtx, "not-le-than", "Value ({0}) should be less or equal than to value of attribute {1} ({2})", new Object[]{value, this.getRuleValue("le-than"), compValue});
            }
            if ((compValue = this.getValueForAttribute((String)this.getRuleValue("ge-than"), valCtx)) != null && !compValue.trim().equals("0") && this.compareIntWithStr(tmp, compValue) < 0) {
                this.reportAttributeError(valCtx, "not-ge-then", "Value ({0}) should be more or equal to value of attribute {1} ({2})", new Object[]{value, this.getRuleValue("ge-than"), compValue});
            }
            if ((compValue = this.getValueForAttribute((String)this.getRuleValue("gt-than"), valCtx)) != null && !compValue.trim().equals("0") && this.compareIntWithStr(tmp, compValue) <= 0) {
                this.reportAttributeError(valCtx, "not-gt-then", "Value ({0}) should be more then value of attribute {1} ({2})", new Object[]{value, this.getRuleValue("gt-than"), compValue});
            }
            if ((compValue = this.getValueForAttribute((String)this.getRuleValue("ls-than"), valCtx)) != null && !compValue.trim().equals("0") && this.compareIntWithStr(tmp, compValue) >= 0) {
                this.reportAttributeError(valCtx, "not-ls-then", "Value ({0}) should be less than value of attribute {1} ({2})", new Object[]{value, this.getRuleValue("ls-than"), compValue});
            }
        }
    }

    int compareIntWithStr(int iVal, String strVal) {
        return iVal - Integer.parseInt(strVal);
    }
}

