/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class Frame {
    private Map map = new TreeMap();
    private Frame parent;

    static Frame newFrame() {
        return new Frame(new Frame(){

            String lookup(String s) {
                return System.getProperty(s) != null ? System.getProperty(s) : "${" + s + "}";
            }

            public String toString() {
                return "[]";
            }
        });
    }

    static Frame newFrame(Frame f) {
        return new Frame(f);
    }

    String lookup(String s) {
        return this.map.get(s) != null ? (String)this.map.get(s) : this.parent.lookup(s);
    }

    Frame put(String key, String value) {
        this.map.put(key, value);
        return this;
    }

    Frame inheritFrom(Frame f) throws IllegalArgumentException {
        if (this.contains(this.getAncestors(), f) || this.contains(f.getAncestors(), this)) {
            throw new IllegalArgumentException("Inheriting from an ancestor is illegal - it causes loops!");
        }
        this.parent = f;
        return this;
    }

    private boolean contains(Set s, Frame f) {
        Iterator it = s.iterator();
        while (it.hasNext()) {
            if (it.next() != f) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            sb.append(e.getKey() + "->" + e.getValue());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" " + this.parent + "]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof Frame && this.equals((Frame)o);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    private boolean equals(Frame o) {
        return o != null && ((Object)this.map).equals(o.map) && (this.parent == null && o.parent == null || this.parent != null && this.parent.equals(o.parent));
    }

    private Frame() {
    }

    private Frame(Frame f) {
        this.parent = f;
    }

    private Set getAncestors() {
        if (this.parent == null) {
            return new HashSet();
        }
        Set ancestors = this.parent.getAncestors();
        ancestors.add(this);
        return ancestors;
    }
}

