/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldIIOPServiceMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IIOPListenerConfigFactory
extends ConfigFactory {
    private final OldIIOPServiceMBean mOldIIOPServiceMBean;
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("Port", "SecurityEnabled", "Enabled");
    public static final String ADDRESS_KEY = "Address";

    public IIOPListenerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        this.mOldIIOPServiceMBean = callbacks.getOldConfigProxies().getOldIIOPServiceMBean(this.getConfigName());
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    public ObjectName create(String name, String address, Map<String, String> optional) {
        String[] requiredParams = new String[]{ADDRESS_KEY, address};
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    @Override
    protected void removeByName(String name) {
        this.mOldIIOPServiceMBean.removeIiopListenerById(name);
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "id");
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.mOldIIOPServiceMBean.createIiopListener(translatedAttrs);
    }
}

