/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;

final class AuthRealmMBeanX {
    private final String mFile;

    public AuthRealmMBeanX(String file) {
        this.mFile = file;
    }

    private FileRealm getRealmKeyFile() throws MBeanConfigException {
        try {
            return new FileRealm(this.mFile);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    private static String[] toStringArray(Enumeration e) {
        ArrayList<String> list = new ArrayList<String>();
        while (e.hasMoreElements()) {
            list.add("" + e.nextElement());
        }
        return CollectionUtil.toStringArray(list);
    }

    public String[] getUserNames() throws MBeanConfigException {
        FileRealm realm = this.getRealmKeyFile();
        try {
            return AuthRealmMBeanX.toStringArray(realm.getUserNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getGroupNames() throws MBeanConfigException {
        FileRealm realm = this.getRealmKeyFile();
        try {
            return AuthRealmMBeanX.toStringArray(realm.getGroupNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getUserGroupNames(String userName) throws MBeanConfigException {
        if (userName == null) {
            throw new IllegalArgumentException("" + null);
        }
        FileRealm realm = this.getRealmKeyFile();
        try {
            return AuthRealmMBeanX.toStringArray(realm.getGroupNames(userName));
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
    }

    public void addUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.addUser(userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    public void removeUser(String userName) throws MBeanConfigException {
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.removeUser(userName);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
    }

    public void updateUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.updateUser(userName, userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    private void saveInstanceRealmKeyFile(FileRealm realm) throws MBeanConfigException {
        try {
            realm.writeKeyFile(this.mFile);
        }
        catch (IOException e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }
}

