/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.ReadWriteAttributeFilter;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.support.CoverageInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageInfoImpl
implements Serializable,
CoverageInfo {
    public static final long serialVersionUID = 11259375L;
    private final Set<String> mAttributesRead;
    private final Set<String> mAttributesWritten;
    private final Set<String> mOperationsInvoked;
    private final Map<String, Integer> mAttributeGetFailures;
    private final Map<String, Integer> mAttributeSetFailures;
    private final Map<String, Integer> mUnknownAttributes;
    private final Map<String, Integer> mUnknownOperations;
    private final Map<String, Integer> mInvocationFailures;
    private Set<String> mLegalReadableAttributes = null;
    private Set<String> mLegalWriteableAttributes = null;
    private Set<String> mLegalOperations = null;
    private MBeanInfo mMBeanInfo;
    private static final String[] EMPTY_SIG = new String[0];

    public CoverageInfoImpl(MBeanInfo mbeanInfo) {
        this.mMBeanInfo = mbeanInfo;
        this.setMBeanInfo(this.mMBeanInfo);
        this.mAttributesRead = new HashSet<String>();
        this.mAttributesWritten = new HashSet<String>();
        this.mOperationsInvoked = new HashSet<String>();
        this.mAttributeGetFailures = new HashMap<String, Integer>();
        this.mAttributeSetFailures = new HashMap<String, Integer>();
        this.mUnknownAttributes = new HashMap<String, Integer>();
        this.mUnknownOperations = new HashMap<String, Integer>();
        this.mInvocationFailures = new HashMap<String, Integer>();
    }

    @Override
    public void clear() {
        this.mAttributesRead.clear();
        this.mAttributesWritten.clear();
        this.mOperationsInvoked.clear();
        this.mAttributeGetFailures.clear();
        this.mAttributeSetFailures.clear();
        this.mUnknownAttributes.clear();
        this.mUnknownOperations.clear();
        this.mInvocationFailures.clear();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    @Override
    public void setMBeanInfo(MBeanInfo mbeanInfo) {
        this.mLegalOperations = new HashSet<String>();
        this.mLegalReadableAttributes = new HashSet<String>();
        this.mLegalWriteableAttributes = new HashSet<String>();
        if (mbeanInfo != null) {
            try {
                MBeanOperationInfo[] ops;
                for (MBeanOperationInfo opInfo : ops = mbeanInfo.getOperations()) {
                    String[] sig = JMXUtil.getSignature(opInfo.getSignature());
                    String fullName = this.getFullOperationName(opInfo.getName(), sig);
                    this.mLegalOperations.add(fullName);
                }
                this.mLegalOperations = Collections.unmodifiableSet(this.mLegalOperations);
                MBeanAttributeInfo[] allAttrInfos = this.getMBeanInfo().getAttributes();
                MBeanAttributeInfo[] readables = JMXUtil.filterAttributeInfos(allAttrInfos, ReadWriteAttributeFilter.READABLE_FILTER);
                MBeanAttributeInfo[] writeables = JMXUtil.filterAttributeInfos(allAttrInfos, ReadWriteAttributeFilter.WRITEABLE_FILTER);
                this.mLegalReadableAttributes = GSetUtil.newUnmodifiableStringSet(JMXUtil.getAttributeNames(readables));
                this.mLegalWriteableAttributes = GSetUtil.newUnmodifiableStringSet(JMXUtil.getAttributeNames(writeables));
            }
            catch (Exception e) {
                System.out.println(ExceptionUtil.toString(e));
                throw new RuntimeException(e);
            }
        }
    }

    private void mergeCounts(Map<String, Integer> src, Map<String, Integer> dest) {
        for (String key : src.keySet()) {
            Integer srcValue = src.get(key);
            Integer destValue = dest.get(key);
            int sum = srcValue + (destValue == null ? 0 : destValue);
            dest.put(key, sum);
        }
    }

    @Override
    public void merge(CoverageInfo info) {
        this.mAttributesRead.addAll(info.getAttributesRead());
        this.mAttributesWritten.addAll(info.getAttributesWritten());
        this.mOperationsInvoked.addAll(info.getOperationsInvoked());
        this.mergeCounts(info.getAttributeGetFailures(), this.mAttributeGetFailures);
        this.mergeCounts(info.getAttributeSetFailures(), this.mAttributeSetFailures);
        this.mergeCounts(info.getUnknownAttributes(), this.mUnknownAttributes);
        this.mergeCounts(info.getUnknownOperations(), this.mUnknownOperations);
        this.mergeCounts(info.getInvocationFailures(), this.mInvocationFailures);
    }

    @Override
    public Set<String> getAttributesRead() {
        return new HashSet<String>(this.mAttributesRead);
    }

    @Override
    public Set<String> getAttributesNotRead() {
        this.checkHaveMBeanInfo();
        HashSet<String> notRead = new HashSet<String>(this.mLegalReadableAttributes);
        notRead.removeAll(this.mAttributesRead);
        return notRead;
    }

    @Override
    public Set<String> getAttributesWritten() {
        return new HashSet<String>(this.mAttributesWritten);
    }

    @Override
    public Set<String> getAttributesNotWritten() {
        this.checkHaveMBeanInfo();
        HashSet<String> notWritten = new HashSet<String>(this.mLegalWriteableAttributes);
        notWritten.removeAll(this.mAttributesWritten);
        return notWritten;
    }

    @Override
    public Set<String> getOperationsInvoked() {
        return new HashSet<String>(this.mOperationsInvoked);
    }

    @Override
    public Set<String> getOperationsNotInvoked() {
        this.checkHaveMBeanInfo();
        HashSet<String> notInvoked = new HashSet<String>(this.mLegalOperations);
        notInvoked.removeAll(this.getOperationsInvoked());
        return notInvoked;
    }

    private void checkHaveMBeanInfo() {
        if (this.getMBeanInfo() == null) {
            throw new IllegalArgumentException("MBeanInfo must be set using setMBeanInfo() prior to call");
        }
    }

    @Override
    public Map<String, Integer> getAttributeGetFailures() {
        return new HashMap<String, Integer>(this.mAttributeGetFailures);
    }

    @Override
    public Map<String, Integer> getAttributeSetFailures() {
        return new HashMap<String, Integer>(this.mAttributeSetFailures);
    }

    @Override
    public Map<String, Integer> getUnknownAttributes() {
        return new HashMap<String, Integer>(this.mUnknownAttributes);
    }

    @Override
    public void ignoreUnknownAttribute(String name) {
        this.mUnknownAttributes.remove(name);
        this.mAttributeGetFailures.remove(name);
        this.mAttributeSetFailures.remove(name);
    }

    @Override
    public Map<String, Integer> getUnknownOperations() {
        return new HashMap<String, Integer>(this.mUnknownOperations);
    }

    @Override
    public Map<String, Integer> getInvocationFailures() {
        return new HashMap<String, Integer>(this.mInvocationFailures);
    }

    private void unknownAttribute(String name) {
        Integer count = this.mUnknownAttributes.get(name);
        count = count == null ? 1 : 1 + count;
        this.mUnknownAttributes.put(name, count);
    }

    @Override
    public void attributeWasRead(String name) {
        if (this.mLegalReadableAttributes.contains(name)) {
            this.mAttributesRead.add(name);
        } else {
            this.unknownAttribute(name);
        }
    }

    @Override
    public void attributesWereRead(String[] names) {
        for (String name : names) {
            this.attributeWasRead(name);
        }
    }

    @Override
    public void attributeSetFailure(String name) {
        Integer count = this.mAttributeSetFailures.get(name);
        count = count == null ? 1 : 1 + count;
        this.mAttributeSetFailures.put(name, count);
    }

    @Override
    public void attributeGetFailure(String name) {
        Integer count = this.mAttributeGetFailures.get(name);
        count = count == null ? 1 : 1 + count;
        this.mAttributeGetFailures.put(name, count);
    }

    @Override
    public void attributeWasWritten(String name) {
        if (this.mLegalWriteableAttributes.contains(name)) {
            this.mAttributesWritten.add(name);
        } else {
            this.unknownAttribute(name);
        }
    }

    private String getFullOperationName(String name, String[] sig) {
        String sigString = StringUtil.toString(",", sig == null ? EMPTY_SIG : sig);
        String s = name + "(" + sigString + ")";
        return s;
    }

    private void sdebug(Object o) {
        System.out.println("" + o);
    }

    @Override
    public void operationWasInvoked(String name, String[] sig) {
        String fullName = this.getFullOperationName(name, sig);
        if (this.mLegalOperations.contains(fullName)) {
            this.mOperationsInvoked.add(fullName);
        } else {
            this.unknownOperation(fullName, sig);
            assert (!this.mOperationsInvoked.contains(fullName));
        }
    }

    private void unknownOperation(String name, String[] sig) {
        String fullName = this.getFullOperationName(name, sig);
        Integer count = this.mUnknownOperations.get(fullName);
        count = count == null ? 1 : 1 + count;
        this.mUnknownOperations.put(fullName, count);
    }

    @Override
    public void markAsInvoked(String fullName) {
        if (!fullName.endsWith(")") || fullName.indexOf("(") < 0) {
            throw new IllegalArgumentException(fullName);
        }
        this.mOperationsInvoked.add(fullName);
    }

    @Override
    public void operationFailed(String name, String[] sig) {
        String fullName = this.getFullOperationName(name, sig);
        if (!this.getOperations().contains(fullName)) {
            throw new IllegalArgumentException(fullName);
        }
        Integer count = this.mInvocationFailures.get(name);
        count = count == null ? 1 : 1 + count;
        this.mInvocationFailures.put(fullName, count);
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(Collection c) {
        return CollectionUtil.toString(c);
    }

    private String toString(Collection c, String sep) {
        return CollectionUtil.toString(c, sep);
    }

    public int getNumReadableAttributes() {
        this.checkHaveMBeanInfo();
        return this.mLegalReadableAttributes.size();
    }

    @Override
    public Set<String> getReadableAttributes() {
        return this.mLegalReadableAttributes;
    }

    @Override
    public Set<String> getWriteableAttributes() {
        return this.mLegalWriteableAttributes;
    }

    @Override
    public Set<String> getOperations() {
        return this.mLegalOperations;
    }

    public int getNumWriteableAttributes() {
        this.checkHaveMBeanInfo();
        return this.mLegalWriteableAttributes.size();
    }

    public int getNumOperations() {
        return this.mLegalOperations.size();
    }

    @Override
    public int getAttributeReadCoverage() {
        return this.percent(this.mAttributesRead.size(), this.mLegalReadableAttributes.size());
    }

    @Override
    public int getAttributeWriteCoverage() {
        return this.percent(this.mAttributesWritten.size(), this.getNumWriteableAttributes());
    }

    @Override
    public int getOperationCoverage() {
        this.checkHaveMBeanInfo();
        int numOperations = this.mLegalOperations.size();
        HashSet<String> remaining = new HashSet<String>(this.mLegalOperations);
        for (String invoked : this.mOperationsInvoked) {
            remaining.remove(invoked);
        }
        int numInvoked = numOperations - remaining.size();
        return this.percent(numInvoked, numOperations);
    }

    @Override
    public boolean getFullCoverage() {
        return this.getAttributeReadCoverage() == 100 && this.getAttributeWriteCoverage() == 100 && this.getOperationCoverage() == 100;
    }

    private int percent(int numerator, int denominator) {
        return (int)((double)((float)numerator / (float)denominator) * 100.0);
    }

    @Override
    public String toString(boolean verbose) {
        String NEWLINE = System.getProperty("line.separator");
        String INDENT = "  ";
        String ITEM_SEP = NEWLINE + "  ";
        StringBuilder b = new StringBuilder();
        b.append("Attribute read coverage " + this.getAttributesRead().size() + "/" + this.getNumReadableAttributes() + " = " + this.getAttributeReadCoverage() + "%" + NEWLINE);
        b.append("Attribute write coverage " + this.getAttributesWritten().size() + "/" + this.getNumWriteableAttributes() + " = " + this.getAttributeWriteCoverage() + "%" + NEWLINE);
        b.append("Operation invocation coverage " + this.getOperationsInvoked().size() + "/" + this.getNumOperations() + " = " + this.getOperationCoverage() + "%" + NEWLINE);
        if (verbose) {
            b.append(this.mAttributesRead.size() + " Attributes read: " + ITEM_SEP + this.toString(this.getAttributesRead(), ITEM_SEP) + NEWLINE);
            b.append(this.mAttributesWritten.size() + " Attributes written: " + ITEM_SEP + this.toString(this.getAttributesWritten(), ITEM_SEP) + NEWLINE);
            b.append(this.mOperationsInvoked.size() + " operations invoked: " + ITEM_SEP + this.toString(this.getOperationsInvoked(), ITEM_SEP) + NEWLINE);
        }
        if (this.getMBeanInfo() != null) {
            Set<String> not = null;
            not = this.getAttributesNotRead();
            if (not.size() != 0 || verbose) {
                b.append(not.size() + " Attributes NOT read:" + ITEM_SEP + this.toString(not, ITEM_SEP) + NEWLINE);
            }
            if ((not = this.getAttributesNotWritten()).size() != 0 || verbose) {
                b.append(not.size() + " Attributes NOT written:" + ITEM_SEP + this.toString(not, ITEM_SEP) + NEWLINE);
            }
            if ((not = this.getOperationsNotInvoked()).size() != 0 || verbose) {
                b.append(not.size() + " operations NOT invoked:" + ITEM_SEP + CollectionUtil.toString(not, ITEM_SEP) + NEWLINE);
            }
        } else {
            b.append("WARNING: MBeanInfo not supplied, can't emit Attributes/operations not read/written/invoked" + NEWLINE);
        }
        Map<String, Integer> failures = null;
        failures = this.getAttributeGetFailures();
        if (failures.size() != 0 || verbose) {
            b.append(failures.keySet().size() + " getAttribute failures: " + ITEM_SEP + this.toString(failures.keySet(), ITEM_SEP) + NEWLINE);
        }
        if ((failures = this.getAttributeSetFailures()).size() != 0 || verbose) {
            b.append(failures.keySet().size() + " setAttribute failures: " + ITEM_SEP + this.toString(failures.keySet(), ITEM_SEP) + NEWLINE);
        }
        if ((failures = this.getUnknownAttributes()).size() != 0 || verbose) {
            b.append(failures.keySet().size() + " unknown Attributes: " + ITEM_SEP + this.toString(failures.keySet(), ITEM_SEP) + NEWLINE);
        }
        if ((failures = this.getUnknownOperations()).size() != 0 || verbose) {
            b.append(failures.keySet().size() + " unknown operations: " + ITEM_SEP + this.toString(failures.keySet(), ITEM_SEP) + NEWLINE);
        }
        if ((failures = this.getInvocationFailures()).size() != 0 || verbose) {
            b.append(failures.keySet().size() + " invoke() failures: " + ITEM_SEP + CollectionUtil.toString(failures.keySet(), ITEM_SEP) + NEWLINE);
        }
        return b.toString();
    }
}

