/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.alert;

import com.sun.appserv.management.alert.LogDomains;
import com.sun.appserv.management.alert.MailAlert;
import com.sun.appserv.management.alert.MailFilter;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class UnitTest
extends Thread {
    static final int UNIT_TEST_MAIL_ALERT = 1;
    static final int UNIT_TEST_MAIL_FILTER = 2;
    private final int unitTestMode;
    private final String unitTestData;
    private final Object mailAlertOrFilter;

    UnitTest(int unitTestMode, String unitTestData, Object mailAlertOrFilter) {
        this.unitTestMode = unitTestMode;
        this.unitTestData = unitTestData;
        this.mailAlertOrFilter = mailAlertOrFilter;
    }

    public void run() {
        try {
            UnitTest.sleep(1000L);
        }
        catch (Exception e) {
            e.hashCode();
        }
        StringTokenizer tokenizer = new StringTokenizer(this.unitTestData, ";");
        switch (this.unitTestMode) {
            case 1: {
                this.unitTestMailAlert(tokenizer);
                break;
            }
            case 2: {
                this.unitTestMailFilter(tokenizer);
                break;
            }
            default: {
                System.out.println("INVALID OPTION FOR UNIT TEST OF ALERTS");
            }
        }
    }

    private void unitTestMailAlert(StringTokenizer tokenizer) {
        boolean testStatus = true;
        MailAlert mailAlert = (MailAlert)this.mailAlertOrFilter;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            StringTokenizer nameAndValue = new StringTokenizer(token, "=");
            String name = nameAndValue.nextToken();
            String value = nameAndValue.nextToken();
            try {
                if (name.equals("subject")) {
                    if (value.equals(mailAlert.getSubject())) continue;
                    this.unitTestFailed(name, value, mailAlert.getSubject());
                    testStatus = false;
                    continue;
                }
                if (name.equals("recipients")) {
                    if (value.equals(mailAlert.getRecipients())) continue;
                    this.unitTestFailed(name, value, mailAlert.getRecipients());
                    testStatus = false;
                    continue;
                }
                if (name.equals("mailSMTPHost")) {
                    if (value.equals(mailAlert.getMailSMTPHost())) continue;
                    this.unitTestFailed(name, value, mailAlert.getMailSMTPHost());
                    testStatus = false;
                    continue;
                }
                if (name.equals("fromAddress")) {
                    if (value.equals(mailAlert.getFromAddress())) continue;
                    this.unitTestFailed(name, value, mailAlert.getFromAddress());
                    testStatus = false;
                    continue;
                }
                if (!name.equals("includeDiagnostics") || value.equals(new Boolean(mailAlert.getIncludeDiagnostics()).toString())) continue;
                this.unitTestFailed(name, value, new Boolean(mailAlert.getIncludeDiagnostics()).toString());
                testStatus = false;
            }
            catch (Exception e) {
                System.out.println("EXCEPTION IN UNIT TEST FOR MAIL ALERT " + e);
                testStatus = false;
            }
        }
        if (testStatus) {
            LogDomains.getAlertLogger().log(Level.SEVERE, "Testing SEVERE alert..");
            System.out.println("UNIT TEST FOR MAIL ALERT PASSED...");
        }
    }

    private void unitTestMailFilter(StringTokenizer tokenizer) {
        boolean testStatus = true;
        MailFilter mailFilter = (MailFilter)this.mailAlertOrFilter;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            StringTokenizer nameAndValue = new StringTokenizer(token, "=");
            String name = nameAndValue.nextToken();
            String value = nameAndValue.nextToken();
            try {
                if (!name.equals("filterWarningMessages") || value.equals(new Boolean(mailFilter.getFilterWarningMessages()).toString())) continue;
                this.unitTestFailed(name, value, new Boolean(mailFilter.getFilterWarningMessages()).toString());
                testStatus = false;
            }
            catch (Exception e) {
                System.out.println("EXCEPTION IN UNIT TEST FOR MAIL FILTER " + e);
                testStatus = false;
            }
        }
        if (testStatus) {
            System.out.println("UNIT TEST FOR MAIL FILTER PASSED...");
        }
    }

    private void unitTestFailed(String propertyName, String expectedValue, String realValue) {
        String msg = "UNIT TEST FAILED FOR ALERTS : \nPropertyName -> " + propertyName + "\nexpectedValue -> " + expectedValue + "\nrealValue -> " + realValue;
        System.out.println(msg);
        throw new RuntimeException(msg);
    }
}

