/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.security;

import com.sun.appserv.security.ProgrammaticLoginPermission;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import com.sun.web.security.WebProgrammaticLogin;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProgrammaticLogin {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static ProgrammaticLoginPermission plLogin = new ProgrammaticLoginPermission("login");
    private static ProgrammaticLoginPermission plLogout = new ProgrammaticLoginPermission("logout");
    private static boolean isServer = ApplicationServer.getServerContext() != null;
    private static CallbackHandler handler = new LoginCallbackHandler(false);

    public Boolean login(final String user, final String password, final String realm, boolean errors) throws Exception {
        Boolean authenticated = null;
        try {
            this.checkLoginPermission(user);
            authenticated = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    if (isServer) {
                        LoginContextDriver.login(user, password, realm);
                    } else {
                        int type = 1;
                        UsernamePasswordStore.set(user, password);
                        try {
                            LoginContextDriver.doClientLogin(type, handler);
                        }
                        finally {
                            UsernamePasswordStore.resetThreadLocalOnly();
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            logger.severe("Programmatic login failed: " + e.toString());
            if (errors) {
                throw e;
            }
            authenticated = false;
        }
        return authenticated;
    }

    public Boolean login(String user, String password) {
        Boolean authenticated = null;
        try {
            authenticated = this.login(user, password, null, false);
        }
        catch (Exception e) {
            authenticated = false;
        }
        return authenticated;
    }

    public Boolean login(final String user, final String password, final String realm, final HttpServletRequest request, final HttpServletResponse response, boolean errors) throws Exception {
        Boolean authenticated = null;
        try {
            this.checkLoginPermission(user);
            authenticated = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return WebProgrammaticLogin.login(user, password, realm, request, response);
                }
            });
        }
        catch (Exception e) {
            if (!errors) {
                authenticated = false;
            }
            throw e;
        }
        return authenticated;
    }

    public Boolean login(String user, String password, HttpServletRequest request, HttpServletResponse response) {
        Boolean authenticated = null;
        try {
            authenticated = this.login(user, password, null, request, response, false);
        }
        catch (Exception e) {
            authenticated = false;
        }
        return authenticated;
    }

    public Boolean logout() {
        Boolean loggedout = null;
        try {
            loggedout = this.logout(false);
        }
        catch (Exception e) {
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(boolean errors) throws Exception {
        Boolean loggedout = null;
        try {
            this.checkLogoutPermission();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (isServer) {
                        LoginContextDriver.logout();
                    } else {
                        UsernamePasswordStore.reset();
                        LoginContextDriver.doClientLogout();
                    }
                    return null;
                }
            });
            loggedout = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Programmatic logout failed: " + e.toString());
            if (errors) {
                throw e;
            }
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(HttpServletRequest request, HttpServletResponse response) {
        Boolean loggedout = null;
        try {
            loggedout = this.logout(request, response, false);
        }
        catch (Exception e) {
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(final HttpServletRequest request, final HttpServletResponse response, boolean errors) throws Exception {
        Boolean loggedout = null;
        try {
            this.checkLogoutPermission();
            loggedout = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WebProgrammaticLogin.logout(request, response);
                }
            });
        }
        catch (Exception e) {
            if (errors) {
                throw e;
            }
            loggedout = false;
        }
        return loggedout;
    }

    private void checkLoginPermission(String user) throws Exception {
        try {
            SecurityManager sm;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ProgrammaticLogin.login() called for user: " + user);
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(plLogin);
            }
        }
        catch (Exception e) {
            logger.warning("proglogin.noperm");
            throw e;
        }
    }

    private void checkLogoutPermission() throws Exception {
        try {
            SecurityManager sm;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ProgrammaticLogin.logout() called.");
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(plLogout);
            }
        }
        catch (Exception e) {
            logger.warning("prologout.noperm");
            throw e;
        }
    }
}

