/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;

public class CacheTable {
    private boolean noReverseMap;
    private static final int INITIAL_SIZE = 16;
    private static final int MAX_SIZE = 0x40000000;
    private int size;
    private int entryCount;
    private Entry[] map;
    private Entry[] rmap;
    private ORB orb;
    private ORBUtilSystemException wrapper;

    private CacheTable() {
    }

    public CacheTable(ORB orb, boolean u) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        this.noReverseMap = u;
        this.size = 16;
        this.entryCount = 0;
        this.initTables();
    }

    private void initTables() {
        this.map = new Entry[this.size];
        this.rmap = this.noReverseMap ? null : new Entry[this.size];
    }

    private void grow() {
        if (this.size == 0x40000000) {
            return;
        }
        Entry[] oldMap = this.map;
        int oldSize = this.size;
        this.size <<= 1;
        this.initTables();
        for (int i = 0; i < oldSize; ++i) {
            Entry e = oldMap[i];
            while (e != null) {
                this.put_table(e.key, e.val);
                e = e.next;
            }
        }
    }

    private int hashModTableSize(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h & this.size - 1;
    }

    private int hash(Object key) {
        return this.hashModTableSize(System.identityHashCode(key));
    }

    private int hash(int val) {
        return this.hashModTableSize(val);
    }

    public final void put(Object key, int val) {
        if (this.put_table(key, val)) {
            ++this.entryCount;
            if (this.entryCount > this.size * 3 / 4) {
                this.grow();
            }
        }
    }

    private boolean put_table(Object key, int val) {
        int index = this.hash(key);
        Entry e = this.map[index];
        while (e != null) {
            if (e.key == key) {
                if (e.val != val) {
                    this.wrapper.duplicateIndirectionOffset();
                } else {
                    return false;
                }
            }
            e = e.next;
        }
        Entry newEntry = new Entry(key, val);
        newEntry.next = this.map[index];
        this.map[index] = newEntry;
        if (!this.noReverseMap) {
            int rindex = this.hash(val);
            newEntry.rnext = this.rmap[rindex];
            this.rmap[rindex] = newEntry;
        }
        return true;
    }

    public final boolean containsKey(Object key) {
        return this.getVal(key) != -1;
    }

    public final int getVal(Object key) {
        int index = this.hash(key);
        Entry e = this.map[index];
        while (e != null) {
            if (e.key == key) {
                return e.val;
            }
            e = e.next;
        }
        return -1;
    }

    public final boolean containsVal(int val) {
        return this.getKey(val) != null;
    }

    public final Object getKey(int val) {
        if (this.noReverseMap) {
            throw this.wrapper.getKeyInvalidInCacheTable();
        }
        int index = this.hash(val);
        Entry e = this.rmap[index];
        while (e != null) {
            if (e.val == val) {
                return e.key;
            }
            e = e.rnext;
        }
        return null;
    }

    public void done() {
        this.map = null;
        this.rmap = null;
    }

    private class Entry {
        Object key;
        int val;
        Entry next;
        Entry rnext;

        public Entry(Object k, int v) {
            this.key = k;
            this.val = v;
            this.next = null;
            this.rnext = null;
        }
    }
}

