/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi.bcel;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.presentation.rmi.StubFactoryDynamicBase;
import com.sun.corba.ee.impl.presentation.rmi.StubInvocationHandlerImpl;
import com.sun.corba.ee.impl.presentation.rmi.bcel.BCELStubBase;
import com.sun.corba.ee.impl.presentation.rmi.bcel.CodegenProxyCreator;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.IDLNameTranslator;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Map;
import org.omg.CORBA.Object;

public class StubFactoryBCELImpl
extends StubFactoryDynamicBase {
    private static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_PRESENTATION_ORBUtil();
    private static final boolean USE_BCEL = false;
    private static final String BCEL_KEY = "BCELStubClass";
    private final PresentationManager pm;

    public StubFactoryBCELImpl(PresentationManager pm, PresentationManager.ClassData classData, ClassLoader loader) {
        super(classData, loader);
        this.pm = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getStubClass() {
        Class<java.lang.Object> stubClass = null;
        PresentationManager.ClassData classData = this.classData;
        synchronized (classData) {
            Map dictionary = this.classData.getDictionary();
            stubClass = (Class<?>)dictionary.get(BCEL_KEY);
            if (stubClass == null) {
                IDLNameTranslator nt = this.classData.getIDLNameTranslator();
                final Class theClass = this.classData.getMyClass();
                String stubClassName = Utility.dynamicStubName(theClass.getName());
                String baseClassName = BCELStubBase.class.getName();
                Class[] interfaces = nt.getInterfaces();
                Method[] methods = nt.getMethods();
                final ProtectionDomain pd = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

                    @Override
                    public ProtectionDomain run() {
                        return theClass.getProtectionDomain();
                    }
                });
                final CodegenProxyCreator creator = new CodegenProxyCreator(stubClassName, baseClassName, interfaces, methods);
                stubClass = System.getSecurityManager() == null ? creator.create(pd, this.loader, this.pm.getDebug(), this.pm.getPrintStream()) : AccessController.doPrivileged(new PrivilegedAction<Class>(){

                    @Override
                    public Class run() {
                        return creator.create(pd, StubFactoryBCELImpl.this.loader, StubFactoryBCELImpl.this.pm.getDebug(), StubFactoryBCELImpl.this.pm.getPrintStream());
                    }
                });
                dictionary.put(BCEL_KEY, stubClass);
            }
        }
        return stubClass;
    }

    public Object makeStub() {
        final Class stubClass = this.getStubClass();
        BCELStubBase stub = null;
        try {
            stub = AccessController.doPrivileged(new PrivilegedExceptionAction<BCELStubBase>(){

                @Override
                public BCELStubBase run() throws Exception {
                    return (BCELStubBase)BCELStubBase.class.cast(stubClass.newInstance());
                }
            });
        }
        catch (Exception exc) {
            wrapper.couldNotInstantiateStubClass(exc, (java.lang.Object)stubClass.getName());
        }
        StubInvocationHandlerImpl handler = new StubInvocationHandlerImpl(this.pm, this.classData, (Object)stub);
        stub.initialize(this.classData, handler);
        return stub;
    }
}

