/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.corba.ee.impl.codegen.ClassGenerator;
import com.sun.corba.ee.spi.codegen.Expression;
import com.sun.corba.ee.spi.codegen.Type;
import com.sun.corba.ee.spi.codegen.Wrapper;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.logging.Logger;
import sun.rmi.rmic.IndentingWriter;

public class SerializableBeanGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SerializableBeanGenerator.class);
    private static Logger _logger = null;
    private Class beanClass;
    private String generatedSerializableClassName;
    private ClassLoader loader;

    public String getGeneratedClass() {
        return this.generatedSerializableClassName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    public SerializableBeanGenerator(ClassLoader cl, String beanClassName) throws GeneratorException {
        this.loader = cl;
        try {
            this.beanClass = cl.loadClass(beanClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.remote_interface_not_found", "Remote interface not found "));
        }
        this.generatedSerializableClassName = EJBUtils.getGeneratedSerializableClassName(beanClassName);
    }

    public ClassGenerator evaluate() {
        Wrapper._clear();
        String packageName = this.getPackageName(this.generatedSerializableClassName);
        String simpleName = this.getBaseName(this.generatedSerializableClassName);
        if (packageName != null) {
            Wrapper._package(packageName);
        } else {
            Wrapper._package();
        }
        LinkedList<Type> toImplement = new LinkedList<Type>();
        toImplement.add(Wrapper._t("java.io.Serializable"));
        Wrapper._class(1, simpleName, Wrapper._t(this.beanClass.getName()), toImplement);
        Wrapper._constructor(1, new Type[0]);
        Wrapper._body();
        Wrapper._expr(Wrapper._super(Wrapper._s(Wrapper._void(), new Type[0]), new Expression[0]));
        Wrapper._end();
        Wrapper._method(2, Wrapper._void(), "writeObject", Wrapper._t("java.io.IOException"));
        Wrapper._arg(Wrapper._t("java.io.ObjectOutputStream"), "oos");
        Wrapper._body();
        Wrapper._expr(Wrapper._call(Wrapper._t("com.sun.ejb.EJBUtils"), "serializeObjectFields", Wrapper._s(Wrapper._void(), Wrapper._Class(), Wrapper._Object(), Wrapper._t("java.io.ObjectOutputStream")), Wrapper._const(Wrapper._t(this.beanClass.getName())), Wrapper._this(), Wrapper._v("oos")));
        Wrapper._end();
        Wrapper._method(2, Wrapper._void(), "readObject", Wrapper._t("java.io.IOException"), Wrapper._t("java.lang.ClassNotFoundException"));
        Wrapper._arg(Wrapper._t("java.io.ObjectInputStream"), "ois");
        Wrapper._body();
        Wrapper._expr(Wrapper._call(Wrapper._t("com.sun.ejb.EJBUtils"), "deserializeObjectFields", Wrapper._s(Wrapper._void(), Wrapper._Class(), Wrapper._Object(), Wrapper._t("java.io.ObjectInputStream")), Wrapper._const(Wrapper._t(this.beanClass.getName())), Wrapper._this(), Wrapper._v("ois")));
        Wrapper._end();
        Wrapper._end();
        return Wrapper._classGenerator();
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        String packageName = this.getPackageName(this.generatedSerializableClassName);
        String simpleName = this.getBaseName(this.generatedSerializableClassName);
        p.pln("");
        if (packageName != null) {
            p.pln("package " + packageName + ";");
        }
        p.pln("");
        p.plnI("public class " + simpleName + " extends " + this.beanClass.getName() + " implements java.io.Serializable { ");
        p.pln("");
        p.plnI("private void writeObject(java.io.ObjectOutputStream oos) throws java.io.IOException {");
        p.pln("    com.sun.ejb.EJBUtils.serializeObjectFields(" + this.beanClass.getName() + ".class, this, oos);");
        p.pln("}");
        p.plnI("private void readObject(java.io.ObjectInputStream ois) throws java.io.IOException, java.lang.ClassNotFoundException {");
        p.pln("    com.sun.ejb.EJBUtils.deserializeObjectFields(" + this.beanClass.getName() + ".class, this, ois);");
        p.pln("}");
        p.pOln("}");
        p.close();
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    }
}

