/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.common.ByteChunk;
import com.sun.enterprise.admin.common.DownloadRequestInfo;
import com.sun.enterprise.admin.common.FileTransfer;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.ParamInfo;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.StringValidator;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Random;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXFileTransfer
implements FileTransfer {
    public static final String S1ASHTTP_PROVIDER_PACKAGES = "com.sun.enterprise.admin.jmx.remote.protocol";
    private static final String UPLOAD_OPERATION = "uploadToServer";
    private static final String GET_STUB_FILE_LOCATION = "getClientStubJarLocation";
    private static final String GET_WSDL_FILE_LOCATION = "getWsdlFileLocation";
    private static final String PREPARE_DOWNLOAD = "prepareDownload";
    private static final String MCPREPARE_DOWNLOAD = "mcPrepareDownload";
    private static final String DOWNLOAD_FILE = "downloadFile";
    private static final String MCDOWNLOAD_FILE = "mcDownloadFile";
    private JMXServiceURL url;
    private String user;
    private String password;
    private MBeanServerConnection mbsc;
    private String targetServer = "server";
    private static final StringManager _localStrMgr = StringManager.getManager(JMXFileTransfer.class);

    public JMXFileTransfer(JMXServiceURL url, String user, String password) throws IOException {
        this.url = url;
        this.user = user;
        this.password = password;
        this.setConnection();
    }

    public JMXFileTransfer(JMXServiceURL url, String user, String password, boolean doConnect) throws IOException {
        this.url = url;
        this.user = user;
        this.password = password;
        if (doConnect) {
            this.setConnection();
        }
    }

    public JMXFileTransfer(MBeanServerConnection mbsc) throws IOException {
        this.mbsc = mbsc;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public void setMBeanServerConnection(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public void setConnection() throws IOException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.protocol.provider.pkgs", S1ASHTTP_PROVIDER_PACKAGES);
        env.put("USER", this.user);
        env.put("PASSWORD", this.password);
        env.put("com.sun.enterprise.as.http.auth", "BASIC");
        env.put("jmx.remote.credentials", new String[]{this.user, this.password});
        JMXConnector conn = JMXConnectorFactory.connect(this.url, env);
        this.mbsc = conn.getMBeanServerConnection();
    }

    public void setTargetServer(String s) {
        this.targetServer = s;
    }

    public String uploadFile(String filePath) throws IOException {
        return this.uploadFile(filePath, null);
    }

    public String uploadFile(String filePath, String targetDir) throws IOException {
        File f = new File(filePath);
        if (!f.exists() || !f.canRead()) {
            throw new FileNotFoundException(filePath);
        }
        return this.uploadFile(f, targetDir);
    }

    public String uploadFile(File f, String targetDir) throws IOException {
        if (!f.isFile() || this.mbsc == null) {
            throw new IllegalArgumentException();
        }
        String remoteLocation = null;
        ObjectName mbeanName = ObjectNames.getPerInstanceSystemServicesObjectName(this.targetServer);
        String operationName = UPLOAD_OPERATION;
        RandomAccessFile file = new RandomAccessFile(f, "r");
        byte[] bytes = new byte[0xA00000];
        int bytesRead = 0;
        long totalBytesRead = 0L;
        boolean isFirstChunk = true;
        boolean isLastChunk = false;
        long fileSize = file.length();
        Random random = new Random();
        String id = String.valueOf(random.nextInt(9999999));
        try {
            int index = 0;
            while ((bytesRead = file.read(bytes)) != -1) {
                totalBytesRead += (long)bytesRead;
                if (bytesRead < bytes.length) {
                    byte[] realBytes = new byte[bytesRead];
                    for (int i = 0; i < bytesRead; ++i) {
                        realBytes[i] = bytes[i];
                    }
                    bytes = realBytes;
                }
                if (totalBytesRead == fileSize) {
                    isLastChunk = true;
                }
                ByteChunk aChunk = new ByteChunk(bytes, f.getName(), isFirstChunk, isLastChunk, id, fileSize);
                aChunk.setTargetDir(targetDir);
                ParamInfo paramInfo = new ParamInfo(operationName, aChunk);
                try {
                    remoteLocation = (String)this.mbsc.invoke(mbeanName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
                }
                ++index;
                isFirstChunk = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getClass().getName() + ":" + e.getMessage());
        }
        finally {
            try {
                file.close();
            }
            catch (Exception e) {}
        }
        return remoteLocation;
    }

    public String downloadClientStubs(String appName, String destDir) throws IOException {
        if (this.mbsc == null) {
            throw new IllegalArgumentException("MBean Server connection not set");
        }
        ArgChecker.checkValid(appName, "appName", StringValidator.getInstance());
        String msg = "";
        File f = new File(destDir);
        if (!f.exists()) {
            throw new FileNotFoundException(msg);
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(msg);
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException(msg);
        }
        Object[] params = new Object[]{appName};
        String[] signature = new String[]{"java.lang.String"};
        ObjectName mbeanName = ObjectNames.getPerInstanceSystemServicesObjectName(this.targetServer);
        try {
            String filePath = (String)this.mbsc.invoke(mbeanName, GET_STUB_FILE_LOCATION, params, signature);
            this.downloadFile(filePath, destDir);
            String exportedFileLocation = new File(destDir, new File(filePath).getName()).getAbsolutePath();
            return exportedFileLocation;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
    }

    public String exportWsdlFile(String appName, String moduleName, String wsdlFileUri, String destDir) throws IOException {
        String exportedFileLocation;
        if (this.mbsc == null) {
            throw new IllegalArgumentException("MBean Server connection not set");
        }
        ArgChecker.checkValid(appName, "appName", StringValidator.getInstance());
        File f = new File(destDir);
        String msg = "";
        f.mkdirs();
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(f.toString());
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException(f.toString());
        }
        String filePath = null;
        Object[] params = new Object[]{appName, moduleName, wsdlFileUri};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        ObjectName mbeanName = ObjectNames.getPerInstanceSystemServicesObjectName(this.targetServer);
        try {
            filePath = (String)this.mbsc.invoke(mbeanName, GET_WSDL_FILE_LOCATION, params, signature);
            if (wsdlFileUri.lastIndexOf(47) != -1) {
                File absolutePath;
                String wsdlDir = wsdlFileUri.startsWith("META-INF/wsdl") ? "META-INF/wsdl/" : "WEB-INF/wsdl/";
                if (wsdlDir.length() < wsdlFileUri.lastIndexOf(47)) {
                    String intermediateDirs = wsdlFileUri.substring(wsdlDir.length(), wsdlFileUri.lastIndexOf(47));
                    absolutePath = new File(destDir, intermediateDirs);
                } else {
                    absolutePath = new File(destDir);
                }
                absolutePath.mkdirs();
                destDir = absolutePath.getAbsolutePath();
                wsdlFileUri = wsdlFileUri.substring(wsdlFileUri.lastIndexOf(47) + 1);
            }
            this.downloadFile(filePath, destDir, wsdlFileUri);
            exportedFileLocation = new File(destDir, wsdlFileUri).getAbsolutePath();
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
        return exportedFileLocation;
    }

    public String downloadFile(String filePath, String destinationDirPath) throws IOException {
        return this.downloadFile(filePath, destinationDirPath, null);
    }

    public String downloadFile(String filePath, String destinationDirPath, String appName) throws IOException {
        File destPath = null;
        destPath = appName == null ? new File(destinationDirPath, new File(filePath).getName()) : new File(destinationDirPath, appName);
        return this.downloadFile(filePath, destPath);
    }

    public String downloadFile(String filePath, File destPath) throws IOException {
        if (this.mbsc == null) {
            throw new IllegalArgumentException("MBean Server connection not set");
        }
        String msg = "";
        File destDir = destPath.getParentFile();
        if (!destDir.exists()) {
            throw new FileNotFoundException(destDir.getName());
        }
        FileOutputStream fos = null;
        try {
            ObjectName mbeanName = ObjectNames.getPerInstanceSystemServicesObjectName(this.targetServer);
            this.mbsc.invoke(mbeanName, PREPARE_DOWNLOAD, new Object[]{filePath}, new String[]{"java.lang.String"});
            fos = new FileOutputStream(destPath);
            boolean lastChunk = false;
            int chunkIndex = 0;
            int curSize = 0;
            long totalFileSize = 0L;
            while (!lastChunk) {
                Object[] params = new Object[]{new Integer(chunkIndex)};
                String[] signature = new String[]{"java.lang.Integer"};
                ByteChunk chunk = (ByteChunk)this.mbsc.invoke(mbeanName, DOWNLOAD_FILE, params, signature);
                ++chunkIndex;
                lastChunk = chunk.isLast();
                byte[] bytes = chunk.getBytes();
                fos.write(bytes, 0, bytes.length);
                curSize = bytes.length;
                totalFileSize = chunk.getTotalFileSize();
            }
            if ((long)curSize < totalFileSize) {
                throw new IOException("Checksum error, download incomplete, total file size is " + totalFileSize + " only gotton " + curSize + " bytes.");
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
        return destPath.getPath();
    }

    public synchronized String mcDownloadFile(String filePath, File destPath) throws IOException {
        if (this.mbsc == null) {
            String msg = _localStrMgr.getString("admin.common.nombsc");
            throw new IllegalArgumentException(msg);
        }
        File destDir = destPath.getParentFile();
        if (!destDir.exists()) {
            throw new FileNotFoundException(destDir.getName());
        }
        FileOutputStream fos = null;
        try {
            ObjectName mbeanName = ObjectNames.getPerInstanceSystemServicesObjectName(this.targetServer);
            DownloadRequestInfo info = (DownloadRequestInfo)this.mbsc.invoke(mbeanName, MCPREPARE_DOWNLOAD, new Object[]{filePath}, new String[]{"java.lang.String"});
            fos = new FileOutputStream(destPath);
            boolean lastChunk = false;
            int chunkIndex = 0;
            long curSize = 0L;
            long totalFileSize = info.getTotalFileSize();
            while (!lastChunk) {
                Object[] params = new Object[]{info};
                String[] signature = new String[]{"com.sun.enterprise.admin.common.DownloadRequestInfo"};
                info = (DownloadRequestInfo)this.mbsc.invoke(mbeanName, MCDOWNLOAD_FILE, params, signature);
                if (chunkIndex != info.getChunkIndex()) {
                    String msg = _localStrMgr.getString("admin.common.chunkidx", Integer.toString(chunkIndex), Integer.toString(info.getChunkIndex()));
                    throw new IOException(msg);
                }
                ByteChunk chunk = info.getChunk();
                info.setChunkIndex(++chunkIndex);
                lastChunk = chunk.isLast();
                byte[] bytes = chunk.getBytes();
                fos.write(bytes, 0, bytes.length);
                curSize += (long)bytes.length;
                long tFileSize = chunk.getTotalFileSize();
                if (tFileSize != totalFileSize) {
                    String msg = _localStrMgr.getString("admin.common.totalfs", Long.toString(totalFileSize), Long.toString(tFileSize));
                    throw new IOException(msg);
                }
                if (curSize == info.getNumberOfBytesSent()) continue;
                String msg = _localStrMgr.getString("admin.common.curfs", Long.toString(curSize), Long.toString(info.getNumberOfBytesSent()));
                throw new IOException(msg);
            }
            if (curSize < totalFileSize) {
                String msg = _localStrMgr.getString("admin.common.checksumerror", Long.toString(totalFileSize), Long.toString(curSize));
                throw new IOException(msg);
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
        return destPath.getPath();
    }
}

