/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.appserv.management.base.Util;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNames {
    public static final String kDefaultIASDomainName = "com.sun.appserv";
    public static final char kWildcardChar = '*';
    public static final char kDomainNameSeparatorChar = ':';
    public static final char kPropertySeparatorChar = ',';
    public static final char kNameValueSeparatorChar = '=';
    public static final char kSingleMatchChar = '?';
    public static final String kDomainNameInvalidatorString = "*:,=?";
    public static final String kTypeKeyName = "type";
    public static final String kNameKeyName = "name";
    public static final String kGroupIdKeyName = "group";
    public static final String kCategoryKeyName = "category";
    public static final String kClassIdKeyName = "class";
    public static final String kServerIdKeyName = "server";
    public static final String kDeployment = "deployment-service";
    public static final String kModuleTypeKeyName = "module-type";
    public static final String kServerInstanceKeyName = "instance-name";
    public static final String kApplicationNameKeyName = "app-name";
    public static final String kModuleNameKeyName = "module-name";
    public static final String kController = "controller";
    public static final String kConfig = "config";
    public static final String kServer = "server";
    public static final String kGenericConfigurator = "configurator";
    public static final String kSystemServices = "system-services";
    public static final String kServerInstance = "server-instance";
    public static final String kApplication = "application";
    public static final String kModule = "module";
    public static final String kJMSAdminHandler = "jms-service";
    public static final String kLogService = "log-service";
    public static final String kComponentKeyName = "component";
    public static final String kOrbType = "orb";
    public static final String kOrbListenerType = "orblistener";
    public static final String kHTTPServiceType = "httpservice";
    public static final String kHTTPListenerType = "httplistener";
    public static final String kHTTPListenerIdKeyName = "http-listener-id";
    public static final String kSecurityServiceType = "securityservice";
    public static final String kVirtualServerClassType = "virtual-server-class";
    public static final String kVirtualServerClassDefaultName = "defaultclass";
    public static final String kVirtualServerClassIdKeyName = "virtual-server-class-id";
    public static final String kVirtualServerType = "virtual-server";
    public static final String kVirtualServerIdKeyName = "virtual-server-id";
    public static final String kMimeType = "mime";
    public static final String kMimeIdKeyName = "mime-id";
    public static final String kAclType = "acl";
    public static final String kAclIdKeyName = "acl-id";
    public static final String kAuthDbType = "authdb";
    public static final String kAuthDbIdKeyName = "authdbId";
    public static final String kAuthRealmType = "authrealm";
    public static final String kHTTPQosType = "http-qos";
    public static final String kJdbcConnectionPoolType = "jdbcpool";
    public static final String kJdbcResourceType = "jdbc-resource";
    public static final String kMailResourceType = "mail-resource";
    public static final String kJmsResourceType = "jms-resource";
    public static final String kJndiResourceType = "jndi-resource";
    public static final String kCustomResourceType = "custom-resource";
    public static final String kPersistenceManagerFactoryResourceType = "persistence-manager-factory-resource";
    public static final String kWebContainer = "web-container";
    public static final String kEjbContainer = "ejb-container";
    public static final String kMdbContainer = "mdb-container";
    public static final String kJtsComponent = "transaction-service";
    public static final String kJvmType = "java-config";
    public static final String kEjbModule = "ejb-module";
    public static final String kWebModule = "web-module";
    public static final String kStandaloneEjbModule = "standalone-ejb-module";
    public static final String kStandaloneWebModule = "standalone-web-module";
    public static final String kConnectorModule = "connector-module";
    public static final String kLifecycleModule = "lifecycle-module";
    public static final String kEjbType = "ejb";
    public static final String kServletType = "servlet";
    public static final String kMonitoringType = "monitor";
    public static final String kMonitoringClassName = "mclass";
    public static final String kMonitoringRootClass = "root";
    public static final String kProfiler = "profiler";
    public static final String kConfigCategory = "config";
    public static final String kCategoryConfig = Util.makeProp("category", "config");
    private static final ObjectName HADB_CONFIG_OBJECT_NAME = Util.newObjectName("com.sun.appserv", Util.concatenateProps(kCategoryConfig, Util.makeProp("type", "hadb-config")));
    public static final String kDottedNameDomainName = "com.sun.appserv";
    public static final String kDottedNameType = "dotted-name-support";
    public static final String kDottedNameRegistryNameKeyName = "dotted-name-registry";
    public static final String kDottedNameMonitoringRegistryNameKeyName = "dotted-name-monitoring-registry";
    public static final String kDottedNameGetSetNameKeyName = "dotted-name-get-set";
    private static final String USE_DEPLOYMENT_MBEAN = "com.sun.aas.deployment.UseDeploymentMBean";

    private ObjectNames() {
    }

    public static ObjectName getHADBConfigObjectName() {
        return HADB_CONFIG_OBJECT_NAME;
    }

    public static ObjectName getControllerObjectName() {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName}, new String[]{kController});
    }

    public static ObjectName getServerObjectName(String serverName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kCategoryKeyName}, new String[]{"server", serverName, "config"});
    }

    public static ObjectName getGenericConfiguratorObjectName() {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName}, new String[]{kGenericConfigurator});
    }

    public static ObjectName getSystemServicesObjectName() {
        return ObjectNames.getPerInstanceSystemServicesObjectName("server");
    }

    public static ObjectName getPerInstanceSystemServicesObjectName(String instanceId) {
        ObjectName on = ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, "server"}, new String[]{kSystemServices, instanceId});
        return on;
    }

    private static ObjectName getDottedNameObjectName(String name) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kNameKeyName, kTypeKeyName}, new String[]{name, kDottedNameType});
    }

    public static ObjectName getDottedNameRegistryObjectName() {
        return ObjectNames.getDottedNameObjectName(kDottedNameRegistryNameKeyName);
    }

    public static ObjectName getDottedNameMonitoringRegistryObjectName() {
        return ObjectNames.getDottedNameObjectName(kDottedNameMonitoringRegistryNameKeyName);
    }

    public static ObjectName getDottedNameGetSetObjectName() {
        return ObjectNames.getDottedNameObjectName(kDottedNameGetSetNameKeyName);
    }

    public static ObjectName getJMSAdminHandlerObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kJMSAdminHandler, instanceName});
    }

    public static ObjectName getJMSAdminHandlerObjectName() {
        Debug.println("This method is deprecated. Use the overloaded method instead.", 1);
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName}, new String[]{kJMSAdminHandler});
    }

    public static ObjectName getServerInstanceObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName}, new String[]{kServerInstance, instanceName});
    }

    public static ObjectName getServerInstanceObjectNamePattern() {
        ObjectName pattern = null;
        ObjectName tmp = ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName}, new String[]{kServerInstance});
        if (tmp != null) {
            String strPattern = tmp.toString() + ',';
            strPattern = strPattern + '*';
            try {
                pattern = new ObjectName(strPattern);
            }
            catch (MalformedObjectNameException mfone) {
                pattern = null;
                Debug.printStackTrace(mfone);
            }
        }
        return pattern;
    }

    public static ObjectName getDeploymentServiceObjectName(String instanceName) {
        if (System.getProperty(USE_DEPLOYMENT_MBEAN, "false").equals("true")) {
            return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kDeployment, instanceName});
        }
        return ObjectNames.getServerInstanceObjectName(instanceName);
    }

    public static ObjectName getApplicationObjectName(String instanceName, String appName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName}, new String[]{kApplication, appName, instanceName});
    }

    public static ObjectName getApplicationObjectNamePattern(String instanceName) {
        ObjectName pattern = null;
        ObjectName tmp = ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kApplication, instanceName});
        if (tmp != null) {
            String strPattern = tmp.toString() + ',';
            strPattern = strPattern + '*';
            try {
                pattern = new ObjectName(strPattern);
            }
            catch (MalformedObjectNameException mfone) {
                Debug.printStackTrace(mfone);
                pattern = null;
            }
        }
        return pattern;
    }

    public static ObjectName getModuleObjectName(String instanceName, String appName, String moduleName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kApplicationNameKeyName, kServerInstanceKeyName}, new String[]{kModule, moduleName, appName, instanceName});
    }

    public static ObjectName getEjbModuleObjectName(String instanceName, String moduleName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName, kModuleTypeKeyName}, new String[]{kModule, moduleName, instanceName, kEjbModule});
    }

    public static ObjectName getEjbModuleObjectName(String instanceName, String moduleName, String applicationName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName, kModuleTypeKeyName, kApplicationNameKeyName}, new String[]{kModule, moduleName, instanceName, kEjbModule, applicationName});
    }

    public static ObjectName getWebModuleObjectName(String instanceName, String moduleName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName, kModuleTypeKeyName}, new String[]{kModule, moduleName, instanceName, kWebModule});
    }

    public static ObjectName getWebModuleObjectName(String instanceName, String moduleName, String applicationName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName, kModuleTypeKeyName, kApplicationNameKeyName}, new String[]{kModule, moduleName, instanceName, kWebModule, applicationName});
    }

    public static ObjectName getConnectorModuleObjectName(String instanceName, String moduleName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName, kModuleTypeKeyName}, new String[]{kModule, moduleName, instanceName, kConnectorModule});
    }

    public static ObjectName getConnectorModuleObjectName(String instanceName, String moduleName, String applicationName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName, kModuleTypeKeyName, kApplicationNameKeyName}, new String[]{kModule, moduleName, instanceName, kConnectorModule, applicationName});
    }

    public static ObjectName getModuleObjectNamePattern(String instanceName, String appName) {
        ObjectName pattern = null;
        ObjectName tmp = ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kApplicationNameKeyName}, new String[]{kModule, instanceName, appName});
        if (tmp != null) {
            String strPattern = tmp.toString() + ',';
            strPattern = strPattern + '*';
            try {
                pattern = new ObjectName(strPattern);
            }
            catch (MalformedObjectNameException mfone) {
                pattern = null;
            }
        }
        return pattern;
    }

    public static ObjectName getModuleObjectName(String instanceName, String moduleName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName}, new String[]{kModule, moduleName, instanceName});
    }

    public static ObjectName getModuleObjectNamePattern(String instanceName) {
        ObjectName pattern = null;
        ObjectName tmp = ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kModule, instanceName});
        if (tmp != null) {
            try {
                String strPattern = tmp.toString() + ',';
                strPattern = strPattern + '*';
                pattern = new ObjectName(strPattern);
            }
            catch (MalformedObjectNameException mfone) {
                pattern = null;
                Debug.printStackTrace(mfone);
            }
        }
        return pattern;
    }

    public static ObjectName getORBObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kOrbType, instanceName});
    }

    public static ObjectName getIiopListenerObjectName(String instanceName, String listenerId) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kOrbListenerType, instanceName, listenerId});
    }

    public static ObjectName getJDBCConnectionPoolObjectName(String instanceName, String poolName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kJdbcConnectionPoolType, instanceName, poolName});
    }

    public static ObjectName getJDBCResourceObjectName(String instanceName, String jndiName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kJdbcResourceType, instanceName, jndiName});
    }

    public static ObjectName getJNDIResourceObjectName(String instanceName, String jndiName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kJndiResourceType, instanceName, jndiName});
    }

    public static ObjectName getJMSResourceObjectName(String instanceName, String jndiName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kJmsResourceType, instanceName, jndiName});
    }

    public static ObjectName getPersistenceManagerFactoryResourceObjectName(String instanceName, String jndiName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kPersistenceManagerFactoryResourceType, instanceName, jndiName});
    }

    public static ObjectName getMailResourceObjectName(String instanceName, String jndiName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kMailResourceType, instanceName, jndiName});
    }

    public static ObjectName getCustomResourceObjectName(String instanceName, String jndiName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kCustomResourceType, instanceName, jndiName});
    }

    public static ObjectName getWebContainerObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kWebContainer, instanceName});
    }

    public static ObjectName getEjbContainerObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kEjbContainer, instanceName});
    }

    public static ObjectName getMdbContainerObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kMdbContainer, instanceName});
    }

    public static ObjectName getJVMComponentObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kJvmType, instanceName});
    }

    public static ObjectName getJTSComponentObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kJtsComponent, instanceName});
    }

    public static ObjectName getLogServiceObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kLogService, instanceName});
    }

    public static ObjectName getSecurityServiceObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kSecurityServiceType, instanceName});
    }

    public static ObjectName getHttpListenerObjectName(String instanceName, String id) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName}, new String[]{kHTTPListenerType, id, instanceName});
    }

    public static ObjectName getHttpServiceObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kHTTPServiceType, instanceName});
    }

    public static ObjectName getVirtualServerClassObjectName(String instanceName, String classId) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName}, new String[]{kVirtualServerClassType, classId, instanceName});
    }

    public static ObjectName getVirtualServerObjectName(String instanceName, String virtualServerClassId, String virtualServerId) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kVirtualServerClassIdKeyName, kServerInstanceKeyName}, new String[]{kVirtualServerType, virtualServerId, virtualServerClassId, instanceName});
    }

    public static ObjectName getVirtualServerAuthDBObjectName(String instanceName, String virtualServerClassId, String virtualServerId, String authDBId) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kVirtualServerIdKeyName, kVirtualServerClassIdKeyName, kServerInstanceKeyName}, new String[]{kAuthDbType, authDBId, virtualServerId, virtualServerClassId, instanceName});
    }

    public static ObjectName getMimeObjectName(String instanceName, String id) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName}, new String[]{kMimeType, id, instanceName});
    }

    public static ObjectName getAclObjectName(String instanceName, String id) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName}, new String[]{kAclType, id, instanceName});
    }

    public static ObjectName getLifeCycleModuleObjectName(String instanceName, String name) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kServerInstanceKeyName}, new String[]{kLifecycleModule, name, instanceName});
    }

    public static ObjectName getEjbObjectName(String instanceName, String moduleName, String ejbName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kModuleNameKeyName, kServerInstanceKeyName}, new String[]{kEjbType, ejbName, moduleName, instanceName});
    }

    public static ObjectName getEjbObjectName(String instanceName, String appName, String moduleName, String ejbName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kModuleNameKeyName, kApplicationNameKeyName, kServerInstanceKeyName}, new String[]{kEjbType, ejbName, moduleName, appName, instanceName});
    }

    public static ObjectName getServletObjectName(String instanceName, String moduleName, String servletName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kModuleNameKeyName, kServerInstanceKeyName}, new String[]{kServletType, servletName, moduleName, instanceName});
    }

    public static ObjectName getServletObjectName(String instanceName, String appName, String moduleName, String servletName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kNameKeyName, kModuleNameKeyName, kApplicationNameKeyName, kServerInstanceKeyName}, new String[]{kServletType, servletName, moduleName, appName, instanceName});
    }

    public static ObjectName getRootMonitorMBeanName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kMonitoringClassName, kServerInstanceKeyName, kNameKeyName}, new String[]{kMonitoringType, kMonitoringRootClass, instanceName, kMonitoringRootClass});
    }

    public static ObjectName getProfilerObjectName(String instanceName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName}, new String[]{kProfiler, instanceName});
    }

    public static ObjectName getAuthRealmObjectName(String instanceName, String realmName) {
        return ObjectNames.getObjectName("com.sun.appserv", new String[]{kTypeKeyName, kServerInstanceKeyName, kNameKeyName}, new String[]{kAuthRealmType, instanceName, realmName});
    }

    public static ObjectName getObjectName(String domainName, String[] keyNames, String[] keyValues) {
        ObjectName validObjectName = null;
        try {
            if (domainName == null || !ObjectNames.isDomainNameValid(domainName) || keyNames == null || keyValues == null || keyNames.length < 1 || keyNames.length != keyValues.length) {
                throw new IllegalArgumentException();
            }
            StringBuffer nameBuffer = new StringBuffer();
            nameBuffer.append(domainName);
            nameBuffer.append(':');
            for (int i = 0; i < keyNames.length; ++i) {
                if (keyNames[i] == null || keyValues[i] == null) {
                    throw new IllegalArgumentException();
                }
                nameBuffer.append(keyNames[i]);
                nameBuffer.append('=');
                nameBuffer.append(keyValues[i]);
                if (i == keyNames.length - 1) continue;
                nameBuffer.append(',');
            }
            validObjectName = new ObjectName(nameBuffer.toString());
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return validObjectName;
    }

    public static ObjectName getAllObjectNamesPattern() {
        String name = "com.sun.appserv:*";
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isDomainNameValid(String name) {
        boolean isValid = false;
        isValid = name.indexOf(42) == -1 && name.indexOf(58) == -1 && name.indexOf(44) == -1 && name.indexOf(61) == -1 && name.indexOf(63) == -1;
        return isValid;
    }

    public static void main(String[] args) throws Exception {
        Logger.log(ObjectNames.getServerInstanceObjectName("ias1"));
        Logger.log(ObjectNames.getApplicationObjectName("ias1", "app1"));
        Logger.log(ObjectNames.getControllerObjectName());
        Logger.log(ObjectNames.getModuleObjectName("ias1", "standalone"));
        Logger.log(ObjectNames.getModuleObjectName("ias1", "app1", "inner"));
        Logger.log(ObjectNames.getObjectName("ias111", new String[]{"key1", "key2", "key3"}, new String[]{"v1", "v2", "v3"}));
        ObjectName pattern = ObjectNames.getServerInstanceObjectNamePattern();
        Logger.log("" + pattern.isPropertyPattern());
        pattern = ObjectNames.getApplicationObjectNamePattern("ias1");
        Logger.log("" + pattern.isPropertyPattern());
        pattern = ObjectNames.getModuleObjectNamePattern("ias1");
        Logger.log("" + pattern.isPropertyPattern());
        pattern = ObjectNames.getModuleObjectNamePattern("ias1", "bank");
        Logger.log("" + pattern.isPropertyPattern());
        ObjectName jmsObjectName = ObjectNames.getJMSAdminHandlerObjectName("ias1");
        Logger.log("JMS Objectname = " + jmsObjectName.toString());
        jmsObjectName = ObjectNames.getJMSAdminHandlerObjectName();
        Logger.log("JMS Objectname = " + jmsObjectName.toString());
        ObjectName httpListener = ObjectNames.getHttpListenerObjectName("ias1", "listener1");
        Logger.log("Http listener object name = " + httpListener);
        ObjectName mime = ObjectNames.getMimeObjectName("ias1", "text/html");
        Logger.log("Mime object name = " + mime);
        ObjectName acl = ObjectNames.getAclObjectName("ias1", "acl1");
        Logger.log("ACL object name = " + acl);
    }
}

