/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta;

import com.sun.enterprise.admin.BaseAdminMBean;
import com.sun.enterprise.admin.meta.MBeanMetaConstants;
import com.sun.enterprise.admin.meta.MBeanMetaException;
import com.sun.enterprise.admin.meta.MBeanMetaHelper;
import com.sun.enterprise.admin.meta.naming.MBeanNamingDescriptor;
import com.sun.enterprise.admin.meta.naming.MBeanNamingException;
import com.sun.enterprise.admin.meta.naming.MBeanNamingInfo;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.org.apache.commons.modeler.AttributeInfo;
import com.sun.org.apache.commons.modeler.FeatureInfo;
import com.sun.org.apache.commons.modeler.FieldInfo;
import com.sun.org.apache.commons.modeler.ManagedBean;
import com.sun.org.apache.commons.modeler.OperationInfo;
import com.sun.org.apache.commons.modeler.ParameterInfo;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;

public class MBeanRegistryEntry
implements MBeanMetaConstants {
    MBeanNamingDescriptor namingDescriptor = null;
    private ManagedBean managedBean = null;
    private HashMap fields = null;
    private boolean _bIntrospectMBeanClass = true;
    static final String filler = "                                                                                                             ";

    public MBeanRegistryEntry(ManagedBean mb) throws MBeanNamingException, ClassNotFoundException {
        this(mb, true);
    }

    public MBeanRegistryEntry(ManagedBean mb, boolean bMergeWithMbean) throws MBeanNamingException, ClassNotFoundException {
        String group;
        this._bIntrospectMBeanClass = bMergeWithMbean;
        this.managedBean = mb;
        this.fields = MBeanRegistryEntry.convertListOfFieldsToHashMap(mb.getFields());
        String dynList = (String)this.fields.get("dynamicallyReconfigurable");
        if (dynList != null) {
            this.fields.put("dynamicallyReconfigurable", MBeanRegistryEntry.convertDelimListToSet(dynList));
        }
        String clazz = this.managedBean.getClassName();
        if (!this._bIntrospectMBeanClass || clazz.startsWith("com.sun.org.apache")) {
            clazz = null;
        }
        if ("config".equals(group = this.managedBean.getGroup())) {
            if (clazz == null) {
                clazz = "com.sun.enterprise.admin.config.BaseConfigMBean";
                this.managedBean.setClassName(clazz);
            } else if (clazz.indexOf(46) < 0) {
                clazz = "com.sun.enterprise.admin.config.mbeans." + clazz;
            }
            MBeanMetaHelper.mergeWithConfigBean(this.managedBean, MBeanMetaHelper.getConfigBeanClass((String)this.fields.get("xpath")), 65535);
            MBeanMetaHelper.mergeWithDynamicMBean(this.managedBean, Class.forName(clazz));
        } else if ("runtime".equals(group)) {
            Class configBeanClass;
            if (clazz == null) {
                clazz = "com.sun.enterprise.admin.runtime.BaseRuntimeMBean";
                this.managedBean.setClassName(clazz);
            } else if (clazz.indexOf(46) < 0) {
                clazz = "com.sun.enterprise.admin.runtime.mbeans" + clazz;
            }
            Class modelBeanClass = MBeanMetaHelper.getRuntimeModelBeanClass(mb.getName());
            if (modelBeanClass != null) {
                MBeanMetaHelper.mergeWithRuntimeModelBean(this.managedBean, modelBeanClass);
            }
            if ((configBeanClass = MBeanMetaHelper.getConfigBeanClass((String)this.fields.get("xpath"))) != null) {
                int mode = modelBeanClass != null ? 1 : 9;
                MBeanMetaHelper.mergeWithConfigBean(this.managedBean, configBeanClass, mode);
            }
            MBeanMetaHelper.mergeWithDynamicMBean(this.managedBean, Class.forName(clazz));
        }
        this.namingDescriptor = new MBeanNamingDescriptor(mb.getName(), new Integer(1), (String)this.fields.get("CLIName"), (String)this.fields.get("ObjectName"), MBeanNamingDescriptor.XPATH_TO_MASK((String)this.fields.get("xpath")), clazz);
    }

    public String toString() {
        OperationInfo[] opers;
        String str = "\n--- MBeanRegistryEntry:\n   ";
        if (this.managedBean != null) {
            str = str + this.managedBean.toString() + "\n   " + MBeanMetaHelper.descriptorToString(this.managedBean.getFields());
        }
        AttributeInfo[] attrs = this.managedBean.getAttributes();
        str = str + "\n\n      --- Attributes:";
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                if ("modelerType".equals(attrs[i].getName())) continue;
                str = str + "\n         " + attrs[i].toString();
                if (attrs[i].getFields().size() <= 0) continue;
                str = str + "\n            " + MBeanMetaHelper.descriptorToString(attrs[i].getFields());
            }
        }
        if ((opers = this.managedBean.getOperations()) != null && opers.length > 0) {
            str = str + "\n\n      --- Operations:";
            for (int i = 0; i < opers.length; ++i) {
                ParameterInfo[] params;
                str = str + "\n         " + opers[i].toString();
                if (opers[i].getFields().size() > 0) {
                    str = str + "\n            " + MBeanMetaHelper.descriptorToString(opers[i].getFields());
                }
                if ((params = opers[i].getSignature()) == null || params.length <= 0) continue;
                str = str + "\n            --- Parameters:";
                for (int j = 0; j < params.length; ++j) {
                    str = str + "\n            " + params[j].toString();
                    if (params[j].getFields().size() <= 0) continue;
                    str = str + "\n            " + MBeanMetaHelper.descriptorToString(params[j].getFields());
                }
            }
        }
        return str;
    }

    private String fillStr(String name, int minSize) {
        if (name.length() >= minSize) {
            return name;
        }
        return name + filler.substring(0, minSize - name.length());
    }

    private String formatClassName(String className, int minSize) {
        if (className == null || className.length() == 0) {
            className = "void";
        } else {
            int iLast = className.lastIndexOf(46);
            boolean bArray = className.startsWith("[");
            if (iLast >= 0) {
                className = className.substring(iLast + 1);
            }
            if (bArray) {
                className = className.substring(0, className.length() - 1) + "[]";
            }
        }
        return this.fillStr(className, minSize);
    }

    public String toFormatString() {
        OperationInfo[] opers;
        String str = "\n\n*************** mbean type:" + this.managedBean.getName() + " ***************";
        str = str + "\n--- ObjectName =" + this.fields.get("ObjectName");
        str = str + "\n--- XPath =" + this.fields.get("xpath");
        AttributeInfo[] attrs = this.managedBean.getAttributes();
        str = str + "\n--- Attributes:";
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                if ("modelerType".equals(attrs[i].getName())) continue;
                str = str + "\n " + this.formatClassName(attrs[i].getType(), 12) + " " + attrs[i].getName() + ",";
                if (attrs[i].getDescription() == null) continue;
                str = str + str + " // " + attrs[i].getDescription();
            }
        }
        if ((opers = this.managedBean.getOperations()) != null && opers.length > 0) {
            str = str + "\n--- Operations:";
            for (int i = 0; i < opers.length; ++i) {
                String wrk = this.formatClassName(opers[i].getReturnType(), 14) + " " + opers[i].getName() + "(";
                str = str + "\n" + wrk;
                wrk = this.fillStr("\n", wrk.length() + 1);
                ParameterInfo[] params = opers[i].getSignature();
                if (params != null && params.length > 0) {
                    for (int j = 0; j < params.length; ++j) {
                        if (j != 0) {
                            str = str + wrk;
                        }
                        str = str + this.formatClassName(params[j].getType(), 0) + " " + params[j].getName();
                    }
                }
                str = str + ");";
                if (opers[i].getDescription() == null) continue;
                str = str + str + " // " + opers[i].getDescription();
            }
        }
        return str;
    }

    private static HashMap convertListOfFieldsToHashMap(List fields) {
        Iterator iter = fields.iterator();
        HashMap<String, Object> fldsMap = new HashMap<String, Object>();
        while (iter.hasNext()) {
            FieldInfo field = (FieldInfo)iter.next();
            fldsMap.put(field.getName(), field.getValue());
        }
        return fldsMap;
    }

    private static Set convertDelimListToSet(String list) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, ", ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() <= 0) continue;
            set.add(token);
        }
        return set;
    }

    public String getName() {
        if (this.managedBean != null) {
            return this.managedBean.getName();
        }
        return null;
    }

    public MBeanNamingDescriptor getNamingDescriptor() {
        return this.namingDescriptor;
    }

    public boolean isObjectNamePatternMatch(Hashtable ht) {
        if (this.namingDescriptor != null) {
            return this.namingDescriptor.isObjectNamePatternMatch(ht);
        }
        return false;
    }

    public boolean isObjectNamePatternMatch(ObjectName objectName) {
        if (this.namingDescriptor != null) {
            return this.namingDescriptor.isObjectNamePatternMatch(objectName);
        }
        return false;
    }

    public String[] getAttributeNames() {
        AttributeInfo[] infos = this.managedBean.getAttributes();
        if (infos == null) {
            return new String[0];
        }
        String[] names = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            names[i] = infos[i].getName();
        }
        return names;
    }

    public void mergeAttribute(String attrName, String attrType, String attrGetMethod, String attrSetMethod, boolean attrReadable, boolean attrWriteable) {
        AttributeInfo ai = this.findAttributeInfo(attrName);
        if (ai == null) {
            ai = new AttributeInfo();
            ai.setName(attrName);
            ai.setType(attrType);
            this.managedBean.addAttribute(ai);
        }
        if (ai.isReadable() && !attrReadable) {
            ai.setReadable(false);
        }
        if (ai.isWriteable() && !attrWriteable) {
            ai.setWriteable(false);
        }
        if (attrGetMethod != null) {
            ai.setGetMethod(attrGetMethod);
        }
        if (attrSetMethod != null) {
            ai.setSetMethod(attrSetMethod);
        }
    }

    private FeatureInfo findFeatureInfo(String attrName, FeatureInfo[] features) {
        if (attrName == null) {
            return null;
        }
        for (int i = 0; i < features.length; ++i) {
            if (!attrName.equals(features[i].getName())) continue;
            return features[i];
        }
        return null;
    }

    private AttributeInfo findAttributeInfo(String attrName) {
        return (AttributeInfo)this.findFeatureInfo(attrName, this.managedBean.getAttributes());
    }

    public String getElementChangeEventName() {
        return (String)this.fields.get("elementChangeEvent");
    }

    public Set getDynamicallyReconfigurableAttributes() {
        return (Set)this.fields.get("dynamicallyReconfigurable");
    }

    private boolean checkItemsInReconfigurableSet(String name1, String name2) {
        Set set = this.getDynamicallyReconfigurableAttributes();
        if (set == null || set.size() < 1) {
            return false;
        }
        return set.contains("**") || set.contains(name1) || name2 != null && set.contains(name2);
    }

    public boolean isAttributeDynamicallyReconfigurable(String attr) {
        return this.checkItemsInReconfigurableSet(attr, "*");
    }

    public boolean isPropertyDynamicallyReconfigurable(String attr) {
        return this.checkItemsInReconfigurableSet("property." + attr, "property.*");
    }

    public boolean isElementCreationDynamicallyReconfigurable() {
        return this.checkItemsInReconfigurableSet("+", null);
    }

    public boolean isElementDeletionDynamicallyReconfigurable() {
        return this.checkItemsInReconfigurableSet("-", null);
    }

    public boolean isElementDynamicallyReconfigurable() {
        return this.checkItemsInReconfigurableSet("**", null);
    }

    public boolean isAttributeEmptyValueAllowed(String attrName) throws MBeanMetaException {
        AttributeInfo ai = this.findAttributeInfo(attrName);
        if (ai == null) {
            throw new MBeanMetaException("Attribute info is not founmd for attribute " + attrName);
        }
        List fields = ai.getFields();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                Object value;
                if (!"emptyValueAllowed".equals(((FieldInfo)fields.get(i)).getName()) || (value = ((FieldInfo)fields.get(i)).getValue()) == null || !(value instanceof String) || !"true".equalsIgnoreCase((String)value) && !"yes".equalsIgnoreCase((String)value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAttributeDynamicReconfigNeeded(String attrName) throws MBeanMetaException {
        AttributeInfo ai = this.findAttributeInfo(attrName);
        if (ai == null) {
            throw new MBeanMetaException("Attribute info is not founmd for attribute " + attrName);
        }
        List fields = ai.getFields();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                Object value;
                if (!"dynamicReconfigNeeded".equals(((FieldInfo)fields.get(i)).getName()) || (value = ((FieldInfo)fields.get(i)).getValue()) == null || !(value instanceof String) || !"false".equalsIgnoreCase((String)value) && !"no".equalsIgnoreCase((String)value)) continue;
                return false;
            }
        }
        return true;
    }

    public ModelMBeanInfo createMBeanInfo(MBeanNamingInfo namingInfo, String domainName) throws Exception {
        this.managedBean.setDescription(this.managedBean.getDescription());
        ModelMBeanInfo info = this.managedBean.createMBeanInfo();
        Descriptor descr = info.getMBeanDescriptor();
        if (domainName != null) {
            descr.setField("domainName", domainName);
        }
        if (namingInfo != null) {
            descr.setField("namingType", namingInfo.getType());
            descr.setField("namingLocation", namingInfo.getLocationParams());
        }
        info.setMBeanDescriptor(descr);
        return info;
    }

    public BaseAdminMBean instantiateMBean(ObjectName objectName, Object managedResource, ConfigContext ctx) throws Exception {
        String domainName = objectName.getDomain();
        return this.instantiateMBean(new MBeanNamingInfo(this.namingDescriptor, objectName), managedResource, domainName, ctx);
    }

    public BaseAdminMBean instantiateMBean(String type, String[] location, Object managedResource, String domainName, ConfigContext ctx) throws Exception {
        return this.instantiateMBean(new MBeanNamingInfo(this.namingDescriptor, type, location), managedResource, domainName, ctx);
    }

    private BaseAdminMBean instantiateMBean(MBeanNamingInfo namingInfo, Object managedResource, String domainName, ConfigContext ctx) throws Exception {
        if (this.managedBean == null) {
            return null;
        }
        ModelMBeanInfo mbi = this.createMBeanInfo(namingInfo, domainName);
        String clazz = this.managedBean.getClassName();
        String group = this.managedBean.getGroup();
        Constructor<?> constructor = Class.forName(clazz).getConstructor(new Class[0]);
        BaseAdminMBean mbean = (BaseAdminMBean)constructor.newInstance(new Object[0]);
        mbean.setModelMBeanInfo(mbi);
        String xpath = namingInfo.getXPath();
        if ("config".equals(group)) {
            if (xpath != null && xpath.length() > 0) {
                ConfigBean configBean = ConfigBeansFactory.getConfigBeanByXPath(ctx, xpath);
                if (configBean != null) {
                    mbean.setManagedResource(configBean, "ConfigBeanReference");
                } else {
                    throw new MBeanMetaException("instantiateMBean(): config mbean does not exist for xpath - " + xpath);
                }
            }
            return mbean;
        }
        if ("runtime".equals(group)) {
            Constructor<?> ctr;
            String[] location;
            Class<?> cl;
            String beanClassName;
            ConfigBean configBean;
            if (xpath != null && xpath.length() > 0 && (configBean = ConfigBeansFactory.getConfigBeanByXPath(ctx, xpath)) != null) {
                mbean.setManagedResource(configBean, "ConfigBeanReference");
            }
            if ((beanClassName = (String)this.fields.get("Jsr77MdlBeanClass")) == null || beanClassName.length() == 0) {
                beanClassName = "com.sun.enterprise.management.model." + namingInfo.getType() + "Mdl";
            }
            if (managedResource == null && (cl = Class.forName(beanClassName)) != null && (location = namingInfo.getLocationParams()) != null && (ctr = cl.getConstructor(location.getClass())) != null) {
                managedResource = ctr.newInstance(new Object[]{location});
            }
            if (managedResource != null) {
                mbean.setManagedResource(managedResource, "Jsr77ModelBeanReference");
            }
            return mbean;
        }
        return null;
    }

    public String getElementPrintName() {
        return (String)this.fields.get("printName");
    }
}

