/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RRStateFactory;
import com.sun.enterprise.admin.server.core.channel.RemoteAdminChannel;
import com.sun.enterprise.server.ss.ASSocketService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;

public class AdminChannelServer
extends UnicastRemoteObject
implements RemoteAdminChannel {
    private String localAddress = null;
    private byte[] myKey;
    private int instanceStatus = 1;
    private boolean restartNeeded = RRStateFactory.getState();
    private int conflictedPort = 0;
    private static final String CLIENT_HOST_NULL = "channel.client_host_null";
    private static final String LOCAL_ACCESS = "channel.local_access";
    private static final String ADDR_MISMATCH = "channel.addr_mismatch";
    private static final String NO_LOCAL_HOST = "channel.no_local_host";
    private static final String KEY_MISMATCH = "channel.key_mismatch";
    private static StringManager localStrings = StringManager.getManager(AdminChannelServer.class);

    public AdminChannelServer() throws RemoteException {
    }

    public AdminChannelServer(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    public AdminEventResult sendNotification(byte[] key, AdminEvent event) throws RemoteException {
        if (!this.checkAccess()) {
            String msg = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(msg);
        }
        if (!this.keyMatches(key)) {
            String msg = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(msg);
        }
        return AdminEventMulticaster.multicastEvent(event);
    }

    public boolean pingServer(byte[] key) throws RemoteException {
        if (!this.checkAccess()) {
            String msg = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(msg);
        }
        if (!this.keyMatches(key)) {
            String msg = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    public int getServerStatusCode(byte[] key) throws RemoteException {
        if (!this.checkAccess()) {
            String msg = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(msg);
        }
        if (!this.keyMatches(key)) {
            String msg = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(msg);
        }
        return this.instanceStatus;
    }

    public boolean isRestartNeeded(byte[] key) throws RemoteException {
        if (!this.checkAccess()) {
            String msg = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(msg);
        }
        if (!this.keyMatches(key)) {
            String msg = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(msg);
        }
        return this.restartNeeded;
    }

    public void setRestartNeeded(byte[] key, boolean needRestart) throws RemoteException {
        if (!this.checkAccess()) {
            String msg = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(msg);
        }
        if (!this.keyMatches(key)) {
            String msg = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(msg);
        }
        try {
            RRStateFactory.saveState(needRestart);
        }
        catch (IOException ioe) {
            String msg = localStrings.getString("admin.server.core.channel.unable_saving_state_file");
            throw new RuntimeException(msg, ioe);
        }
        this.restartNeeded = needRestart;
    }

    public int getConflictedPort(byte[] key) {
        if (!this.checkAccess()) {
            String msg = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(msg);
        }
        if (!this.keyMatches(key)) {
            String msg = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(msg);
        }
        return this.conflictedPort;
    }

    public void triggerServerExit(byte[] key) {
        if (!this.checkAccess()) {
            String msg = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(msg);
        }
        if (!this.keyMatches(key)) {
            String msg = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(msg);
        }
        ASSocketService.triggerServerExit();
    }

    void setSharedInfo(byte[] seed) {
        this.myKey = seed;
    }

    RemoteStub getRemoteStub() throws NoSuchObjectException {
        return (RemoteStub)RemoteObject.toStub(this);
    }

    void setLocalAddress(InetAddress address) {
        this.localAddress = address.getHostAddress();
    }

    void setChannelStarting() {
        this.instanceStatus = 1;
    }

    void setChannelReady() {
        this.instanceStatus = 0;
    }

    void setChannelStopping() {
        this.instanceStatus = 2;
    }

    void setChannelAborting(int conflictedPort) {
        this.conflictedPort = conflictedPort;
        this.instanceStatus = 8;
    }

    private boolean checkAccess() {
        boolean allowed = true;
        String addr = null;
        if ("high".equals(AdminChannel.getAccessLevel())) {
            boolean matchAddress = true;
            try {
                addr = this.getClientHost();
                if (addr == null) {
                    AdminChannel.warn(CLIENT_HOST_NULL);
                    allowed = false;
                    matchAddress = false;
                }
            }
            catch (ServerNotActiveException snae) {
                AdminChannel.warn(LOCAL_ACCESS);
                AdminChannel.debug(snae);
                matchAddress = false;
            }
            if (matchAddress) {
                allowed = this.addressMatches(addr);
            }
        }
        if (!allowed) {
            AdminChannel.debug(ADDR_MISMATCH, new Object[]{addr, this.getLocalAddress()});
        }
        return allowed;
    }

    private boolean addressMatches(String addr) {
        String localAddr = this.getLocalAddress();
        if (localAddr == null) {
            return false;
        }
        return addr.equals(localAddr);
    }

    private String getLocalAddress() {
        if (this.localAddress == null) {
            InetAddress inetAddr = null;
            try {
                inetAddr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                AdminChannel.warn(NO_LOCAL_HOST);
                AdminChannel.debug(uhe);
            }
            if (inetAddr != null) {
                this.localAddress = inetAddr.getHostAddress();
            }
        }
        return this.localAddress;
    }

    private boolean keyMatches(byte[] key) {
        boolean matches = true;
        if ("high".equals(AdminChannel.getKeyCheckLevel())) {
            matches = this.checkKeyLength(key);
            for (int i = 0; matches && i < 16; ++i) {
                if (key[i] == this.myKey[i]) continue;
                matches = false;
            }
        } else if ("medium".equals(AdminChannel.getKeyCheckLevel())) {
            matches = this.checkKeyLength(key);
        }
        if (!matches) {
            AdminChannel.debug(KEY_MISMATCH, new Object[]{new String(key), new String(this.myKey)});
        }
        return matches;
    }

    private boolean checkKeyLength(byte[] key) {
        return key.length == 16;
    }
}

