/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.target;

import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;

public class ServerTarget
extends Target {
    protected ServerTarget(String name, ConfigContext cc) {
        super(name, cc);
    }

    public TargetType getType() {
        return TargetType.SERVER;
    }

    public String getTargetObjectName(String[] tokens) {
        this.checkTokens(tokens, 1);
        return tokens[0] + ":type=server,category=config,name=" + this.getName();
    }

    public ConfigTarget getConfigTarget() throws Exception {
        return new ConfigTarget(this.getConfigRef(), this.getConfigContext());
    }

    public String getConfigRef() throws ConfigException {
        Config config = ServerHelper.getConfigForServer(this.getConfigContext(), this.getName());
        return config.getName();
    }

    public Server[] getServers() throws ConfigException {
        Server[] servers = new Server[]{ServerHelper.getServerByName(this.getConfigContext(), this.getName())};
        return servers;
    }

    public Cluster[] getClusters() throws ConfigException {
        Cluster[] clusters = new Cluster[]{ClusterHelper.getClusterForInstance(this.getConfigContext(), this.getName())};
        return clusters;
    }

    public Config[] getConfigs() throws ConfigException {
        Config[] configs = new Config[]{ServerHelper.getConfigForServer(this.getConfigContext(), this.getName())};
        return configs;
    }

    public NodeAgent[] getNodeAgents() throws ConfigException {
        NodeAgent[] agents = new NodeAgent[]{NodeAgentHelper.getNodeAgentForServer(this.getConfigContext(), this.getName())};
        return agents;
    }

    public ApplicationRef[] getApplicationRefs() throws ConfigException {
        return ServerHelper.getApplicationReferences(this.getConfigContext(), this.getName());
    }

    public ResourceRef[] getResourceRefs() throws ConfigException {
        return ServerHelper.getResourceReferences(this.getConfigContext(), this.getName());
    }
}

