/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.appclient.AppClientInfo;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAppClientInfo
extends AppClientInfo {
    private Application appDesc = null;
    private ApplicationClientDescriptor selectedAppClientDescriptor = null;
    private String displayNameFromCommandLine;

    public NestedAppClientInfo(boolean isJWS, Logger logger, File archive, Archivist archivist, String mainClassFromCommandLine, String displayNameFromCommandLine) {
        super(isJWS, logger, archive, archivist, mainClassFromCommandLine);
        this.displayNameFromCommandLine = displayNameFromCommandLine;
    }

    @Override
    protected ApplicationClientDescriptor getAppClient(Archivist archivist) {
        if (this.selectedAppClientDescriptor != null) {
            return this.selectedAppClientDescriptor;
        }
        Application app = (Application)Application.class.cast(archivist.getDescriptor());
        Set embeddedAppClients = app.getApplicationClientDescriptors();
        if (embeddedAppClients.size() == 0) {
            throw new IllegalArgumentException(this.localStrings.getString("appclient.noEmbeddedAppClients"));
        }
        if (embeddedAppClients.size() == 1) {
            this.selectedAppClientDescriptor = this.useFirstEmbeddedAppClient(embeddedAppClients, this.mainClassFromCommandLine);
        } else {
            this.selectedAppClientDescriptor = this.chooseFromEmbeddedAppClients(embeddedAppClients, this.mainClassFromCommandLine, this.displayNameFromCommandLine);
            if (this.selectedAppClientDescriptor == null) {
                if (this.mainClassFromCommandLine != null) {
                    throw new IllegalArgumentException(this.localStrings.getString("appclient.noMatchingClientUsingMainClass", this.mainClassFromCommandLine));
                }
                throw new IllegalArgumentException(this.localStrings.getString("appclient.noMatchingClientUsingDisplayName", this.displayNameFromCommandLine));
            }
        }
        return this.selectedAppClientDescriptor;
    }

    private ApplicationClientDescriptor chooseFromEmbeddedAppClients(Set<ApplicationClientDescriptor> embeddedAppClients, String mainClassFromCommandLine, String displayNameFromCommandLine) {
        ApplicationClientDescriptor result = null;
        for (ApplicationClientDescriptor candidate : embeddedAppClients) {
            if (mainClassFromCommandLine != null) {
                if (!candidate.getMainClassName().equals(mainClassFromCommandLine)) continue;
                result = candidate;
                break;
            }
            if (!candidate.getName().equals(displayNameFromCommandLine)) continue;
            if (result == null) {
                result = candidate;
                continue;
            }
            throw new IllegalArgumentException(this.localStrings.getString("appclient.duplicate_display_name", displayNameFromCommandLine));
        }
        return result;
    }

    private ApplicationClientDescriptor useFirstEmbeddedAppClient(Set<ApplicationClientDescriptor> embeddedAppClients, String mainClassNameFromCommandLine) {
        ApplicationClientDescriptor result = null;
        Iterator<ApplicationClientDescriptor> it = embeddedAppClients.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException(this.localStrings.getString("appclient.unexpectedEndOfEmbeddedClients"));
        }
        result = embeddedAppClients.iterator().next();
        if (mainClassNameFromCommandLine != null) {
            result.setMainClassName(mainClassNameFromCommandLine);
        }
        return result;
    }

    @Override
    protected AbstractArchive expand(File file) throws IOException, Exception {
        File tmpDir = this.createTmpArchiveDir(file);
        this._logger.fine("Expanding original archive " + file.getAbsolutePath() + " into " + tmpDir.getAbsolutePath());
        J2EEModuleExploder.explodeJar(file, tmpDir);
        FileArchive appArchive = new FileArchive();
        appArchive.open(tmpDir.getAbsolutePath());
        ApplicationArchivist archivist = new ApplicationArchivist();
        this.appDesc = archivist.hasStandardDeploymentDescriptor(appArchive) ? (Application)archivist.readStandardDeploymentDescriptor(appArchive) : Application.createApplication(appArchive, true);
        Iterator bundles = this.appDesc.getModules();
        while (bundles.hasNext()) {
            ModuleDescriptor bundle = (ModuleDescriptor)bundles.next();
            String moduleName = bundle.getArchiveUri();
            File srcArchive = new File(tmpDir, moduleName);
            if (!srcArchive.exists()) continue;
            String massagedModuleName = FileUtils.makeFriendlyFilename(moduleName);
            File moduleDir = new File(tmpDir, massagedModuleName);
            J2EEModuleExploder.explodeJar(srcArchive, moduleDir);
            srcArchive.delete();
        }
        return appArchive;
    }

    @Override
    protected List<String> getClassPaths(AbstractArchive archive) {
        ArrayList<String> paths = new ArrayList<String>();
        String appRoot = archive.getArchiveUri();
        paths.add(appRoot);
        if (this.appDesc != null) {
            Iterator bundles = this.appDesc.getModules();
            while (bundles.hasNext()) {
                ModuleDescriptor bundle = (ModuleDescriptor)bundles.next();
                String moduleRoot = appRoot + File.separator + FileUtils.makeFriendlyFilename(bundle.getArchiveUri());
                paths.add(moduleRoot);
                File manifestFile = new File(moduleRoot, "META-INF/MANIFEST.MF");
                if (!manifestFile.exists()) continue;
                Manifest mf = null;
                FileInputStream manifestIS = null;
                try {
                    String classPathString;
                    manifestIS = new FileInputStream(manifestFile);
                    mf = new Manifest(manifestIS);
                    Attributes mainAttrs = mf.getMainAttributes();
                    if (mainAttrs == null || (classPathString = mainAttrs.getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                    URI appRootURI = new File(appRoot).toURI();
                    String bundleURIString = bundle.getArchiveUri();
                    int lastSlash = bundleURIString.lastIndexOf("/");
                    String parentURIString = lastSlash >= 0 ? bundleURIString.substring(0, lastSlash) : "";
                    String parentDirPath = new File(appRootURI.resolve(parentURIString)).getAbsolutePath();
                    for (String classPathElement : classPathString.split(" ")) {
                        paths.add(parentDirPath + File.separator + classPathElement.replace("/", File.separator));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(this.localStrings.getString("appclient.cannotOpenModuleManifest", bundle.getArchiveUri()), e);
                }
                finally {
                    if (manifestIS == null) continue;
                    try {
                        ((InputStream)manifestIS).close();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(this.localStrings.getString("appclient.cannotCloseModuleManifest", bundle.getArchiveUri()), ioe);
                    }
                }
            }
        }
        Enumeration en = archive.entries();
        while (en.hasMoreElements()) {
            String entryName = (String)en.nextElement();
            if (!entryName.endsWith(".jar")) continue;
            String entry = appRoot + File.separator + entryName;
            paths.add(entry);
        }
        return paths;
    }

    @Override
    protected String getAppClientRoot(AbstractArchive archive, ApplicationClientDescriptor descriptor) {
        String appRoot = archive.getArchiveUri();
        String moduleUri = descriptor.getModuleDescriptor().getArchiveUri();
        String moduleRoot = appRoot + File.separator + FileUtils.makeFriendlyFilename(moduleUri);
        return moduleRoot;
    }
}

