/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ReferenceHelperBase;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;

public class ConfigAPIHelper
extends ReferenceHelperBase
implements IAdminConstants {
    protected static final StringManager _strMgr = StringManager.getManager(ConfigAPIHelper.class);
    private static ConfigAPIHelper _theInstance;
    private static final String[] ILLEGAL_NAME_STRINGS;

    protected Server[] getReferencingServers(ConfigContext configContext, String name) throws ConfigException {
        return ServerHelper.getServersReferencingConfig(configContext, name);
    }

    protected Cluster[] getReferencingClusters(ConfigContext configContext, String name) throws ConfigException {
        return ClusterHelper.getClustersReferencingConfig(configContext, name);
    }

    private static synchronized ConfigAPIHelper getInstance() {
        if (_theInstance == null) {
            _theInstance = new ConfigAPIHelper();
        }
        return _theInstance;
    }

    public static Domain getDomainConfigBean(ConfigContext configCtxt) throws ConfigException {
        return ServerBeansFactory.getDomainBean(configCtxt);
    }

    public static Config[] getConfigsInDomain(ConfigContext configContext) throws ConfigException {
        Domain domain = ConfigAPIHelper.getDomainConfigBean(configContext);
        return domain.getConfigs().getConfig();
    }

    public static boolean isAConfig(ConfigContext configContext, String configName) throws ConfigException {
        Domain domain = ConfigAPIHelper.getDomainConfigBean(configContext);
        Config config = domain.getConfigs().getConfigByName(configName);
        return config != null;
    }

    public static Config getConfigByName(ConfigContext configContext, String configName) throws ConfigException {
        Domain domain = ConfigAPIHelper.getDomainConfigBean(configContext);
        Config config = domain.getConfigs().getConfigByName(configName);
        if (config == null) {
            throw new ConfigException(_strMgr.getString("noSuchConfig", configName));
        }
        return config;
    }

    public static boolean isNameUnique(ConfigContext configContext, String name) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].getName().equals(name)) continue;
            return false;
        }
        Config[] configs = ConfigAPIHelper.getConfigsInDomain(configContext);
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getName().equals(name)) continue;
            return false;
        }
        Cluster[] clusters = ClusterHelper.getClustersInDomain(configContext);
        for (int i = 0; i < clusters.length; ++i) {
            if (!clusters[i].getName().equals(name)) continue;
            return false;
        }
        NodeAgent[] controllers = NodeAgentHelper.getNodeAgentsInDomain(configContext);
        for (int i = 0; i < controllers.length; ++i) {
            if (!controllers[i].getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public static void checkLegalName(String name) throws ConfigException {
        for (int i = 0; i < ILLEGAL_NAME_STRINGS.length; ++i) {
            if (name.indexOf(ILLEGAL_NAME_STRINGS[i]) < 0) continue;
            String s = _strMgr.getString("illegalName", ILLEGAL_NAME_STRINGS[i]);
            throw new ConfigException(s);
        }
    }

    public static String getStandAloneConfigurationName(String name) {
        return name + "-config";
    }

    public static boolean isConfigurationNameStandAlone(String configName, String name) {
        return configName.equals(ConfigAPIHelper.getStandAloneConfigurationName(name));
    }

    public static boolean isConfigurationReferenced(ConfigContext configContext, String configName) throws ConfigException {
        return ConfigAPIHelper.getInstance().isReferenced(configContext, configName);
    }

    public static boolean isConfigurationReferencedByServerOnly(ConfigContext configContext, String configName, String serverName) throws ConfigException {
        return ConfigAPIHelper.getInstance().isReferencedByServerOnly(configContext, configName, serverName);
    }

    public static boolean isConfigurationReferencedByClusterOnly(ConfigContext configContext, String configName, String clusterName) throws ConfigException {
        return ConfigAPIHelper.getInstance().isReferencedByClusterOnly(configContext, configName, clusterName);
    }

    public static String getConfigurationReferenceesAsString(ConfigContext configContext, String configName) throws ConfigException {
        return ConfigAPIHelper.getInstance().getReferenceesAsString(configContext, configName);
    }

    static {
        ILLEGAL_NAME_STRINGS = new String[]{"--"};
    }
}

