/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.util.ConfigXPathHelper;

public final class ServerXPathHelper {
    public static final String DEFAULT_CONFIG_MODEL_NAME = "server-config";
    public static final String REGEX_DEFAULT_CONFIG_MODEL_NAME = "server\\-config";
    public static final String DEFAULT_HOST_MODEL_NAME = "host1";
    public static final String REGEX_ONE_PLUS = "{1,}";
    public static final String XPATH_SEPARATOR = "/";
    public static final String XPATH_DOMAIN = "/domain";
    public static final String REGEX_XPATH_DOMAIN = "/{1,}domain";
    public static final String XPATH_CONFIG = "/domain/configs/config[@name='server-config']";
    public static final String REGEX_XPATH_CONFIG = "/{1,}domain/{1,}configs/{1,}config[@name='server\\-config']";
    public static final String XPATH_APPLICATIONS = "/domain/applications";
    public static final String XPATH_J2EE_APPLICATION = "/domain/applications/j2ee-application";
    public static final String XPATH_EJB_MODULE = "/domain/applications/ejb-module";
    public static final String XPATH_WEB_MODULE = "/domain/applications/web-module";
    public static final String XPATH_CONNECTOR_MODULE = "/domain/applications/connector-module";
    public static final String XPATH_APPCLIENT_MODULE = "/domain/applications/appclient-module";
    public static final String XPATH_LIFECYCLE_MODULE = "/domain/applications/lifecycle-module";
    public static final String XPATH_LOG_SERVICE = "/domain/configs/config[@name='server-config']/log-service";
    public static final String XPATH_SECURITY_SERVICE = "/domain/configs/config[@name='server-config']/security-service";
    public static final String XPATH_SECURITY_AUTH_REALM = "/domain/configs/config[@name='server-config']/security-service/auth-realm";
    public static final String XPATH_RESOURCES = "/domain/resources";
    public static final String XPATH_JDBC_RESOURCE = "/domain/resources/jdbc-resource";
    public static final String XPATH_JNDI_RESOURCE = "/domain/resources/external-jndi-resource";
    public static final String XPATH_CUSTOM_RESOURCE = "/domain/resources/custom-resource";
    public static final String XPATH_JDBC_CONNECTION_POOL = "/domain/resources/jdbc-connection-pool";
    public static final String XPATH_PM_FACTORY_RESOURCE = "/domain/resources/persistence-manager-factory-resource";
    public static final String XPATH_MAIL_RESOURCE = "/domain/resources/mail-resource";
    public static final String XPATH_ADMIN_OBJECT_RESOURCE = "/domain/resources/admin-object-resource";
    public static final String XPATH_CONNECTOR_RESOURCE = "/domain/resources/connector-resource";
    public static final String XPATH_CONNECTOR_CONNECTION_POOL = "/domain/resources/connector-connection-pool";
    public static final String XPATH_RESOURCE_ADAPTER_CONFIG = "/domain/resources/resource-adapter-config";
    public static final String XPATH_HTTP_SERVICE = "/domain/configs/config[@name='server-config']/http-service";
    public static final String XPATH_HTTP_LISTENER = "/domain/configs/config[@name='server-config']/http-service/http-listener";
    public static final String XPATH_TRANSACTION_SERVICE = "/domain/configs/config[@name='server-config']/transaction-service";
    public static final String XPATH_JMS_SERVICE = "/domain/configs/config[@name='server-config']/jms-service";
    public static final String XPATH_IIOP_SERVICE = "/domain/configs/config[@name='server-config']/iiop-service";
    public static final String XPATH_ORB = "/domain/configs/config[@name='server-config']/iiop-service/orb";
    public static final String XPATH_IIOP_LISTENER = "/domain/configs/config[@name='server-config']/iiop-service/iiop-listener";
    public static final String XPATH_MDB_CONTAINER = "/domain/configs/config[@name='server-config']/mdb-container";
    public static final String XPATH_WEB_CONTAINER = "/domain/configs/config[@name='server-config']/web-container";
    public static final String XPATH_EJB_CONTAINER = "/domain/configs/config[@name='server-config']/ejb-container";
    public static final String XPATH_JAVACONFIG = "/domain/configs/config[@name='server-config']/java-config";
    public static final String XPATH_PROFILER = "/domain/configs/config[@name='server-config']/java-config/profiler";

    public static String getServerIdXpath(String serverId) {
        return "/domain/servers/server[@name='" + serverId + "']";
    }

    public static String getConfigIdXpath(String configId) {
        return "/domain/configs/config[@name='" + configId + "']";
    }

    public static String getAppIdXpathExpression(String appId) {
        return "/domain/applications/j2ee-application[@name='" + appId + "']";
    }

    public static String getEjbModuleIdXpathExpression(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_EJB_MODULE, "name", moduleId);
    }

    public static String getWebModuleIdXpathExpression(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_WEB_MODULE, "name", moduleId);
    }

    public static String getConnectorModuleIdXpathExpression(String moduleId) {
        return "/domain/applications/connector-module[@name='" + moduleId + "']";
    }

    public static String getAppClientModuleIdXpathExpression(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_APPCLIENT_MODULE, "name", moduleId);
    }

    public static String getLifecycleModuleIdXpath(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_LIFECYCLE_MODULE, "name", moduleId);
    }

    public static String getJDBCResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBC_RESOURCE, "jndi-name", jndiId);
    }

    public static String getJNDIResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JNDI_RESOURCE, "jndi-name", jndiId);
    }

    public static String getMailResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_MAIL_RESOURCE, "jndi-name", jndiId);
    }

    public static String getCustomResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_CUSTOM_RESOURCE, "jndi-name", jndiId);
    }

    public static String getJDBCConnectionPoolIdXpath(String poolId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBC_CONNECTION_POOL, "name", poolId);
    }

    public static String getPMFactoryResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_PM_FACTORY_RESOURCE, "jndi-name", jndiId);
    }

    public static String getMDBContainerXpath() {
        return XPATH_MDB_CONTAINER;
    }

    public static String getWEBContainerXpath() {
        return XPATH_WEB_CONTAINER;
    }

    public static String getEJBContainerXpath() {
        return XPATH_EJB_CONTAINER;
    }

    public static String getTransactionServiceXpath() {
        return XPATH_TRANSACTION_SERVICE;
    }

    public static String getJmsServiceXpath() {
        return XPATH_JMS_SERVICE;
    }

    public static String getHTTPServiceXpath() {
        return XPATH_HTTP_SERVICE;
    }

    public static String getHTTPListenerIdXpath(String id) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_HTTP_LISTENER, "id", id);
    }

    public static String getVirtualServerIdXpath(String classId, String id) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression("/domain/configs/config[@name='server-config']/http-service/virtual-server", "id", id);
    }

    public static String getIIOPServiceXpath() {
        return XPATH_IIOP_SERVICE;
    }

    public static String getOrbXpath() {
        return XPATH_ORB;
    }

    public static String getIIOPListenerIdXpath(String id) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_IIOP_LISTENER, "id", id);
    }

    public static String getLogServiceXpath() {
        return XPATH_LOG_SERVICE;
    }

    public static String getSecurityServiceXpath() {
        return XPATH_SECURITY_SERVICE;
    }

    public static String getSecurityAuthRealmIdXpath(String name) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_SECURITY_AUTH_REALM, "name", name);
    }

    public static String getJavaConfigXpath() {
        return XPATH_JAVACONFIG;
    }

    public static String getProfilerXpath() {
        return XPATH_PROFILER;
    }

    public static String getAbsoluteIdXpathExpression(String childTagName, String nameId, String valueId) {
        return ConfigXPathHelper.getAbsoluteIdXpathExpression(childTagName, nameId, valueId);
    }

    public static String getLastNodeName(String xPath) {
        return ConfigXPathHelper.getLastNodeName(xPath);
    }

    public static String getParentXPath(String xPath) {
        return ConfigXPathHelper.getParentXPath(xPath);
    }
}

