/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ConnectorService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.DASResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.InstanceFactory;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesUtil {
    static final int NO_OF_ALL_CONNECTOR_RESOURCE_TYPE = 4;
    static final int NO_OF_CONNECTOR_RESOURCE_TYPE = 3;
    static final int NO_OF_JDBC_RESOURCE_TYPE = 2;
    public static final String RA_CONFIGS = "ra_configs";
    public static final String CONNECTION_POOLS = "connection_pools";
    public static final String RESOURCES = "resources";
    static ThreadLocal<ResourcesUtil> localResourcesUtil = new ThreadLocal();
    static ServerContext sc_ = null;
    Resources res = null;
    Domain dom = null;
    ConfigContext configContext_ = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    static StringManager localStrings = StringManager.getManager(ResourcesUtil.class);

    public static void setServerContext(ServerContext sc) {
        sc_ = sc;
    }

    public static ResourcesUtil createInstance() {
        if (localResourcesUtil.get() != null) {
            return localResourcesUtil.get();
        }
        if (sc_ == null) {
            String message = localStrings.getStringWithDefault("server_context_is_null", "Server context is null. Hence cannot create instance of ResourcesUtil or DASResourcesUtil.");
            _logger.log(Level.SEVERE, message);
            return null;
        }
        try {
            if (ResourcesUtil.isDAS()) {
                return new DASResourcesUtil();
            }
            return new ResourcesUtil();
        }
        catch (ConfigException ex) {
            String message = localStrings.getStringWithDefault("caught_config_exception", "Caught ConfigException while instantiating ResourcesUtil or DASResourcesUtil : ");
            _logger.log(Level.SEVERE, message + ex.getMessage(), ex);
            return null;
        }
    }

    protected ResourcesUtil() throws ConfigException {
        this(sc_.getConfigContext());
    }

    protected ResourcesUtil(ConfigContext configContext) throws ConfigException {
        try {
            this.configContext_ = configContext;
            this.dom = ServerBeansFactory.getDomainBean(this.configContext_);
            this.res = this.dom.getResources();
        }
        catch (ConfigException ex) {
            String message = localStrings.getStringWithDefault("caught_config_exception", "Caught ConfigException while instantiating ResourcesUtil or DASResourcesUtil : ");
            throw new ConfigException(message, ex);
        }
    }

    public ConfigBean[][] getConnectorResources() throws ConfigException {
        return this.getConnectorResources(false);
    }

    public ConfigBean[][] getConnectorResources(boolean onlystandAloneRars) throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[4][];
        Map allConnectorResources = this.getFilteredAllConnectorResources(onlystandAloneRars, false, null);
        configBeanArray[0] = (ConfigBean[])allConnectorResources.get(RA_CONFIGS);
        configBeanArray[1] = (ConfigBean[])allConnectorResources.get(CONNECTION_POOLS);
        configBeanArray[2] = (ConfigBean[])allConnectorResources.get(RESOURCES);
        configBeanArray[3] = this.getFilteredAdminObjectResources(onlystandAloneRars, false, null);
        return configBeanArray;
    }

    public ConfigBean[][] getStandAloneNonSystemRarConnectorResourcesWithoutRAConfigs() throws ConfigException {
        boolean onlystandAloneRars = true;
        ConfigBean[][] configBeanArray = new ConfigBean[3][];
        Map allConnectorResources = this.getFilteredAllConnectorResources(onlystandAloneRars, true, null);
        configBeanArray[0] = (ConfigBean[])allConnectorResources.get(CONNECTION_POOLS);
        configBeanArray[1] = (ConfigBean[])allConnectorResources.get(RESOURCES);
        configBeanArray[2] = this.getFilteredAdminObjectResources(onlystandAloneRars, true, null);
        return configBeanArray;
    }

    public ConfigBean[][] getAllConnectorResourcesForRar(String rarName) throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[3][];
        Map allConnectorResources = this.getFilteredAllConnectorResources(false, false, rarName);
        configBeanArray[0] = (ConfigBean[])allConnectorResources.get(CONNECTION_POOLS);
        configBeanArray[1] = (ConfigBean[])allConnectorResources.get(RESOURCES);
        configBeanArray[2] = this.getFilteredAdminObjectResources(false, false, rarName);
        return configBeanArray;
    }

    public ConfigBean[] getEnabledAdminObjectResources(String rarName) throws ConfigException {
        return this.getFilteredAdminObjectResources(false, false, rarName);
    }

    public Map getAllConnectorResources() throws ConfigException {
        return this.getFilteredAllConnectorResources(false, false, null);
    }

    private Map getFilteredAllConnectorResources(boolean onlystandAloneRars, boolean onlynonSystemRars, String rarName) throws ConfigException {
        HashMap<String, ConfigBean[]> allConnectorResources = new HashMap<String, ConfigBean[]>();
        int noOfConnectorResources = this.res.sizeConnectorResource();
        if (noOfConnectorResources == 0) {
            return allConnectorResources;
        }
        HashSet<ConnectorResource> standAloneRarConnectorResourcesVector = new HashSet<ConnectorResource>();
        HashSet<ConnectorResource> embeddedRarConnectorResourcesVector = new HashSet<ConnectorResource>();
        HashSet<ConnectorConnectionPool> standAloneRarPoolsVector = new HashSet<ConnectorConnectionPool>();
        HashSet<ConnectorConnectionPool> embeddedRarPoolsVector = new HashSet<ConnectorConnectionPool>();
        HashSet<ResourceAdapterConfig> standAloneRarConfigsVector = new HashSet<ResourceAdapterConfig>();
        HashSet<ResourceAdapterConfig> embeddedRarConfigsVector = new HashSet<ResourceAdapterConfig>();
        for (int i = 0; i < noOfConnectorResources; ++i) {
            String resourceAdapterName;
            ConnectorConnectionPool ccPool;
            ConnectorResource ccResource = this.res.getConnectorResource(i);
            if (ccResource == null || (ccPool = this.getConnectorConnectionPoolByName(ccResource.getPoolName())) == null || (resourceAdapterName = ccPool.getResourceAdapterName()) == null || rarName != null && !rarName.equals(resourceAdapterName) || !this.isEnabled(ccResource)) continue;
            if (this.belongToSystemRar(resourceAdapterName)) {
                if (onlynonSystemRars) continue;
                standAloneRarPoolsVector.add(ccPool);
                standAloneRarConnectorResourcesVector.add(ccResource);
                continue;
            }
            ResourceAdapterConfig resAdapterConfig = this.res.getResourceAdapterConfigByResourceAdapterName(resourceAdapterName);
            if (this.belongToStandAloneRar(resourceAdapterName)) {
                standAloneRarConfigsVector.add(resAdapterConfig);
                standAloneRarPoolsVector.add(ccPool);
                standAloneRarConnectorResourcesVector.add(ccResource);
                continue;
            }
            if (this.belongToEmbeddedRar(resourceAdapterName)) {
                embeddedRarConfigsVector.add(resAdapterConfig);
                embeddedRarPoolsVector.add(ccPool);
                embeddedRarConnectorResourcesVector.add(ccResource);
                continue;
            }
            String message = localStrings.getString("no.resource.adapter.found", resourceAdapterName, ccResource.getJndiName());
            _logger.warning(message);
        }
        ResourceAdapterConfig[] raConfigs = null;
        ConnectorConnectionPool[] ccPools = null;
        ConnectorResource[] ccResources = null;
        if (onlystandAloneRars) {
            raConfigs = new ResourceAdapterConfig[standAloneRarConfigsVector.size()];
            raConfigs = standAloneRarConfigsVector.toArray(raConfigs);
            ccPools = new ConnectorConnectionPool[standAloneRarPoolsVector.size()];
            ccPools = standAloneRarPoolsVector.toArray(ccPools);
            ccResources = new ConnectorResource[standAloneRarConnectorResourcesVector.size()];
            ccResources = standAloneRarConnectorResourcesVector.toArray(ccResources);
        } else {
            Vector<ConnectorResource> allConnectorResourcesVector = new Vector<ConnectorResource>();
            Vector<ConnectorConnectionPool> allPoolsVector = new Vector<ConnectorConnectionPool>();
            Vector<ResourceAdapterConfig> allRaConfigs = new Vector<ResourceAdapterConfig>();
            allConnectorResourcesVector.addAll(standAloneRarConnectorResourcesVector);
            allConnectorResourcesVector.addAll(embeddedRarConnectorResourcesVector);
            allPoolsVector.addAll(standAloneRarPoolsVector);
            allPoolsVector.addAll(embeddedRarPoolsVector);
            allRaConfigs.addAll(standAloneRarConfigsVector);
            allRaConfigs.addAll(embeddedRarConfigsVector);
            raConfigs = new ResourceAdapterConfig[allRaConfigs.size()];
            raConfigs = allRaConfigs.toArray(raConfigs);
            ccPools = new ConnectorConnectionPool[allPoolsVector.size()];
            ccPools = allPoolsVector.toArray(ccPools);
            ccResources = new ConnectorResource[allConnectorResourcesVector.size()];
            ccResources = allConnectorResourcesVector.toArray(ccResources);
        }
        allConnectorResources.put(RA_CONFIGS, raConfigs);
        allConnectorResources.put(CONNECTION_POOLS, ccPools);
        allConnectorResources.put(RESOURCES, ccResources);
        return allConnectorResources;
    }

    private ConfigBean[] getFilteredAdminObjectResources(boolean onlystandAloneRars, boolean onlynonSystemRars, String rarName) throws ConfigException {
        int noOfAdminObjectResources = this.res.sizeAdminObjectResource();
        if (noOfAdminObjectResources == 0) {
            return null;
        }
        Vector<AdminObjectResource> standAloneRarAdminObjectResourcesVector = new Vector<AdminObjectResource>();
        Vector<AdminObjectResource> embeddedRarAdminObjectResourcesVector = new Vector<AdminObjectResource>();
        for (int i = 0; i < noOfAdminObjectResources; ++i) {
            String resourceAdapterName;
            AdminObjectResource adminObjectResource = this.res.getAdminObjectResource(i);
            if (adminObjectResource == null || (resourceAdapterName = adminObjectResource.getResAdapter()) == null || rarName != null && !rarName.equals(resourceAdapterName) || !this.isEnabled(adminObjectResource)) continue;
            if (this.belongToSystemRar(resourceAdapterName)) {
                if (onlynonSystemRars) continue;
                standAloneRarAdminObjectResourcesVector.add(adminObjectResource);
                continue;
            }
            if (this.belongToStandAloneRar(resourceAdapterName)) {
                standAloneRarAdminObjectResourcesVector.add(adminObjectResource);
                continue;
            }
            if (this.belongToEmbeddedRar(resourceAdapterName)) {
                embeddedRarAdminObjectResourcesVector.add(adminObjectResource);
                continue;
            }
            String message = localStrings.getString("no.resource.adapter.found", resourceAdapterName, adminObjectResource.getJndiName());
            _logger.warning(message);
        }
        if (onlystandAloneRars) {
            ConfigBean[] standAloneRarAdminObjectResources = new AdminObjectResource[standAloneRarAdminObjectResourcesVector.size()];
            standAloneRarAdminObjectResources = standAloneRarAdminObjectResourcesVector.toArray(standAloneRarAdminObjectResources);
            return standAloneRarAdminObjectResources;
        }
        Vector<AdminObjectResource> allAdminObjectResourcesVector = new Vector<AdminObjectResource>();
        allAdminObjectResourcesVector.addAll(standAloneRarAdminObjectResourcesVector);
        allAdminObjectResourcesVector.addAll(embeddedRarAdminObjectResourcesVector);
        ConfigBean[] allAdminObjectResources = new AdminObjectResource[allAdminObjectResourcesVector.size()];
        allAdminObjectResources = allAdminObjectResourcesVector.toArray(allAdminObjectResources);
        return allAdminObjectResources;
    }

    public boolean belongToSystemRar(String resourceAdapterName) {
        Iterator iter = ConnectorRuntime.systemRarNames.iterator();
        while (iter.hasNext()) {
            if (!resourceAdapterName.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean belongToStandAloneRar(String resourceAdapterName) {
        Applications apps = this.dom.getApplications();
        ConnectorModule connectorModule = apps.getConnectorModuleByName(resourceAdapterName);
        return connectorModule != null;
    }

    public boolean belongToEmbeddedRar(String resourceAdapterName) {
        String appName = this.getAppNameToken(resourceAdapterName);
        if (appName == null) {
            return false;
        }
        Applications apps = this.dom.getApplications();
        J2eeApplication j2eeApp = apps.getJ2eeApplicationByName(appName);
        return j2eeApp != null;
    }

    public ConfigBean[] getResourceAdapterConfigs() throws ConfigException {
        ResourceAdapterConfig[] raConfigBeans = this.res.getResourceAdapterConfig();
        if (raConfigBeans == null || raConfigBeans.length == 0) {
            return null;
        }
        Vector<ResourceAdapterConfig> referencedResourceAdapterConfigs = new Vector<ResourceAdapterConfig>();
        for (int i = 0; i < raConfigBeans.length; ++i) {
            if (!this.isRarEnabled(raConfigBeans[i].getResourceAdapterName())) continue;
            referencedResourceAdapterConfigs.add(raConfigBeans[i]);
        }
        ConfigBean[] results = new ConfigBean[referencedResourceAdapterConfigs.size()];
        return referencedResourceAdapterConfigs.toArray(results);
    }

    public ConfigBean[] getResourceAdapterConfigs(String rarName) throws ConfigException {
        ResourceAdapterConfig[] raConfigBeans = this.res.getResourceAdapterConfig();
        if (raConfigBeans == null || raConfigBeans.length == 0) {
            return null;
        }
        for (int i = 0; raConfigBeans != null && i < raConfigBeans.length; ++i) {
            if (!raConfigBeans[i].getResourceAdapterName().equals(rarName)) continue;
            return new ConfigBean[]{raConfigBeans[i]};
        }
        return null;
    }

    public ConfigBean[] getEmbeddedRarResourceAdapterConfigs(String appName) throws ConfigException {
        Applications apps = this.dom.getApplications();
        J2eeApplication j2eeApp = apps.getJ2eeApplicationByName(appName);
        if (j2eeApp == null || !j2eeApp.isEnabled()) {
            return null;
        }
        ResourceAdapterConfig[] raConfigBeans = this.res.getResourceAdapterConfig();
        if (raConfigBeans == null) {
            return null;
        }
        String appNameToken = null;
        Vector<ResourceAdapterConfig> tmpVector = new Vector<ResourceAdapterConfig>();
        for (int i = 0; i < raConfigBeans.length; ++i) {
            appNameToken = this.getAppNameToken(raConfigBeans[i].getResourceAdapterName());
            if (appNameToken == null || !appName.equals(appNameToken)) continue;
            tmpVector.add(raConfigBeans[i]);
        }
        if (tmpVector.size() == 0) {
            return null;
        }
        ConfigBean[] result = new ConfigBean[tmpVector.size()];
        return tmpVector.toArray(result);
    }

    private String getAppNameToken(String rarName) {
        if (rarName == null) {
            return null;
        }
        int index = rarName.indexOf("#");
        if (index != -1) {
            return rarName.substring(0, index);
        }
        return null;
    }

    public static void setEventConfigContext(ConfigContext ctx) throws ConfigException {
        ResourcesUtil resUtil = null;
        resUtil = ResourcesUtil.isDAS() ? new DASResourcesUtil(ctx) : new ResourcesUtil(ctx);
        localResourcesUtil.set(resUtil);
    }

    public static void resetEventConfigContext() {
        localResourcesUtil.set(null);
    }

    public boolean poolBelongsToSystemRar(String poolName) {
        ConnectorConnectionPool ccPool = this.res.getConnectorConnectionPoolByName(poolName);
        if (ccPool != null) {
            return this.belongToSystemRar(ccPool.getResourceAdapterName());
        }
        JdbcConnectionPool jdbcPool = this.res.getJdbcConnectionPoolByName(poolName);
        return jdbcPool != null;
    }

    public boolean resourceBelongsToSystemRar(String resourceName) {
        ConnectorResource connectorResource = this.res.getConnectorResourceByJndiName(resourceName);
        if (connectorResource != null) {
            return this.poolBelongsToSystemRar(connectorResource.getPoolName());
        }
        JdbcResource jdbcResource = this.res.getJdbcResourceByJndiName(resourceName);
        return jdbcResource != null;
    }

    public boolean adminObjectBelongsToSystemRar(String adminObject) {
        AdminObjectResource aor = this.res.getAdminObjectResourceByJndiName(adminObject);
        if (aor != null) {
            return this.belongToSystemRar(aor.getResAdapter());
        }
        return false;
    }

    protected DeferredResourceConfig getDeferredConnectorResourceConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ConfigBean[] resourcesToload = new ConfigBean[2];
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            String message = localStrings.getString("error.finding.resources.references", resourceName);
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
        }
        ConnectorResource connectorResource = this.res.getConnectorResourceByJndiName(resourceName);
        if (connectorResource == null || !connectorResource.isEnabled()) {
            return null;
        }
        String poolName = connectorResource.getPoolName();
        ConnectorConnectionPool ccPool = this.res.getConnectorConnectionPoolByName(poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null) {
            resourcesToload[0] = ccPool;
            resourcesToload[1] = connectorResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{this.res.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, connectorResource, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredConnectorPoolConfigs(String poolName) {
        ConfigBean[] resourcesToload = new ConfigBean[1];
        if (poolName == null) {
            return null;
        }
        ConnectorConnectionPool ccPool = this.res.getConnectorConnectionPoolByName(poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null) {
            resourcesToload[0] = ccPool;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{this.res.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredAdminObjectConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ConfigBean[] resourcesToload = new ConfigBean[1];
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            String message = localStrings.getString("error.finding.resources.references", resourceName);
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
        }
        AdminObjectResource adminObjectResource = this.res.getAdminObjectResourceByJndiName(resourceName);
        if (adminObjectResource == null || !adminObjectResource.isEnabled()) {
            return null;
        }
        String rarName = adminObjectResource.getResAdapter();
        if (rarName != null) {
            resourcesToload[0] = adminObjectResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{this.res.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, adminObjectResource, null, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcResourceConfigs(String resourceName) {
        String cmpResourceName;
        ConfigBean[] resourcesToload = new ConfigBean[2];
        if (resourceName == null) {
            return null;
        }
        try {
            if (!resourceName.endsWith("__pm") && !this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            String message = localStrings.getString("error.finding.resources.references", resourceName);
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
        }
        JdbcResource jdbcResource = this.res.getJdbcResourceByJndiName(resourceName);
        if (!(jdbcResource != null && jdbcResource.isEnabled() || (jdbcResource = this.res.getJdbcResourceByJndiName(cmpResourceName = this.getCorrespondingCmpResourceName(resourceName))) != null)) {
            return null;
        }
        JdbcConnectionPool jdbcPool = this.res.getJdbcConnectionPoolByName(jdbcResource.getPoolName());
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRAForJdbcConnectionPool(jdbcPool);
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = jdbcPool;
            resourcesToload[1] = jdbcResource;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, jdbcResource, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcPoolConfigs(String poolName) {
        ConfigBean[] resourcesToload = new ConfigBean[1];
        if (poolName == null) {
            return null;
        }
        JdbcConnectionPool jdbcPool = this.res.getJdbcConnectionPoolByName(poolName);
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRAForJdbcConnectionPool(jdbcPool);
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = jdbcPool;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, null, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    public DeferredResourceConfig getDeferredResourceConfig(String resourceName) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorResourceConfigs(resourceName);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredJdbcResourceConfigs(resourceName);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredAdminObjectConfigs(resourceName);
        return resConfig;
    }

    public DeferredResourceConfig getDeferredPoolConfig(String poolName) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorPoolConfigs(poolName);
        if (resConfig != null) {
            return resConfig;
        }
        if (poolName == null) {
            return null;
        }
        resConfig = this.getDeferredJdbcPoolConfigs(poolName);
        return resConfig;
    }

    protected String getCorrespondingCmpResourceName(String resourceName) {
        int index = resourceName.lastIndexOf("__pm");
        if (index != -1) {
            return resourceName.substring(0, index);
        }
        return null;
    }

    public Object[] getConnectorResourcesJndiNames(String poolName) {
        Vector<String> jndiNamesVector = new Vector<String>();
        ConnectorResource[] connectorResource = this.res.getConnectorResource();
        if (connectorResource == null || connectorResource.length == 0) {
            return null;
        }
        for (int i = 0; i < connectorResource.length; ++i) {
            if (!connectorResource[i].getPoolName().equals(poolName)) continue;
            jndiNamesVector.add(connectorResource[i].getJndiName());
        }
        return jndiNamesVector.toArray();
    }

    public Object[] getConnectorConnectionPoolNames(String moduleName) {
        Vector<String> poolNamesVector = new Vector<String>();
        ConnectorConnectionPool[] connectorConnectionPool = this.res.getConnectorConnectionPool();
        if (connectorConnectionPool == null || connectorConnectionPool.length == 0) {
            return null;
        }
        for (int i = 0; i < connectorConnectionPool.length; ++i) {
            if (!connectorConnectionPool[i].getResourceAdapterName().equals(moduleName)) continue;
            poolNamesVector.add(connectorConnectionPool[i].getName());
        }
        return poolNamesVector.toArray();
    }

    public ConnectorConnectionPool[] getConnectorConnectionPools() {
        ConnectorConnectionPool[] connectorConnectionPool = null;
        connectorConnectionPool = this.res.getConnectorConnectionPool();
        if (connectorConnectionPool == null || connectorConnectionPool.length == 0) {
            return null;
        }
        return connectorConnectionPool;
    }

    public JdbcConnectionPool[] getJdbcConnectionPools() {
        JdbcConnectionPool[] jdbcConnectionPool = this.res.getJdbcConnectionPool();
        if (jdbcConnectionPool == null || jdbcConnectionPool.length == 0) {
            return null;
        }
        return jdbcConnectionPool;
    }

    public String[] getdbUserPasswordOfJdbcConnectionPool(JdbcConnectionPool jdbcConnectionPool) {
        String[] userPassword = new String[]{null, null};
        ElementProperty[] elementProperty = jdbcConnectionPool.getElementProperty();
        if (elementProperty == null || elementProperty.length == 0) {
            return userPassword;
        }
        for (int i = 0; i < elementProperty.length; ++i) {
            String prop = elementProperty[i].getName().toUpperCase();
            if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                userPassword[0] = elementProperty[i].getValue();
                continue;
            }
            if (!"PASSWORD".equals(prop)) continue;
            userPassword[1] = elementProperty[i].getValue();
        }
        return userPassword;
    }

    public String[] getdbUserPasswordOfConnectorConnectionPool(ConnectorConnectionPool connectorConnectionPool) {
        String[] userPassword = new String[]{null, null};
        ElementProperty[] elementProperty = connectorConnectionPool.getElementProperty();
        if (elementProperty != null && elementProperty.length != 0) {
            boolean foundUserPassword = false;
            for (int i = 0; i < elementProperty.length; ++i) {
                String prop = elementProperty[i].getName().toUpperCase();
                if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                    userPassword[0] = elementProperty[i].getValue();
                    foundUserPassword = true;
                    continue;
                }
                if (!"PASSWORD".equals(prop)) continue;
                userPassword[1] = elementProperty[i].getValue();
                foundUserPassword = true;
            }
            if (foundUserPassword) {
                return userPassword;
            }
        }
        String poolName = connectorConnectionPool.getName();
        String rarName = connectorConnectionPool.getResourceAdapterName();
        String connectionDefName = connectorConnectionPool.getConnectionDefinitionName();
        ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();
        ConnectorDescriptor connectorDescriptor = connectorRegistry.getDescriptor(rarName);
        ConnectionDefDescriptor cdd = connectorDescriptor.getConnectionDefinitionByCFType(connectionDefName);
        Set configProps = cdd.getConfigProperties();
        for (EnvironmentProperty envProp : configProps) {
            String prop = envProp.getName().toUpperCase();
            if ("USER".equals(prop) || "USERNAME".equals(prop)) {
                userPassword[0] = envProp.getValue();
                continue;
            }
            if (!"PASSWORD".equals(prop)) continue;
            userPassword[1] = envProp.getValue();
        }
        if (userPassword[0] != null && !"".equals(userPassword[0].trim())) {
            return userPassword;
        }
        ManagedConnectionFactory mcf = connectorRegistry.getManagedConnectionFactory(poolName);
        userPassword[0] = ConnectionPoolObjectsUtils.getValueFromMCF("UserName", poolName, mcf);
        userPassword[1] = ConnectionPoolObjectsUtils.getValueFromMCF("Password", poolName, mcf);
        return userPassword;
    }

    public String getResourceType(ConfigBean cb) {
        if (cb instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (cb instanceof ConnectorResource) {
            return "cr";
        }
        if (cb instanceof AdminObjectResource) {
            return "aor";
        }
        if (cb instanceof ResourceAdapterConfig) {
            return "rac";
        }
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }

    public String getLocation(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        String location = null;
        ConnectorModule connectorModule = this.dom.getApplications().getConnectorModuleByName(moduleName);
        if (connectorModule != null) {
            location = RelativePathResolver.resolvePath(connectorModule.getLocation());
        }
        return location;
    }

    public ConfigBean[][] getJdbcResources() throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[2][];
        Map allJdbcResources = this.getJdbcResourcesAsMap();
        configBeanArray[0] = (ConfigBean[])allJdbcResources.get(CONNECTION_POOLS);
        configBeanArray[1] = (ConfigBean[])allJdbcResources.get(RESOURCES);
        return configBeanArray;
    }

    public Map getJdbcResourcesAsMap() throws ConfigException {
        HashMap<String, ConfigBean[]> allJdbcResources = new HashMap<String, ConfigBean[]>();
        int noOfJdbcResources = this.res.sizeJdbcResource();
        if (noOfJdbcResources == 0) {
            return allJdbcResources;
        }
        Vector<JdbcResource> jdbcResourcesVector = new Vector<JdbcResource>();
        Vector<JdbcConnectionPool> jdbcPoolsVector = new Vector<JdbcConnectionPool>();
        for (int i = 0; i < noOfJdbcResources; ++i) {
            JdbcConnectionPool jdbcPool;
            JdbcResource jdbcResource = this.res.getJdbcResource(i);
            if (jdbcResource == null || (jdbcPool = this.getJdbcConnectionPoolByName(jdbcResource.getPoolName())) == null || !this.isEnabled(jdbcResource)) continue;
            jdbcResourcesVector.add(jdbcResource);
            if (jdbcPoolsVector.contains(jdbcPool)) continue;
            jdbcPoolsVector.add(jdbcPool);
        }
        if (jdbcResourcesVector.size() == 0) {
            return allJdbcResources;
        }
        JdbcConnectionPool[] jdbcPools = new JdbcConnectionPool[jdbcPoolsVector.size()];
        JdbcResource[] jdbcResources = new JdbcResource[jdbcResourcesVector.size()];
        jdbcPools = jdbcPoolsVector.toArray(jdbcPools);
        jdbcResources = jdbcResourcesVector.toArray(jdbcResources);
        allJdbcResources.put(CONNECTION_POOLS, jdbcPools);
        allJdbcResources.put(RESOURCES, jdbcResources);
        return allJdbcResources;
    }

    protected boolean isReferenced(String resourceName) throws ConfigException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isReferenced :: " + resourceName + " - " + ServerHelper.serverReferencesResource(this.configContext_, sc_.getInstanceName(), resourceName));
        }
        return ServerHelper.serverReferencesResource(this.configContext_, sc_.getInstanceName(), resourceName);
    }

    public boolean isEnabled(ConnectorResource cr) throws ConfigException {
        if (cr == null || !cr.isEnabled()) {
            return false;
        }
        if (!this.isResourceReferenceEnabled(cr.getJndiName())) {
            return false;
        }
        String poolName = cr.getPoolName();
        ConnectorConnectionPool ccp = this.res.getConnectorConnectionPoolByName(poolName);
        if (ccp == null) {
            return false;
        }
        return this.isEnabled(ccp);
    }

    public boolean isEnabled(AdminObjectResource aot) throws ConfigException {
        if (aot == null || !aot.isEnabled()) {
            return false;
        }
        if (!this.isResourceReferenceEnabled(aot.getJndiName())) {
            return false;
        }
        String raName = aot.getResAdapter();
        return this.isRarEnabled(raName);
    }

    public boolean isEnabled(ConnectorConnectionPool ccp) throws ConfigException {
        if (ccp == null) {
            return false;
        }
        String raName = ccp.getResourceAdapterName();
        return this.isRarEnabled(raName);
    }

    public boolean isEnabled(JdbcResource jr) throws ConfigException {
        if (jr == null || !jr.isEnabled()) {
            return false;
        }
        return this.isResourceReferenceEnabled(jr.getJndiName());
    }

    public boolean isEnabled(ResourceAdapterConfig rac) throws ConfigException {
        if (rac == null) {
            return false;
        }
        return this.isRarEnabled(rac.getResourceAdapterName());
    }

    private boolean isRarEnabled(String raName) throws ConfigException {
        if (raName == null || raName.length() == 0) {
            return false;
        }
        ConnectorModule module = this.dom.getApplications().getConnectorModuleByName(raName);
        if (module != null) {
            if (!module.isEnabled()) {
                return false;
            }
            return this.isApplicationReferenceEnabled(raName);
        }
        if (this.belongToSystemRar(raName)) {
            return true;
        }
        return this.belongToEmbeddedRarAndEnabled(raName);
    }

    private boolean belongToEmbeddedRarAndEnabled(String resourceAdapterName) throws ConfigException {
        String appName = this.getAppNameToken(resourceAdapterName);
        if (appName == null) {
            return false;
        }
        Applications apps = this.dom.getApplications();
        J2eeApplication j2eeApp = apps.getJ2eeApplicationByName(appName);
        if (j2eeApp == null || !j2eeApp.isEnabled()) {
            return false;
        }
        return this.isApplicationReferenceEnabled(appName);
    }

    public boolean belongToRar(String rarName, ConnectorConnectionPool ccp) {
        if (ccp == null || rarName == null) {
            return false;
        }
        return ccp.getResourceAdapterName().equals(rarName);
    }

    public boolean belongToRar(String rarName, ConnectorResource cr) {
        if (cr == null || rarName == null) {
            return false;
        }
        String poolName = cr.getPoolName();
        ConnectorConnectionPool ccp = this.res.getConnectorConnectionPoolByName(poolName);
        if (ccp == null) {
            return false;
        }
        return this.belongToRar(rarName, ccp);
    }

    public boolean belongToRar(String rarName, AdminObjectResource aor) {
        if (aor == null || rarName == null) {
            return false;
        }
        return aor.getResAdapter().equals(rarName);
    }

    public String getRAForJdbcConnectionPool(JdbcConnectionPool pool) {
        Class dsClass;
        String dsRAName = "__ds";
        if (pool.getResType() == null) {
            return dsRAName;
        }
        if ("javax.sql.XADataSource".equals(pool.getResType())) {
            if (pool.getDatasourceClassname() == null) {
                return dsRAName;
            }
            try {
                dsClass = Utility.loadClass(pool.getDatasourceClassname());
                if (XADataSource.class.isAssignableFrom(dsClass)) {
                    return "__xa";
                }
            }
            catch (ClassNotFoundException cnfe) {
                return dsRAName;
            }
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType())) {
            if (pool.getDatasourceClassname() == null) {
                return dsRAName;
            }
            try {
                dsClass = Utility.loadClass(pool.getDatasourceClassname());
                if (ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
                    return "__cp";
                }
            }
            catch (ClassNotFoundException cnfe) {
                return dsRAName;
            }
        }
        return dsRAName;
    }

    public ConnectorResource[] getAllJmsResources() throws ConfigException {
        ConnectorResource[] cr = (ConnectorResource[])this.getFilteredAllConnectorResources(false, false, "jmsra").get(RESOURCES);
        return cr;
    }

    public AdminObjectResource[] getAllJmsAdminObjects() throws ConfigException {
        AdminObjectResource[] aor = (AdminObjectResource[])this.getFilteredAdminObjectResources(false, false, "jmsra");
        return aor;
    }

    public int getShutdownTimeout() throws ConnectorRuntimeException {
        try {
            ConnectorService connectorServiceElement = ServerBeansFactory.getConnectorServiceBean(ApplicationServer.getServerContext().getConfigContext());
            if (connectorServiceElement == null) {
                int shutdownTimeout = 30;
                _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + "through default");
                return shutdownTimeout;
            }
            int shutdownTimeout = new Integer(connectorServiceElement.getShutdownTimeoutInSeconds());
            _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + " from domain.xml");
            return shutdownTimeout;
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            crex.initCause(e);
            throw crex;
        }
    }

    public static boolean isDAS() {
        try {
            return ServerHelper.isDAS(AdminService.getAdminService().getAdminContext().getAdminConfigContext(), sc_.getInstanceName());
        }
        catch (ConfigException ce) {
            return false;
        }
    }

    public boolean isPoolReferredInServerInstance(String poolName) throws ConfigException {
        ConnectorResource[] connRes = this.res.getConnectorResource();
        for (int i = 0; i < connRes.length; ++i) {
            _logger.fine("poolname " + connRes[i].getPoolName() + "resource " + connRes[i].getJndiName());
            if (!connRes[i].getPoolName().equalsIgnoreCase(poolName)) continue;
            _logger.fine("Connector resource " + connRes[i].getJndiName() + "refers " + poolName + "in this server instance");
            return true;
        }
        _logger.fine("No JDBC resource refers " + poolName + "in this server instance");
        return false;
    }

    public boolean isJdbcPoolReferredInServerInstance(String jdbcPoolName) throws ConfigException {
        JdbcResource[] jdbcRes = this.res.getJdbcResource();
        for (int i = 0; i < jdbcRes.length; ++i) {
            _logger.fine("poolname " + jdbcRes[i].getPoolName() + "resource " + jdbcRes[i].getJndiName() + " referred " + this.isReferenced(jdbcRes[i].getJndiName()));
            if (!jdbcRes[i].getPoolName().equalsIgnoreCase(jdbcPoolName) || !this.isReferenced(jdbcRes[i].getJndiName())) continue;
            _logger.fine("JDBC resource " + jdbcRes[i].getJndiName() + "refers " + jdbcPoolName + "in this server instance");
            return true;
        }
        _logger.fine("No JDBC resource refers " + jdbcPoolName + "in this server instance");
        return false;
    }

    public Application[] getDeployedApplications() throws ConfigException {
        String message;
        Application appDescriptor;
        int i;
        _logger.log(Level.FINE, "in ResourcesUtil.getApplicationNames()");
        Applications apps = this.dom.getApplications();
        J2eeApplication[] j2ee_apps = apps.getJ2eeApplication();
        EjbModule[] ejb_modules = apps.getEjbModule();
        ArrayList<Application> deployedAppsDescriptorList = new ArrayList<Application>();
        if (j2ee_apps.length + ejb_modules.length == 0) {
            return new Application[0];
        }
        AppsManager appsManager = this.getAppsManager();
        EjbModulesManager ejbModulesManager = this.getEjbModulesManager();
        for (i = 0; i < j2ee_apps.length; ++i) {
            String appName = j2ee_apps[i].getName();
            if (!ServerHelper.serverReferencesApplication(this.configContext_, sc_.getInstanceName(), appName)) continue;
            try {
                appDescriptor = appsManager.getAppDescriptor(appName, ASClassLoaderUtil.getSharedClassLoader());
                deployedAppsDescriptorList.add(appDescriptor);
                continue;
            }
            catch (Exception e) {
                message = localStrings.getString("error.getting.application.DD", appName);
                _logger.log(Level.WARNING, message + e.getMessage());
                _logger.log(Level.FINE, message + e.getMessage(), e);
            }
        }
        for (i = 0; i < ejb_modules.length; ++i) {
            String modName = ejb_modules[i].getName();
            if (!ServerHelper.serverReferencesApplication(this.configContext_, sc_.getInstanceName(), modName)) continue;
            try {
                appDescriptor = ejbModulesManager.getDescriptor(modName, ASClassLoaderUtil.getSharedClassLoader());
                deployedAppsDescriptorList.add(appDescriptor);
                continue;
            }
            catch (Exception e) {
                message = localStrings.getString("error.getting.module.DD", modName);
                _logger.log(Level.WARNING, message + e.getMessage());
                _logger.log(Level.FINE, message + e.getMessage(), e);
            }
        }
        return deployedAppsDescriptorList.toArray(new Application[0]);
    }

    public ConnectorDescriptor getConnectorDescriptorFromUri(String appName, String raLoc) throws ConfigException {
        AppsManager am = this.getAppsManager();
        Application app = am.getAppDescriptor(appName, ASClassLoaderUtil.getSharedClassLoader());
        return app.getRarDescriptorByUri(raLoc);
    }

    private AppsManager getAppsManager() throws ConfigException {
        InstanceEnvironment iEnv = sc_.getInstanceEnvironment();
        return InstanceFactory.createAppsManager(iEnv, false);
    }

    private EjbModulesManager getEjbModulesManager() throws ConfigException {
        InstanceEnvironment iEnv = sc_.getInstanceEnvironment();
        return InstanceFactory.createEjbModuleManager(iEnv, false);
    }

    public String getApplicationDeployLocation(String appName) {
        J2eeApplication app = this.dom.getApplications().getJ2eeApplicationByName(appName);
        return RelativePathResolver.resolvePath(app.getLocation());
    }

    private boolean isResourceReferenceEnabled(String resourceName) throws ConfigException {
        ResourceRef ref = ServerHelper.getServerByName(this.configContext_, sc_.getInstanceName()).getResourceRefByRef(resourceName);
        if (ref == null) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
            return this.isADeployEvent();
        }
        _logger.fine("ResourcesUtil :: isResourceReferenceEnabled ref enabled ?" + ref.isEnabled());
        return ref.isEnabled();
    }

    private boolean isApplicationReferenceEnabled(String appName) throws ConfigException {
        ApplicationRef appRef = ServerHelper.getServerByName(this.configContext_, sc_.getInstanceName()).getApplicationRefByRef(appName);
        if (appRef == null) {
            _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled null ref");
            return this.isADeployEvent();
        }
        _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled appRef enabled ?" + appRef.isEnabled());
        return appRef.isEnabled();
    }

    public boolean isEnabled(ConfigBean res) throws ConfigException {
        _logger.fine("ResourcesUtil :: isEnabled");
        if (res == null) {
            return false;
        }
        if (res instanceof JdbcResource) {
            return this.isEnabled((JdbcResource)res);
        }
        if (res instanceof ConnectorResource) {
            return this.isEnabled((ConnectorResource)res);
        }
        if (res instanceof AdminObjectResource) {
            return this.isEnabled((AdminObjectResource)res);
        }
        if (res instanceof ResourceAdapterConfig) {
            return this.isEnabled((ResourceAdapterConfig)res);
        }
        if (res instanceof ConnectorConnectionPool) {
            return this.isEnabled((ConnectorConnectionPool)res);
        }
        if (res instanceof JdbcConnectionPool) {
            return true;
        }
        if (!res.isEnabled()) {
            return false;
        }
        Server server = ServerBeansFactory.getServerBean(this.configContext_);
        ResourceRef resRef = server.getResourceRefByRef(res.getAttributeValue("jndi-name"));
        if (resRef == null) {
            return false;
        }
        return resRef.isEnabled();
    }

    public JdbcConnectionPool getJdbcConnectionPoolByName(String poolName) {
        return this.res.getJdbcConnectionPoolByName(poolName);
    }

    public ConnectorConnectionPool getConnectorConnectionPoolByName(String poolName) {
        return this.res.getConnectorConnectionPoolByName(poolName);
    }

    public JdbcConnectionPool getJDBCPoolForResource(String resourceName) throws ConfigException {
        JdbcResource jr = this.res.getJdbcResourceByJndiName(resourceName);
        if (this.isEnabled(jr)) {
            return this.getJdbcConnectionPoolByName(jr.getPoolName());
        }
        return null;
    }

    public PersistenceManagerFactoryResource getPMFResourceByJndiName(String jndiName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourceUtil :: looking up pmf resource, jndiName is :" + jndiName);
        }
        PersistenceManagerFactoryResource pmf = this.res.getPersistenceManagerFactoryResourceByJndiName(jndiName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("getPMFResourceByJndiName:: looked up pmf resource : " + pmf);
        }
        if (pmf == null) {
            return null;
        }
        try {
            return this.isReferenced(jndiName) ? pmf : null;
        }
        catch (ConfigException ce) {
            return null;
        }
    }

    public JdbcResource getJdbcResourceByJndiName(String jndiName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: looking up jdbc resource, jndiName is :" + jndiName);
        }
        JdbcResource jdbcRes = this.res.getJdbcResourceByJndiName(jndiName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: looked up jdbc resource:" + jdbcRes.getJndiName());
        }
        if (jdbcRes == null) {
            return null;
        }
        try {
            return this.isReferenced(jndiName) ? jdbcRes : null;
        }
        catch (ConfigException ce) {
            return null;
        }
    }

    public Map<ConnectorConnectionPool, MonitorableResourcePool> getPoolMap() {
        ConnectorConnectionPool[] cp = this.getConnectorConnectionPools();
        if (cp == null) {
            return null;
        }
        HashMap<ConnectorConnectionPool, MonitorableResourcePool> poolMap = new HashMap<ConnectorConnectionPool, MonitorableResourcePool>();
        ConcurrentHashMap allPools = Switch.getSwitch().getPoolManager().getPoolTable();
        for (int i = 0; i < cp.length; ++i) {
            ResourcePool p;
            if (cp[i].getName().equalsIgnoreCase("jmsra") || (p = (ResourcePool)allPools.get(cp[i].getName())) == null || !(p instanceof MonitorableResourcePool)) continue;
            poolMap.put(cp[i], (MonitorableResourcePool)p);
        }
        return poolMap;
    }

    public String getRAName(ConnectorConnectionPool ccp) {
        if (ccp == null) {
            return null;
        }
        String resourceAdapterName = ccp.getResourceAdapterName();
        int delimIdx = resourceAdapterName.indexOf("#");
        if (delimIdx == -1) {
            return resourceAdapterName;
        }
        return resourceAdapterName.substring(delimIdx + 1);
    }

    public String getAppName(ConnectorConnectionPool ccp) {
        if (ccp == null) {
            return null;
        }
        String resourceAdapterName = ccp.getResourceAdapterName();
        int delimIdx = resourceAdapterName.indexOf("#");
        if (delimIdx == -1) {
            return null;
        }
        return resourceAdapterName.substring(0, delimIdx);
    }

    public void loadSystemRAResources() {
        String message;
        InitialContext ctx;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ex) {
            String message2 = localStrings.getString("error.getting.intial.context");
            _logger.log(Level.SEVERE, message2);
            _logger.log(Level.FINE, ex.getMessage(), ex);
            return;
        }
        try {
            ConnectorResource[] cr = this.getAllJmsResources();
            for (int i = 0; i < cr.length; ++i) {
                try {
                    ctx.lookup(cr[i].getJndiName());
                    continue;
                }
                catch (NamingException ex) {
                    message = localStrings.getString("error.looking.up.resource", cr[i].getJndiName());
                    _logger.log(Level.SEVERE, message);
                    _logger.log(Level.FINE, ex.getMessage(), ex);
                }
            }
        }
        catch (ConfigException ex) {
            String message3 = localStrings.getString("error.getting.jms.resources");
            _logger.log(Level.SEVERE, message3);
        }
        try {
            AdminObjectResource[] aor = this.getAllJmsAdminObjects();
            for (int i = 0; i < aor.length; ++i) {
                try {
                    ctx.lookup(aor[i].getJndiName());
                    continue;
                }
                catch (NamingException ex) {
                    message = localStrings.getString("error.looking.up.resource", aor[i].getJndiName());
                    _logger.log(Level.SEVERE, message);
                    _logger.log(Level.FINE, ex.getMessage(), ex);
                }
            }
        }
        catch (ConfigException ex) {
            String message4 = localStrings.getString("error.getting.jms.admin.objects");
            _logger.log(Level.SEVERE, message4);
            _logger.log(Level.FINE, ex.getMessage(), ex);
        }
        try {
            JdbcResource[] jdbc = (JdbcResource[])this.getJdbcResourcesAsMap().get(RESOURCES);
            for (int i = 0; i < jdbc.length; ++i) {
                try {
                    ctx.lookup(jdbc[i].getJndiName());
                    continue;
                }
                catch (NamingException ex) {
                    message = localStrings.getString("error.looking.up.resource", jdbc[i].getJndiName());
                    _logger.log(Level.SEVERE, message);
                    _logger.log(Level.FINE, ex.getMessage(), ex);
                }
            }
        }
        catch (ConfigException ex) {
            String message5 = localStrings.getString("error.getting.jdbc.resources");
            _logger.log(Level.SEVERE, message5);
            _logger.log(Level.FINE, ex.getMessage(), ex);
        }
    }

    private boolean isADeployEvent() {
        return localResourcesUtil.get() != null;
    }
}

