/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractAttributeHandler;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.Set;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionAttributeHandler
extends AbstractAttributeHandler
implements PostProcessor {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return TransactionAttribute.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        TransactionAttribute taAn = (TransactionAttribute)ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            ContainerTransaction containerTransaction = this.getContainerTransaction(taAn.value());
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            Set txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
            for (Object next : txBusMethods) {
                MethodDescriptor nextDesc = (MethodDescriptor)next;
                Method m = nextDesc.getMethod(ejbDesc);
                if (!TypeUtil.sameMethodSignature(m, annMethod) || ejbDesc.getContainerTransactionFor(nextDesc) != null) continue;
                ejbDesc.setContainerTransactionFor(nextDesc, containerTransaction);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private ContainerTransaction getContainerTransaction(TransactionAttributeType taType) {
        switch (taType) {
            case MANDATORY: {
                return new ContainerTransaction("Mandatory", "Mandatory");
            }
            case REQUIRED: {
                return new ContainerTransaction("Required", "Required");
            }
            case REQUIRES_NEW: {
                return new ContainerTransaction("RequiresNew", "RequiresNew");
            }
            case SUPPORTS: {
                return new ContainerTransaction("Supports", "Supports");
            }
            case NOT_SUPPORTED: {
                return new ContainerTransaction("NotSupported", "NotSupported");
            }
        }
        return new ContainerTransaction("Never", "Never");
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{MessageDriven.class, Stateful.class, Stateless.class, Timeout.class, TransactionManagement.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, AnnotatedElementHandler aeHandler) throws AnnotationProcessorException {
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        TransactionAttribute taAn = (TransactionAttribute)ainfo.getAnnotation();
        ContainerTransaction containerTransaction = this.getContainerTransaction(taAn.value());
        Class classAn = (Class)ainfo.getAnnotatedElement();
        Set txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
        for (Object mdObj : txBusMethods) {
            MethodDescriptor md = (MethodDescriptor)mdObj;
            if (!classAn.equals(ejbContext.getDeclaringClass(md)) || ejbDesc.getContainerTransactionFor(md) != null) continue;
            ejbDesc.setContainerTransactionFor(md, containerTransaction);
        }
    }
}

