/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.ModuleDeployer;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.List;

public class ConnectorModuleDeployer
extends ModuleDeployer {
    private ConnectorModulesManager connModulesMgr = null;
    private static StringManager localStrings = StringManager.getManager(ConnectorModuleDeployer.class);

    ConnectorModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) throws IASDeploymentException, ConfigException {
        this.connModulesMgr = new ConnectorModulesManager(ienv);
        return this.connModulesMgr;
    }

    protected List getModuleClasspath(Archivist archivist, AbstractArchive archive) throws IASDeploymentException {
        return new ArrayList();
    }

    protected void preDeploy() throws IASDeploymentException {
        assert (this.moduleDir != null);
        assert (StringUtils.ok(this.moduleName));
        try {
            if (this.request.isArchive()) {
                J2EEModuleExploder.explode(this.request.getFileSource().getFile(), this.moduleDir, this.moduleName);
            }
            this.xmlDir.mkdirs();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e.toString(), e);
        }
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        this.runVerifier();
        try {
            String appDir = this.request.getDeployedDirectory().getCanonicalPath();
            String generatedXMLDir = this.request.getGeneratedXMLDirectory().getCanonicalPath();
            FileArchive srcArchive = new FileArchive();
            srcArchive.open(appDir);
            FileArchive destArchive = new FileArchive();
            destArchive.open(generatedXMLDir);
            Archivist.copyExtraElements(srcArchive, destArchive);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e.getCause());
        }
    }
}

