/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.EjbVisitor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;

public class ApplicationValidator
extends EjbBundleValidator
implements ApplicationVisitor,
EjbBundleVisitor,
EjbVisitor {
    private Application application;

    public void accept(Application application) {
        this.application = application;
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
        super.accept(bundleDescriptor);
        String rlm = this.application.getRealm();
        for (EjbDescriptor ejb : bundleDescriptor.getEjbs()) {
            for (EjbIORConfigurationDescriptor desc : ejb.getIORConfigurationDescriptors()) {
                desc.setRealmName(rlm);
            }
        }
    }

    public void accept(WebBundleDescriptor descriptor) {
        this.bundleDescriptor = descriptor;
        ModuleDescriptor md = this.bundleDescriptor.getModuleDescriptor();
        String uri = md.getArchiveUri();
        if (md.getContextRoot() == null && uri != null && uri.length() != 0) {
            int beginIndex = uri.lastIndexOf("/");
            if (beginIndex < 0) {
                beginIndex = uri.lastIndexOf(File.separator);
            }
            beginIndex = beginIndex < 0 ? 0 : ++beginIndex;
            int endIndex = uri.lastIndexOf(".war");
            if (endIndex == -1) {
                return;
            }
            String warFileName = uri.substring(beginIndex, endIndex);
            md.setContextRoot(warFileName);
            if (DOLUtils.getDefaultLogger().isLoggable(Level.INFO)) {
                DOLUtils.getDefaultLogger().info("Context Root is not provided by the user, Using [" + warFileName + "] as Context Root");
            }
        }
    }

    public void accept(ApplicationClientDescriptor appclientdescriptor) {
        this.bundleDescriptor = appclientdescriptor;
        for (LifecycleCallbackDescriptor next : appclientdescriptor.getPreDestroyDescriptors()) {
            next.setDefaultLifecycleCallbackClass(appclientdescriptor.getMainClassName());
        }
        for (LifecycleCallbackDescriptor next : appclientdescriptor.getPostConstructDescriptors()) {
            next.setDefaultLifecycleCallbackClass(appclientdescriptor.getMainClassName());
        }
    }

    public void accept(WebComponentDescriptor descriptor) {
        this.computeRuntimeDefault(descriptor);
    }

    private void computeRuntimeDefault(WebComponentDescriptor webComp) {
        if (!webComp.getUsesCallerIdentity()) {
            this.computeRunAsPrincipalDefault(webComp.getRunAsIdentity(), webComp.getApplication());
        }
    }

    protected Collection getEjbDescriptors() {
        if (this.application != null) {
            return this.application.getEjbDescriptors();
        }
        return new HashSet();
    }

    protected Application getApplication() {
        return this.application;
    }

    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }
}

