/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ExecutionContext;
import com.sun.enterprise.diagnostics.InvalidTargetException;
import com.sun.enterprise.diagnostics.ReportTarget;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.ServiceConfigFactory;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TargetResolver {
    protected String target;
    protected String repositoryName;
    protected String repositoryDir;
    protected boolean local;
    protected TargetType type;
    protected List<String> instances = new ArrayList<String>(1);
    protected ReportTarget reportTarget;
    protected List<ServiceConfig> serviceConfigs = new ArrayList<ServiceConfig>(1);
    protected ExecutionContext context;
    protected static final String DEFAULT_FEATURES_PROPERTY_CLASS = "com.sun.enterprise.admin.pluggable.PEClientPluggableFeatureImpl";
    protected Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public TargetResolver(String target, String repositoryDir, boolean local) {
        this.target = target;
        this.repositoryDir = repositoryDir;
        this.local = local;
    }

    public ReportTarget resolve() throws DiagnosticException {
        if (this.validateTarget()) {
            this.createTarget();
            return this.reportTarget;
        }
        throw new InvalidTargetException(" Unable to resolve target : " + this.target);
    }

    public abstract boolean validateTarget() throws DiagnosticException;

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public List<ServiceConfig> getServiceConfigs() {
        return this.serviceConfigs;
    }

    protected void createTarget() throws DiagnosticException {
        this.setExecutionContext();
        this.initLogger();
        this.determineTargetDetails();
        this.createTargetObject();
    }

    protected abstract void setExecutionContext();

    protected void determineTargetDetails() {
        this.determineTargetType();
        this.determineRepositoryDetails();
        this.determineInstances();
        this.determineServiceConfigs();
        this.logger.log(Level.FINE, "diagnostic-service.target_details", new Object[]{this.target, this.repositoryDir, this.type, this.instances});
    }

    protected abstract void determineRepositoryDetails();

    protected abstract void determineTargetType();

    protected abstract void determineInstances();

    protected void setTargetType(TargetType type) {
        this.type = type;
    }

    protected void addInstance(String instanceName) {
        this.instances.add(instanceName);
    }

    protected void determineServiceConfigs() {
        if (this.instances != null) {
            Iterator<String> iterator = this.instances.iterator();
            while (iterator.hasNext()) {
                this.addServiceConfig(iterator.next());
            }
        }
    }

    protected void addServiceConfig(String instanceName) {
        ServiceConfig instanceConfig;
        String instanceRepDir = this.repositoryDir + File.separator + this.repositoryName;
        if (!instanceName.equals("server") && !this.type.equals(TargetType.INSTANCE)) {
            instanceRepDir = instanceRepDir + File.separator + instanceName;
        }
        if ((instanceConfig = ServiceConfigFactory.getInstance().getServiceConfig(this.context.isLocal(), instanceRepDir, instanceName)) != null) {
            this.serviceConfigs.add(instanceConfig);
        }
    }

    protected void createTargetObject() {
        this.reportTarget = new ReportTarget(this.repositoryDir, this.repositoryName, this.target, this.type, this.instances, this.local);
    }

    private void initLogger() {
        this.logger = this.context.getLogger();
    }

    private Logger getLogger() {
        return this.logger;
    }
}

