/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.LinuxSystemInfoCollector;
import com.sun.enterprise.diagnostics.collect.SolarisSystemInfoCollector;
import com.sun.enterprise.diagnostics.collect.WindowsSystemInfoCollector;

public class SystemInfoCollector
implements Collector {
    private String destFolder = null;

    public SystemInfoCollector(String destFolder) {
        this.destFolder = destFolder;
    }

    public Data capture() throws DiagnosticException {
        Data systemInfo = null;
        Collector systemInfoCollector = null;
        String osName = System.getProperty("os.name");
        if ((osName = osName.toUpperCase()).indexOf("WIN") >= 0) {
            systemInfoCollector = new WindowsSystemInfoCollector(this.destFolder);
        } else if (osName.indexOf("SUNOS") >= 0) {
            systemInfoCollector = new SolarisSystemInfoCollector(this.destFolder);
        } else if (osName.indexOf("LINUX") >= 0) {
            systemInfoCollector = new LinuxSystemInfoCollector(this.destFolder);
        }
        if (systemInfoCollector != null) {
            systemInfo = systemInfoCollector.capture();
        }
        return systemInfo;
    }
}

