/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.extension.CopyObjectPolicy;
import com.sun.corba.ee.spi.extension.RequestPartitioningPolicy;
import com.sun.corba.ee.spi.extension.ServantCachingPolicy;
import com.sun.corba.ee.spi.extension.ZeroPortPolicy;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactory;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.ejb.Container;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.enterprise.RemoteReferenceFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.CSIv2Policy;
import com.sun.enterprise.iiop.OTSPolicy;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.iiop.SFSBVersionPolicy;
import com.sun.enterprise.util.S1ASThreadPoolManager;
import com.sun.enterprise.util.Utility;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.NoSuchObjectLocalException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.Delegate;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;

public final class POARemoteReferenceFactory
extends LocalObject
implements RemoteReferenceFactory,
ServantLocator {
    static final int PASS_BY_VALUE_ID = 0;
    static final int PASS_BY_REFERENCE_ID = 1;
    static final int OTS_POLICY_TYPE = 1398079611;
    static final int CSIv2_POLICY_TYPE = 1398079612;
    static final int REQUEST_DISPATCH_POLICY_TYPE = 1398079613;
    static final int SFSB_VERSION_POLICY_TYPE = 1398079614;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.corba");
    private static final int GET_TIE_EXCEPTION_CODE = 9999;
    private Container container;
    private EjbDescriptor ejbDescriptor;
    private org.omg.CORBA.ORB orb;
    private POAProtocolMgr protocolMgr;
    private PresentationManager presentationMgr;
    private ReferenceFactory ejbHomeReferenceFactory;
    private PresentationManager.StubFactory ejbHomeStubFactory;
    private String ejbHomeRepositoryId;
    private ReferenceFactory ejbObjectReferenceFactory;
    private PresentationManager.StubFactory ejbObjectStubFactory;
    private String ejbObjectRepositoryId;
    private String remoteBusinessIntf;
    private boolean isRemoteHomeView;
    private String poaId_EJBHome;
    private String poaId_EJBObject;
    static final int EJBID_OFFSET = 0;
    private static final int INSTANCEKEYLEN_OFFSET = 8;
    private static final int INSTANCEKEY_OFFSET = 12;

    POARemoteReferenceFactory(Container container, POAProtocolMgr protocolMgr, org.omg.CORBA.ORB orb, boolean remoteHomeView, String id) {
        this.protocolMgr = protocolMgr;
        this.orb = orb;
        this.poaId_EJBHome = id + "-EJBHome";
        this.poaId_EJBObject = id + "-EJBObject";
        ORB cfr_ignored_0 = (ORB)((java.lang.Object)orb);
        this.presentationMgr = ORB.getPresentationManager();
        this.container = container;
        this.ejbDescriptor = container.getEjbDescriptor();
        this.isRemoteHomeView = remoteHomeView;
        ClassLoader loader = container.getClassLoader();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "POARemoteReferenceFactory: " + this.poaId_EJBHome + " " + this.poaId_EJBObject + " " + this.ejbDescriptor);
        }
    }

    private String getRepositoryId(Class c) throws Exception {
        PresentationManager.ClassData cData = this.presentationMgr.getClassData(c);
        String[] typeIds = cData.getTypeIds();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, ".getRepositoryId: " + typeIds[0]);
        }
        return typeIds[0];
    }

    public void setRepositoryIds(Class homeIntf, Class remoteIntf) {
        ClassLoader appClassLoader = this.container.getClassLoader();
        ORB cfr_ignored_0 = (ORB)((java.lang.Object)this.orb);
        PresentationManager.StubFactoryFactory sff = ORB.getStubFactoryFactory();
        this.ejbHomeStubFactory = sff.createStubFactory(homeIntf.getName(), false, "", null, appClassLoader);
        String[] ejbHomeTypeIds = this.ejbHomeStubFactory.getTypeIds();
        this.ejbHomeRepositoryId = ejbHomeTypeIds[0];
        this.ejbObjectStubFactory = sff.createStubFactory(remoteIntf.getName(), false, "", null, appClassLoader);
        String[] ejbObjectTypeIds = this.ejbObjectStubFactory.getTypeIds();
        this.ejbObjectRepositoryId = ejbObjectTypeIds[0];
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, ".setRepositoryIds: " + this.ejbHomeRepositoryId + " " + this.ejbObjectRepositoryId);
        }
        try {
            this.ejbHomeReferenceFactory = this.createReferenceFactory(this.poaId_EJBHome, this.ejbHomeRepositoryId);
            this.ejbObjectReferenceFactory = this.createReferenceFactory(this.poaId_EJBObject, this.ejbObjectRepositoryId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!this.isRemoteHomeView) {
            this.remoteBusinessIntf = remoteIntf.getName();
        }
    }

    public void cleanupClass(Class clazz) {
        try {
            this.presentationMgr.flushClass(clazz);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "cleanupClass error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceFactory createReferenceFactory(String poaId, String repoid) throws Exception {
        try {
            ReferenceFactory rf;
            Set iorDescSet;
            CSIV2TaggedComponentInfo ctc;
            StatefulSessionContainer sfsbCon;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, ".createReferenceFactory->: " + poaId + " " + repoid);
            }
            ReferenceFactoryManager rfm = (ReferenceFactoryManager)this.orb.resolve_initial_references("ReferenceFactoryManager");
            ArrayList<Policy> policies = new ArrayList<Policy>();
            policies.add(ServantCachingPolicy.getPolicy());
            policies.add(new OTSPolicy());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, ".createReferenceFactory: " + poaId + " " + repoid + ": " + this.ejbDescriptor);
            }
            policies.add(new CSIv2Policy(this.ejbDescriptor));
            IASEjbExtraDescriptors extraDesc = this.ejbDescriptor.getIASEjbExtraDescriptors();
            String threadPoolName = extraDesc.getUseThreadPoolId();
            int threadPoolNumericID = 0;
            boolean usePassByReference = extraDesc.getPassByReference();
            if (usePassByReference) {
                policies.add(new CopyObjectPolicy(1));
            }
            if (threadPoolName != null) {
                ThreadPoolManager threadPoolManager = S1ASThreadPoolManager.getThreadPoolManager();
                try {
                    threadPoolNumericID = threadPoolManager.getThreadPoolNumericId(threadPoolName);
                    policies.add(new RequestPartitioningPolicy(threadPoolNumericID));
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Not using threadpool-request-partitioning...", ex);
                }
            }
            logger.log(Level.INFO, "POARemoteRefFactory checking if SFSBVersionPolicy need to be added");
            EJBServerConfigLookup ejbConfigLookup = new EJBServerConfigLookup(this.ejbDescriptor);
            boolean addSFSBVersionPolicy = EJBServerConfigLookup.needToAddSFSBVersionInterceptors();
            logger.log(Level.INFO, "POARemoteRefFactory addSFSBVersionPolicy? " + addSFSBVersionPolicy);
            if (addSFSBVersionPolicy && this.container instanceof StatefulSessionContainer && (sfsbCon = (StatefulSessionContainer)this.container).isHAEnabled()) {
                policies.add(new SFSBVersionPolicy(this.ejbDescriptor.getUniqueId()));
            }
            if (logger.isLoggable(Level.FINE)) {
                String jndiName = this.ejbDescriptor.getJndiName();
                logger.log(Level.FINE, "Using Thread-Pool: [" + threadPoolName + " ==> " + threadPoolNumericID + "] for jndi name: " + jndiName);
                logger.log(Level.FINE, "Pass by reference: [" + usePassByReference + "] for jndi name: " + usePassByReference);
            }
            if ((ctc = new CSIV2TaggedComponentInfo(this.orb)).allMechanismsRequireSSL(iorDescSet = this.ejbDescriptor.getIORConfigurationDescriptors())) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, ".createReferenceFactory: " + poaId + " " + repoid + ": adding ZeroPortPolicy");
                }
                policies.add(ZeroPortPolicy.getPolicy());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, ".createReferenceFactory: " + poaId + " " + repoid + ": policies: " + policies);
            }
            ReferenceFactory referenceFactory = rf = rfm.create(poaId, repoid, policies, this);
            return referenceFactory;
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, ".createReferenceFactory<-: " + poaId + " " + repoid);
            }
        }
    }

    public Remote createRemoteReference(byte[] instanceKey) {
        return this.createRef(instanceKey, this.ejbObjectReferenceFactory, this.ejbObjectStubFactory, this.ejbObjectRepositoryId);
    }

    public EJBHome createHomeReference(byte[] homeKey) {
        return (EJBHome)this.createRef(homeKey, this.ejbHomeReferenceFactory, this.ejbHomeStubFactory, this.ejbHomeRepositoryId);
    }

    private Remote createRef(byte[] instanceKey, ReferenceFactory rf, PresentationManager.StubFactory stubFactory, String repoid) {
        try {
            PresentationManager.StubFactory stubFact = stubFactory;
            Object ref = this._createRef(rf, instanceKey, repoid);
            Object stub = stubFact.makeStub();
            Delegate delegate = StubAdapter.getDelegate(ref);
            StubAdapter.setDelegate(stub, delegate);
            return (Remote)stub;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.createreference_exception", e.toString());
            throw new RuntimeException("Unable to create reference ", e);
        }
    }

    private Object _createRef(ReferenceFactory rf, byte[] instanceKey, String repoid) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.info("\t\tIn POARemoteReferenceFactory._createRef, repositoryId = " + repoid);
        }
        byte[] ejbKey = this.createEJBKey(this.ejbDescriptor.getUniqueId(), instanceKey);
        Object obj = rf.createReference(ejbKey);
        return obj;
    }

    private byte[] createEJBKey(long ejbId, byte[] instanceKey) {
        byte[] ejbkey = new byte[12 + instanceKey.length];
        Utility.longToBytes(ejbId, ejbkey, 0);
        Utility.intToBytes(instanceKey.length, ejbkey, 8);
        System.arraycopy(instanceKey, 0, ejbkey, 12, instanceKey.length);
        return ejbkey;
    }

    public void destroyReference(Remote remoteRef, Remote remoteObj) {
        try {
            Util.unexportObject(remoteObj);
        }
        catch (RuntimeException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Servant preinvoke(byte[] ejbKey, POA adapter, String operation, CookieHolder cookieHolder) throws ForwardRequest {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "In preinvoke for operation:" + operation);
        }
        int keyLen = Utility.bytesToInt(ejbKey, 8);
        byte[] instanceKey = new byte[keyLen];
        System.arraycopy(ejbKey, 12, instanceKey, 0, keyLen);
        Servant servant = null;
        try {
            while (servant == null) {
                Remote targetObj = this.container.getTargetObject(instanceKey, this.isRemoteHomeView ? null : this.remoteBusinessIntf);
                if (targetObj == null) continue;
                Tie tie = (Tie)AccessController.doPrivileged(new PrivilegedAction(){

                    public Tie run() {
                        return POARemoteReferenceFactory.this.presentationMgr.getTie();
                    }
                });
                tie.setTarget(targetObj);
                servant = (Servant)tie;
            }
        }
        catch (NoSuchObjectLocalException e) {
            logger.log(Level.SEVERE, "iiop.gettie_exception", e);
            throw new OBJECT_NOT_EXIST(9999, CompletionStatus.COMPLETED_NO);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "iiop.runtime_exception", e);
            throw e;
        }
        return servant;
    }

    public void postinvoke(byte[] ejbKey, POA adapter, String operation, java.lang.Object cookie, Servant servant) {
        Remote target = null;
        if (servant != null) {
            target = ((Tie)servant).getTarget();
        }
        this.container.releaseTargetObject(target);
    }

    public void destroy() {
        try {
            this.ejbHomeReferenceFactory.destroy();
            this.ejbObjectReferenceFactory.destroy();
            this.ejbHomeReferenceFactory = null;
            this.ejbObjectReferenceFactory = null;
            this.container = null;
            this.ejbDescriptor = null;
            this.orb = null;
            this.protocolMgr = null;
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "Exception during POARemoteRefFactory::destroy()", th);
        }
    }

    public boolean hasSameContainerID(Object obj) throws Exception {
        boolean result = false;
        try {
            IOR ior = ((ORB)((java.lang.Object)this.orb)).getIOR(obj, false);
            Iterator iter = ior.iterator();
            byte[] oid = null;
            if (iter.hasNext()) {
                TaggedProfile profile = (TaggedProfile)iter.next();
                ObjectKey objKey = profile.getObjectKey();
                oid = objKey.getId().getId();
            }
            if (oid != null && oid.length > 12) {
                long cid = Utility.bytesToLong(oid, 0);
                int keyLen = Utility.bytesToInt(oid, 8);
                if (oid.length == keyLen + 12) {
                    boolean bl = result = cid == this.ejbDescriptor.getUniqueId();
                }
                if (logger.isLoggable(Level.FINE)) {
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append("hasSameContainerID() result: ").append(result).append("; because ==> oid.length: ").append(oid.length).append("; instance-key-length: ").append(keyLen).append("; expected oid.length: ").append(keyLen).append("+").append(12).append("; myContainrID: ").append(this.ejbDescriptor.getUniqueId()).append("; obj.containerID: ").append(cid);
                    logger.log(Level.FINE, sbuf.toString());
                }
            } else if (logger.isLoggable(Level.FINE)) {
                if (oid == null) {
                    logger.log(Level.FINE, "hasSameContainerID() failed because oid=null");
                } else {
                    logger.log(Level.FINE, "hasSameContainerID() failed because oid.length= " + oid.length + "; but INSTANCE_KEY_OFFSET= " + 12);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Exception while checking for same containerID", ex);
            throw ex;
        }
        return result;
    }
}

