/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.appserv.server.util.ASURLClassLoader;
import com.sun.appserv.server.util.ClassLoaderChain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.server.PELaunch;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class EJBClassPathUtils {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private static Map<URI, ClassLoader> classLoaderRegistry = new HashMap<URI, ClassLoader>();
    private static final String MANIFEST_ENTRY = "META-INF" + File.separator + "MANIFEST.MF";
    private static final String WAR_CLASSES_DIR = "WEB-INF" + File.separator + "classes";
    private static final String WAR_LIB_DIR = "WEB-INF" + File.separator + "lib";

    public static List getAppClasspath(Application application, BaseManager apps) {
        String appName = application.getRegistrationName();
        try {
            String appRoot = apps.getLocation(appName);
            return EJBClassPathUtils.getAppClassPath(application, appRoot, apps);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ejb.classpath", e);
            return new ArrayList();
        }
    }

    public static List getAppClassPath(Application application, String appRoot, BaseManager apps) {
        ArrayList<String> classpath = new ArrayList<String>();
        String appName = application.getRegistrationName();
        try {
            List appPath = EJBClassPathUtils.getApplicationClassPath(application, appRoot);
            if (appPath.size() > 0) {
                classpath.addAll(appPath);
            }
            classpath.add(apps.getStubLocation(appName));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ejb.classpath", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBClassPathUtils] EJB Class Path for [" + appName + "] is ...\n" + ((Object)classpath).toString());
        }
        return classpath;
    }

    public static List getModuleClasspath(String moduleName, String moduleRoot, BaseManager mgr) {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            if (moduleRoot == null) {
                moduleRoot = mgr.getLocation(moduleName);
            }
            classpath.add(moduleRoot);
            classpath.add(mgr.getStubLocation(moduleName));
            classpath.addAll(EJBClassPathUtils.getModuleClassPath(mgr.getModuleType(), moduleRoot, moduleRoot));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ejb.classpath", e);
        }
        return classpath;
    }

    public static List getModuleClassPath(ModuleType type, String moduleRoot, String appRoot) throws IOException {
        ArrayList<String> classpath = new ArrayList<String>();
        Manifest mf = EJBClassPathUtils.getManifest(moduleRoot);
        List manifestClassPath = EJBClassPathUtils.getManifestClassPath(mf, appRoot);
        classpath.addAll(manifestClassPath);
        if (ModuleType.WAR.equals(type)) {
            String classesDir = moduleRoot + File.separator + WAR_CLASSES_DIR;
            String libDir = moduleRoot + File.separator + WAR_LIB_DIR;
            List warClassPath = ClassLoaderUtils.getUrlList(new File[]{new File(classesDir)}, new File[]{new File(libDir)});
            classpath.addAll(warClassPath);
        } else {
            classpath.add(moduleRoot);
            List moduleClassPath = ClassLoaderUtils.getUrlList(null, new File[]{new File(moduleRoot)});
            classpath.addAll(moduleClassPath);
        }
        return classpath;
    }

    public static List getApplicationClassPath(Application app, String appRoot) throws IOException {
        ArrayList classpath = new ArrayList();
        if (!app.isVirtual()) {
            List rootLibraries;
            String libPath;
            List dirLibraries;
            if (app.getLibraryDirectory() != null && (dirLibraries = ClassLoaderUtils.getUrlList(null, new File[]{new File(appRoot, libPath = app.getLibraryDirectory().replace('/', File.separatorChar))}, true)) != null && !dirLibraries.isEmpty()) {
                classpath.addAll(dirLibraries);
            }
            if ((rootLibraries = ClassLoaderUtils.getUrlList(null, new File[]{new File(appRoot)})) != null && !rootLibraries.isEmpty()) {
                classpath.addAll(rootLibraries);
            }
        }
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)modules.next();
            String moduleUri = md.getArchiveUri();
            String moduleRoot = app.isVirtual() ? appRoot : DeploymentUtils.getEmbeddedModulePath(appRoot, moduleUri);
            classpath.addAll(EJBClassPathUtils.getModuleClassPath(md.getModuleType(), moduleRoot, appRoot));
        }
        return classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(String rootPath) {
        InputStream in = null;
        Manifest mf = null;
        try {
            in = new FileInputStream(rootPath + File.separator + MANIFEST_ENTRY);
            if (in != null) {
                mf = new Manifest(in);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return mf;
    }

    private static List getManifestClassPath(Manifest manifest, String rootPath) {
        ArrayList<String> classPaths = new ArrayList<String>();
        if (manifest != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            for (Attributes.Name name : mainAttributes.keySet()) {
                if (!name.equals(Attributes.Name.CLASS_PATH)) continue;
                String classpathString = (String)mainAttributes.get(name);
                StringTokenizer st = new StringTokenizer(classpathString, " ");
                while (st.hasMoreTokens()) {
                    String mc = st.nextToken();
                    classPaths.add(rootPath + File.separator + mc);
                }
            }
        }
        return classPaths;
    }

    public static EJBClassLoader createEJBClassLoader(String[] classPaths, String moduleRoot, String id, ClassLoader parentClassLoader, ModuleType moduleType) {
        URL[] classPathURLs = new URL[]{};
        if (classPaths != null) {
            int classPathSize = classPaths.length;
            classPathURLs = new URL[classPathSize];
            for (int i = 0; i < classPathSize; ++i) {
                try {
                    classPathURLs[i] = new File(classPaths[i]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException malEx) {
                    _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", classPaths[i]);
                    _logger.log(Level.WARNING, "loader.exception", malEx);
                }
            }
        }
        String libs = null;
        if (moduleType.equals(ModuleType.EAR)) {
            libs = ASClassLoaderUtil.getLibrariesForJ2EEApplication(id);
        } else if (moduleType.equals(ModuleType.EJB)) {
            libs = ASClassLoaderUtil.getLibrariesForEJBJars(id);
        }
        URL[] deployTimeLibraries = ASClassLoaderUtil.getLibraries(libs);
        URL[] resolvedLibrariesList = null;
        if (deployTimeLibraries != null && deployTimeLibraries.length > 0) {
            resolvedLibrariesList = EJBClassPathUtils.resolveVersionConflicts(EJBClassPathUtils.getManifest(moduleRoot), deployTimeLibraries, classPaths);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "createEJBClassLoader :: Resolved libraries " + resolvedLibrariesList);
        }
        ClassLoader applicationLibrariesCL = EJBClassPathUtils.createApplicationLibrariesClassLoader(parentClassLoader, resolvedLibrariesList, id);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "- applibsCL: " + applicationLibrariesCL);
        }
        return EJBClassPathUtils.createEJBClassLoader(parentClassLoader, applicationLibrariesCL, classPathURLs);
    }

    private static URL[] resolveVersionConflicts(Manifest mf, URL[] deployTimeLibraries, String[] applicationClasspath) {
        try {
            String appList = mf.getMainAttributes().getValue(Attributes.Name.EXTENSION_LIST);
            if (appList == null) {
                return deployTimeLibraries;
            }
            String[] appExtensions = appList.split(" ");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Application Extension List" + appExtensions);
            }
            ArrayList<URL> conflictingLibraries = new ArrayList<URL>();
            for (int i = 0; i < appExtensions.length; ++i) {
                URL url;
                String extensionImplVersion;
                String extensionSpecVersion;
                String extensionName = mf.getMainAttributes().getValue(appExtensions[i] + "-Extension-Name");
                if (!EJBClassPathUtils.bundledExtensionMatches(applicationClasspath, extensionName, extensionSpecVersion = mf.getMainAttributes().getValue(appExtensions[i] + "-Extension-Specification-Version"), extensionImplVersion = mf.getMainAttributes().getValue(appExtensions[i] + "-Extension-Implementation-Version")) || (url = EJBClassPathUtils.isExtensionInLibraries(extensionName, deployTimeLibraries)) == null) continue;
                conflictingLibraries.add(url);
            }
            ArrayList<URL> resolvedList = new ArrayList<URL>();
            for (int i = 0; i < deployTimeLibraries.length; ++i) {
                if (!conflictingLibraries.contains(deployTimeLibraries[i])) {
                    resolvedList.add(deployTimeLibraries[i]);
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, " conflict  " + deployTimeLibraries[i] + "being ignored");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, " Final resolved list after conflictchecking " + resolvedList);
            }
            return resolvedList.toArray(new URL[0]);
        }
        catch (IOException ioe) {
            _logger.log(Level.WARNING, ioe.getMessage());
            _logger.log(Level.FINE, "Exception while checking for version conflict in bundled vs provided libraries", ioe);
            return deployTimeLibraries;
        }
    }

    private static URL isExtensionInLibraries(String extensionName, URL[] deployTimeLibrariesList) throws IOException {
        for (int i = 0; i < deployTimeLibrariesList.length; ++i) {
            JarFile jf = new JarFile(deployTimeLibrariesList[i].getFile());
            String extnName = jf.getManifest().getMainAttributes().getValue(Attributes.Name.EXTENSION_NAME);
            if (!extnName.equals(extensionName)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "extensionName" + extensionName + "matched by " + deployTimeLibrariesList[i] + " = CONFLICT");
            }
            return deployTimeLibrariesList[i];
        }
        return null;
    }

    private static boolean bundledExtensionMatches(String[] applicationClasspath, String extnName, String extnSpecVersion, String extnImplVersion) throws IOException {
        for (int i = 0; i < applicationClasspath.length; ++i) {
            JarFile jf = new JarFile(applicationClasspath[i]);
            String bundledExtnName = jf.getManifest().getMainAttributes().getValue(Attributes.Name.EXTENSION_NAME);
            String bundledExtnImplVersion = jf.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            String bundledExtnSpecVersion = jf.getManifest().getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
            if (!extnName.equals(bundledExtnName) || extnSpecVersion == null || bundledExtnSpecVersion.compareTo(extnSpecVersion) < 0 || extnImplVersion == null || bundledExtnImplVersion.compareTo(extnImplVersion) < 0) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "extensionName" + bundledExtnName + "spec version: " + bundledExtnSpecVersion + "impl version: " + bundledExtnImplVersion + "matches within the application");
            }
            return true;
        }
        return false;
    }

    private static ClassLoader createApplicationLibrariesClassLoader(ClassLoader parentClassLoader, URL[] urlList, String moduleId) {
        if (urlList != null) {
            ClassLoaderChain appChain = new ClassLoaderChain(parentClassLoader);
            appChain.setName("Application library chain for " + moduleId);
            for (URL url : urlList) {
                try {
                    ClassLoader urlLoader = classLoaderRegistry.get(url.toURI());
                    if (urlLoader == null) {
                        urlLoader = new ASURLClassLoader(new URL[]{url}, parentClassLoader);
                        classLoaderRegistry.put(url.toURI(), urlLoader);
                    }
                    appChain.addToList(urlLoader);
                }
                catch (URISyntaxException e) {
                    _logger.log(Level.FINE, "Error while resolving " + url + " to URI");
                    _logger.log(Level.WARNING, e.getMessage());
                }
            }
            ClassLoader optionalChain = PELaunch.getOptionalChain();
            appChain.addToList(optionalChain);
            return appChain;
        }
        return null;
    }

    private static EJBClassLoader createEJBClassLoader(ClassLoader parentClassLoader, ClassLoader appLibLoader, URL[] URLs) {
        EJBClassLoader loader = null;
        loader = appLibLoader != null ? new EJBClassLoader(appLibLoader) : new EJBClassLoader(parentClassLoader);
        if (URLs != null) {
            for (int i = 0; i < URLs.length; ++i) {
                loader.appendURL(URLs[i]);
            }
        }
        return loader;
    }
}

