/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth;

import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.security.AppservAccessController;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.ServerLoginCallbackHandler;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.logging.LogDomains;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.x500.X500Principal;
import sun.security.x509.X500Name;

public class LoginContextDriver {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final ServerLoginCallbackHandler dummyCallback = new ServerLoginCallbackHandler();
    private static final String CLIENT_JAAS_PASSWORD = "default";
    private static final String CLIENT_JAAS_CERTIFICATE = "certificate";
    public static final String CERT_REALMNAME = "certificate";
    public static final AuditManager AUDIT_MANAGER = AuditManagerFactory.getAuditManagerInstance();

    private LoginContextDriver() {
    }

    public static void login(String username, String password, String realmName) {
        if (realmName == null || !Realm.isValidRealm(realmName)) {
            realmName = Realm.getDefaultRealm();
        }
        final Subject fs = new Subject();
        final PasswordCredential pc = new PasswordCredential(username, password, realmName);
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fs.getPrivateCredentials().add(pc);
                return fs;
            }
        });
        LoginContextDriver.login(fs, PasswordCredential.class);
    }

    public static void login(Subject subject, Class cls) throws LoginException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Processing login with credentials of type: " + cls.toString());
        }
        if (cls.equals(PasswordCredential.class)) {
            LoginContextDriver.doPasswordLogin(subject);
        } else if (cls.equals(X509CertificateCredential.class)) {
            LoginContextDriver.doCertificateLogin(subject);
        } else if (cls.equals(AnonCredential.class)) {
            LoginContextDriver.doAnonLogin();
        } else if (cls.equals(GSSUPName.class)) {
            LoginContextDriver.doGSSUPLogin(subject);
        } else if (cls.equals(X500Name.class)) {
            LoginContextDriver.doX500Login(subject);
        } else {
            _logger.log(Level.INFO, "java_security.unknown_credential", cls.toString());
            throw new LoginException("Unknown credential type, cannot login.");
        }
    }

    public static void loginPrincipal(String username, String realmName) throws LoginException {
        if (realmName == null || realmName.length() == 0) {
            realmName = Realm.getDefaultRealm();
        }
        final Subject s = new Subject();
        final PrincipalImpl p = new PrincipalImpl(username);
        final GSSUPName name = new GSSUPName(username, realmName);
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                s.getPrincipals().add(p);
                s.getPublicCredentials().add(name);
                return null;
            }
        });
        LoginContextDriver.setSecurityContext(username, s, realmName);
    }

    public static void logout() throws LoginException {
        LoginContextDriver.unsetSecurityContext();
    }

    private static void doPasswordLogin(Subject subject) throws LoginException {
        Subject s = subject;
        Object obj = LoginContextDriver.getPrivateCredentials(s, PasswordCredential.class);
        assert (obj != null);
        PasswordCredential p = (PasswordCredential)obj;
        String user = p.getUser();
        String pwd = p.getPassword();
        String realm = p.getRealm();
        String jaasCtx = null;
        try {
            jaasCtx = Realm.getInstance(realm).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
        assert (user != null);
        assert (pwd != null);
        assert (realm != null);
        assert (jaasCtx != null);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Logging in user [" + user + "] into realm: " + realm + " using JAAS module: " + jaasCtx);
        }
        try {
            LoginContext lg = new LoginContext(jaasCtx, s, dummyCallback);
            lg.login();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "java_security.audit_auth_refused", user);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "doPasswordLogin fails", e);
            }
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(user, realm, false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw (LoginException)new LoginException("Login failed: " + e.toString()).initCause(e);
        }
        if (AUDIT_MANAGER.isAuditOn()) {
            AUDIT_MANAGER.authentication(user, realm, true);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Password login succeeded for : " + user);
        }
        LoginContextDriver.setSecurityContext(user, s, realm);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Set security context as user: " + user);
        }
    }

    public static Subject jmacLogin(Subject subject, String username, String password, String realmName) throws LoginException {
        if (realmName == null || !Realm.isValidRealm(realmName)) {
            realmName = Realm.getDefaultRealm();
        }
        if (subject == null) {
            subject = new Subject();
        }
        final Subject fs = subject;
        final PasswordCredential pc = new PasswordCredential(username, password, realmName);
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fs.getPrivateCredentials().add(pc);
                return fs;
            }
        });
        String jaasCtx = null;
        try {
            jaasCtx = Realm.getInstance(realmName).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("jmac login user [" + username + "] into realm: " + realmName + " using JAAS module: " + jaasCtx);
        }
        try {
            LoginContext lg = new LoginContext(jaasCtx, fs, dummyCallback);
            lg.login();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "java_security.audit_auth_refused", username);
            }
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(username, realmName, false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw (LoginException)new LoginException("Login failed: " + e.toString()).initCause(e);
        }
        if (AUDIT_MANAGER.isAuditOn()) {
            AUDIT_MANAGER.authentication(username, realmName, true);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("jmac Password login succeeded for : " + username);
        }
        return subject;
    }

    public static Subject jmacLogin(Subject subject, X500Principal x500Principal) throws LoginException {
        if (subject == null) {
            subject = new Subject();
        }
        final Subject fs = subject;
        String userName = "";
        try {
            final X500Name x500Name = new X500Name(x500Principal.getName("RFC1779"));
            userName = x500Name.toString();
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    fs.getPublicCredentials().add(x500Name);
                    return fs;
                }
            });
            Realm realm = Realm.getInstance("certificate");
            CertificateRealm certRealm = (CertificateRealm)realm;
            certRealm.authenticate(fs, x500Name);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "java_security.audit_auth_refused", userName);
            }
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(userName, "certificate", false);
            }
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("jmac cert login succeeded for: " + userName);
        }
        if (AUDIT_MANAGER.isAuditOn()) {
            AUDIT_MANAGER.authentication(userName, "certificate", true);
        }
        return subject;
    }

    private static void doCertificateLogin(Subject s) throws LoginException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Processing X509 certificate login.");
        }
        String realm = "certificate";
        String user = null;
        try {
            Object obj = LoginContextDriver.getPublicCredentials(s, X509CertificateCredential.class);
            X509CertificateCredential xp = (X509CertificateCredential)obj;
            user = xp.getAlias();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Set security context as user: " + user);
            }
            LoginContextDriver.setSecurityContext(user, s, realm);
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(user, realm, true);
            }
        }
        catch (LoginException le) {
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(user, realm, false);
            }
            throw le;
        }
    }

    private static void doAnonLogin() throws LoginException {
        SecurityContext.setUnauthenticatedContext();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Set anonymous security context.");
        }
    }

    private static void doGSSUPLogin(Subject s) throws LoginException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Processing GSSUP login.");
        }
        String user = null;
        String realm = Realm.getDefaultRealm();
        try {
            Object obj = LoginContextDriver.getPublicCredentials(s, GSSUPName.class);
            user = ((GSSUPName)obj).getUser();
            LoginContextDriver.setSecurityContext(user, s, realm);
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(user, realm, true);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSUP login succeeded for : " + user);
            }
        }
        catch (LoginException le) {
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(user, realm, false);
            }
            throw le;
        }
    }

    private static void doX500Login(Subject s) throws LoginException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Processing X.500 name login.");
        }
        String user = null;
        String realm_name = null;
        try {
            X500Name x500name = (X500Name)LoginContextDriver.getPublicCredentials(s, X500Name.class);
            user = x500name.getName();
            Realm realm = Realm.getInstance("certificate");
            if (realm instanceof CertificateRealm) {
                CertificateRealm certRealm = (CertificateRealm)realm;
                certRealm.authenticate(s, x500name);
                realm_name = "certificate";
                if (AUDIT_MANAGER.isAuditOn()) {
                    AUDIT_MANAGER.authentication(user, realm_name, true);
                }
            } else {
                _logger.warning("certlogin.badrealm");
                LoginContextDriver.setSecurityContext(user, s, realm_name);
                realm_name = realm.getName();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("X.500 name login succeeded for : " + user);
            }
        }
        catch (LoginException le) {
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(user, realm_name, false);
            }
            throw le;
        }
        catch (Exception ex) {
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
    }

    private static Object getPublicCredentials(Subject s, Class cls) throws LoginException {
        Set credset = s.getPublicCredentials(cls);
        final Iterator iter = credset.iterator();
        if (!iter.hasNext()) {
            String credmsg = cls.toString();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Expected public credentials of type : " + credmsg + " but none found.");
            }
            throw new LoginException("Expected public credential of type: " + credmsg + " but none found.");
        }
        Object obj = null;
        try {
            obj = AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return iter.next();
                }
            });
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw (LoginException)new LoginException("Failed to retrieve public credential: " + e.toString()).initCause(e);
        }
        return obj;
    }

    private static Object getPrivateCredentials(Subject subject, Class cls) throws LoginException {
        final Subject s = subject;
        final Class cl = cls;
        Set credset = (Set)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return s.getPrivateCredentials(cl);
            }
        });
        final Iterator iter = credset.iterator();
        if (!iter.hasNext()) {
            String credmsg = cls.toString();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Expected private credential of type: " + credmsg + " but none found.");
            }
            throw new LoginException("Expected private credential of type: " + credmsg + " but none found.");
        }
        Object obj = null;
        try {
            obj = AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return iter.next();
                }
            });
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw (LoginException)new LoginException("Failed to retrieve private credential: " + e.toString()).initCause(e);
        }
        return obj;
    }

    private static void setSecurityContext(String userName, Subject subject, String realm) {
        SecurityContext securityContext = new SecurityContext(userName, subject, realm);
        SecurityContext.setCurrent(securityContext);
    }

    private static void unsetSecurityContext() {
        SecurityContext.setCurrent(null);
    }

    public static Subject doClientLogin(int type, CallbackHandler jaasHandler) throws LoginException {
        final CallbackHandler handler = jaasHandler;
        final Subject subject = new Subject();
        if (type == 1) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext(LoginContextDriver.CLIENT_JAAS_PASSWORD, subject, handler);
                        lg.login();
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        throw (LoginException)new LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
            return subject;
        }
        if (type == 2) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext("certificate", subject, handler);
                        lg.login();
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        throw (LoginException)new LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
            return subject;
        }
        if (type == 3) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lgup = new LoginContext(LoginContextDriver.CLIENT_JAAS_PASSWORD, subject, handler);
                        LoginContext lgc = new LoginContext("certificate", subject, handler);
                        lgup.login();
                        LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
                        lgc.login();
                        LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        throw (LoginException)new LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            return subject;
        }
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    LoginContext lg = new LoginContext(LoginContextDriver.CLIENT_JAAS_PASSWORD, subject, handler);
                    lg.login();
                    LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
                }
                catch (javax.security.auth.login.LoginException e) {
                    throw (LoginException)new LoginException(e.toString()).initCause(e);
                }
                return null;
            }
        });
        return subject;
    }

    public static void doClientLogout() throws LoginException {
        LoginContextDriver.unsetClientSecurityContext();
    }

    private static void postClientAuth(Subject subject, Class clazz) {
        final Class clas = clazz;
        final Subject fs = subject;
        Set credset = (Set)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "LCD post login subject :" + fs);
                }
                return fs.getPrivateCredentials(clas);
            }
        });
        final Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            Object obj = null;
            try {
                obj = AppservAccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iter.next();
                    }
                });
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.accesscontroller_action_exception", e);
            }
            if (obj instanceof PasswordCredential) {
                PasswordCredential p = (PasswordCredential)obj;
                String user = p.getUser();
                if (_logger.isLoggable(Level.FINEST)) {
                    String realm = p.getRealm();
                    _logger.log(Level.FINEST, "In LCD user-pass login:" + user + " realm :" + realm);
                }
                LoginContextDriver.setClientSecurityContext(user, fs);
                return;
            }
            if (!(obj instanceof X509CertificateCredential)) continue;
            X509CertificateCredential p = (X509CertificateCredential)obj;
            String user = p.getAlias();
            if (_logger.isLoggable(Level.FINEST)) {
                String realm = p.getRealm();
                _logger.log(Level.FINEST, "In LCD cert-login::" + user + " realm :" + realm);
            }
            LoginContextDriver.setClientSecurityContext(user, fs);
            return;
        }
    }

    private static void setClientSecurityContext(String username, Subject subject) {
        ClientSecurityContext securityContext = new ClientSecurityContext(username, subject);
        ClientSecurityContext.setCurrent(securityContext);
    }

    private static void unsetClientSecurityContext() {
        ClientSecurityContext.setCurrent(null);
    }
}

