/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.server.AbstractMonitor;
import com.sun.enterprise.server.MonitorListener;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class AutoDeployMonitor
extends AbstractMonitor {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static AutoDeployMonitor _instance = null;
    private static ArchiveFilter _archiveFilter = null;
    private static final String SUCCESS_EXT = ".deployed";
    private static final String ERROR_EXT = ".notdeployed";

    private AutoDeployMonitor(long pollInterval) {
        super(pollInterval);
    }

    static synchronized AutoDeployMonitor getInstance(long pollInterval) {
        if (_instance == null) {
            _instance = new AutoDeployMonitor(pollInterval);
            _archiveFilter = new ArchiveFilter();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            HashSet hashSet = this._monitoredEntries;
            synchronized (hashSet) {
                Iterator iter = this._monitoredEntries.iterator();
                MonitorableEntry entry = null;
                while (iter.hasNext()) {
                    entry = (MonitorableEntry)iter.next();
                    File autoDeployDir = entry.getMonitoredFile();
                    File[] archives = autoDeployDir.listFiles(_archiveFilter);
                    if (archives == null || archives.length == 0) {
                        return;
                    }
                    MonitorListener l = entry.getListener();
                    for (int i = 0; i < archives.length; ++i) {
                        _logger.log(Level.FINE, "[AutoDeployMonitor] Found " + archives[i]);
                        boolean success = l.deploy(entry, archives[i]);
                        if (success) {
                            File successExt = new File(archives[i].getParentFile(), archives[i].getName() + SUCCESS_EXT);
                            archives[i].renameTo(successExt);
                            continue;
                        }
                        File errorExt = new File(archives[i].getParentFile(), archives[i].getName() + ERROR_EXT);
                        archives[i].renameTo(errorExt);
                    }
                }
            }
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "core.exception", t);
        }
    }

    private static class ArchiveFilter
    implements FileFilter {
        private ArchiveFilter() {
        }

        public boolean accept(File pathname) {
            return FileUtils.isEar(pathname) || FileUtils.isJar(pathname) || FileUtils.isWar(pathname) || FileUtils.isRar(pathname);
        }
    }
}

