/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.MonitoringHelper;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.backend.OptionalPkgDependency;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.naming.ProviderManager;
import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.PEMain;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ServerContextImpl;
import com.sun.enterprise.transaction.monitor.JTSMonitorMBean;
import com.sun.enterprise.util.InjectionManagerImpl;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;

public final class J2EEServer {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static final SecureRandom secureRandom = new SecureRandom();
    public static final String J2EE_HOME = "com.sun.enterprise.home";
    public static final String J2EE_APPNAME = "com.sun.enterprise.appname";
    public static final String JTS_SERVER_ID = "com.sun.jts.persistentServerId";
    public static final String J2EE_SERVER_ID_PROP = "com.sun.enterprise.J2EEServerId";
    private static final boolean debug = true;
    private static LocalStringManagerImpl localStrings;
    private static PrintStream ostream;
    private static PrintStream estream;
    private static final int MAX_INITIAL_CONTEXT_RETRIES = 15;
    private static final String DefaultDbDir = "orb.db";
    private static final String LISTEN_PROP = "com.sun.CORBA.connection.ORBListenSocket";
    private static final String OUTPUT_LOG = "system.out";
    private static final String ERROR_LOG = "system.err";
    private File repositoryDir;
    private int orbInitialPort;
    private Configuration conf = null;
    private ORB orb;
    private ProtocolManager protocolMgr;
    private ServerContext serverContext;

    private void run(String[] args, boolean verbose, boolean startJMS) {
        ConnectorRuntime.getRuntime().initialize(1);
        try {
            if (this.serverContext != null && this.serverContext instanceof ServerContextImpl) {
                ServerContextImpl ctxImp = (ServerContextImpl)this.serverContext;
                String seedFile = ctxImp.getServerConfigPath() + File.separator + "secure.seed";
                File secureSeedFile = new File(seedFile);
                long seed = this.readSecureSeed(secureSeedFile);
                secureRandom.setSeed(seed);
                seed = secureRandom.nextLong();
                this.writeSecureSeed(secureSeedFile, seed);
                secureSeedFile = null;
            } else {
                _logger.log(Level.FINE, "Unable to initialize secure seed.");
            }
            Properties props = System.getProperties();
            props.setProperty(J2EE_APPNAME, "j2ee");
            Switch theSwitch = Switch.getSwitch();
            theSwitch.setContainerType(2);
            Switch.getSwitch().setProviderManager(ProviderManager.getProviderManager());
            ResourcesUtil.setServerContext(this.serverContext);
            InvocationManagerImpl invMgr = new InvocationManagerImpl();
            theSwitch.setInvocationManager(invMgr);
            NamingManagerImpl nm = new NamingManagerImpl();
            theSwitch.setNamingManager(nm);
            InjectionManagerImpl injectionMgr = new InjectionManagerImpl();
            theSwitch.setInjectionManager(injectionMgr);
            J2EETransactionManager tm = J2EETransactionManagerImpl.createTransactionManager();
            theSwitch.setTransactionManager(tm);
            ResourceInstaller installer = theSwitch.getResourceInstaller();
            ConnectorRuntime connRuntime = ConnectorRuntime.getRuntime();
            this.initRoleMapperFactory();
            ManagementObjectManager mgmtObjectMgr = theSwitch.getManagementObjectManager();
            ConnectorRuntime.getRuntime().initializeConnectorMonitoring();
            installer.installPersistenceManagerResources();
            installer.installCustomResources();
            installer.installExternalJndiResources();
            installer.installMailResources();
            ContainerFactoryImpl cf = new ContainerFactoryImpl();
            theSwitch.setContainerFactory(cf);
            try {
                _logger.fine("satisfy.optionalpkg.dependency");
                OptionalPkgDependency.satisfyOptionalPackageDependencies();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "optionalpkg.error", e);
            }
            MonitoringHelper.registerTxnMonitoringMBean(new JTSMonitorMBean());
            nm.publishObject("UserTransaction", (Object)new UserTransactionImpl(), true);
            String startupComplete = localStrings.getLocalString("j2ee.started", "J2EE server startup complete.");
            _logger.log(Level.FINE, startupComplete);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.j2eeservice_running_exception", ex.toString());
            }
            _logger.log(Level.FINEST, "Exception running j2ee services", ex);
            Log.err.flush();
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private void initRoleMapperFactory() throws Exception {
        Object o = null;
        Class<?> c = null;
        try {
            c = Class.forName("com.sun.enterprise.security.acl.RoleMapperFactory");
            if (c != null && (o = c.newInstance()) != null && o instanceof SecurityRoleMapperFactory) {
                SecurityRoleMapperFactoryMgr.registerFactory(o);
            }
            if (o == null) {
                _logger.log(Level.SEVERE, localStrings.getLocalString("j2ee.norolemapper", "Cannot instantiate the SecurityRoleMapperFactory"));
            }
        }
        catch (Exception cnfe) {
            _logger.log(Level.SEVERE, localStrings.getLocalString("j2ee.norolemapper", "Cannot instantiate the SecurityRoleMapperFactory"), cnfe);
            throw cnfe;
        }
    }

    private long readSecureSeed(File fname) {
        try {
            BufferedReader fis = new BufferedReader(new FileReader(fname));
            try {
                String line = fis.readLine();
                fis.close();
                Long lseed = new Long(line);
                return lseed;
            }
            catch (IOException e) {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        secureRandom.setSeed(System.currentTimeMillis());
        long newSeed = secureRandom.nextLong();
        return newSeed;
    }

    private void writeSecureSeed(File fname, long seed) {
        try {
            FileOutputStream fos = new FileOutputStream(fname);
            String sseed = Long.toString(seed);
            fos.write(sseed.getBytes());
            fos.close();
        }
        catch (IOException e) {
            String errmsg = localStrings.getLocalString("j2ee.startupslow", "Cannot write the seed file for fast startup. The next startup will be slow.");
            _logger.log(Level.WARNING, "enterprise.j2ee_startupslow");
        }
    }

    public static void main(ServerContext serverContext) throws ServerLifecycleException {
        String[] args = serverContext.getCmdLineArgs();
        if (args == null) {
            args = new String[]{};
        }
        Utility.checkJVMVersion();
        boolean verbose = false;
        boolean startJMS = true;
        if (System.getProperty("j2ee.appverification.home") != null) {
            AppVerification.setInstrument(true);
        }
        _logger.log(Level.FINE, "S1AS AVK Instrumentation " + (AppVerification.doInstrument() ? "enabled" : "disabled"));
        try {
            ORBManager.setORBSystemProperties();
            J2EEServer j2ee = new J2EEServer();
            j2ee.setServerContext(serverContext);
            j2ee.run(args, verbose, startJMS);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.run_exception", e);
            if (e.getMessage() != null && _logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.j2ee_server_error", e.getMessage());
            }
            _logger.log(Level.SEVERE, "enterprise.j2ee_server_error1");
            System.err.flush();
            throw new ServerLifecycleException(e.getMessage(), e);
        }
    }

    private void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    public static void shutdown() {
        block6: {
            PEMain.shutdownStarted = true;
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
                }
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().writeResults();
                }
                Log.flushAll();
            }
            catch (Throwable t) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "enterprise.shutdown_exception", t.toString());
                }
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
            }
        }
        if (!PEMain.shutdownThreadInvoked) {
            System.exit(0);
        }
    }

    static {
        secureRandom.setSeed(System.currentTimeMillis());
        localStrings = new LocalStringManagerImpl(J2EEServer.class);
        ostream = System.out;
        estream = System.err;
    }
}

