/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.properties;

import com.sun.enterprise.tools.common.properties.PropertyElements;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class PropertyElementsTableModel
extends AbstractTableModel {
    PropertyElements v = null;
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sun.enterprise.tools.common.properties.Bundle");

    public PropertyElementsTableModel(PropertyElements v) {
        this.v = v;
    }

    public Object getValueAt(int param, int param1) {
        Object retVal = "";
        if (param < this.v.getLength()) {
            retVal = this.v.getAttributeDetail(param, param1);
        }
        return retVal;
    }

    public int getRowCount() {
        return this.v.getLength() + 1;
    }

    public int getColumnCount() {
        return this.v.getWidth();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object val, int row, int col) {
        int pre = this.v.getLength();
        this.v.setAttributeDetail(val, row, col);
        if (this.v.getLength() < pre) {
            this.fireTableStructureChanged();
        }
    }

    public String getColumnName(int col) {
        if (0 == col) {
            return bundle.getString("COL_HEADER_NAME");
        }
        if (1 == col) {
            return bundle.getString("COL_HEADER_VALUE");
        }
        throw new RuntimeException(bundle.getString("COL_HEADER_ERR_ERR_ERR"));
    }

    public static void main(String[] args) {
        PropertyElements pe = new PropertyElements(args);
        JTable tab = new JTable(new PropertyElementsTableModel(pe));
        JScrollPane sp = new JScrollPane(tab);
        JFrame f = new JFrame();
        f.addWindowListener(new CloseTestWindow(pe));
        f.getContentPane().add(sp);
        f.show();
    }

    static class CloseTestWindow
    extends WindowAdapter {
        private PropertyElements myPE;

        public CloseTestWindow(PropertyElements pe) {
            this.myPE = pe;
        }

        public void windowClosing(WindowEvent e) {
            System.out.println(this.myPE.dumpIt());
            System.exit(0);
        }
    }
}

