/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.stdapis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIRepository {
    private static Logger logger = Logger.getLogger("apiscan.stdapis");
    private static String myClsName = "APIRepository";
    private HashMap<String, API> apis = new HashMap();
    private static APIRepository me;

    public static APIRepository Instance() {
        assert (me != null);
        return me;
    }

    public static synchronized void Initialize(String fileName) throws Exception {
        logger.logp(Level.FINE, myClsName, "Initialize", fileName);
        me = new APIRepository(fileName);
    }

    public boolean isClassPartOf(String class_name, String api_name_version) {
        if (this.getClassesFor(api_name_version).contains(class_name)) {
            return true;
        }
        if (this.getPackagesFor(api_name_version).contains(APIRepository.getPackageName(class_name))) {
            return true;
        }
        for (String pattern : this.getPatternsFor(api_name_version)) {
            if (!class_name.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public boolean isPackagePartOf(String pkg_name, String api_name_version) {
        if (this.getPackagesFor(api_name_version).contains(pkg_name)) {
            return true;
        }
        for (String pattern : this.getPatternsFor(api_name_version)) {
            if (!pkg_name.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    protected Collection<String> getPackagesFor(String api_name_version) {
        return this.apis.get(api_name_version).getPackages();
    }

    protected Collection<String> getPatternsFor(String api_name_version) {
        return this.apis.get(api_name_version).getPatterns();
    }

    protected Collection<String> getClassesFor(String api_name_version) {
        return this.apis.get(api_name_version).getClasses();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<API> i = this.apis.values().iterator();
        while (i.hasNext()) {
            sb.append("\n").append(((Object)i.next()).toString());
        }
        return sb.toString();
    }

    private APIRepository(String fileName) throws Exception {
        logger.entering(myClsName, "init<>", fileName);
        File file = new File(fileName);
        Document d = this.getDocumentBuilder().parse(file);
        this.traverseTree(d.getDocumentElement());
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        bf.setValidating(true);
        bf.setIgnoringComments(false);
        bf.setIgnoringElementContentWhitespace(true);
        bf.setCoalescing(true);
        bf.setNamespaceAware(true);
        bf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder builder = bf.newDocumentBuilder();
        builder.setErrorHandler(new DefaultHandler(){

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return builder;
    }

    private void traverseTree(Node node) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            String tagName = e.getTagName();
            if (tagName.equals("api")) {
                API a = new API(e);
                this.apis.put(a.name_version, a);
            }
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                this.traverseTree(childNodes.item(i));
            }
        }
    }

    private static String getPackageName(String externalClassName) {
        int idx = externalClassName.lastIndexOf(46);
        if (idx != -1) {
            return externalClassName.substring(0, idx);
        }
        return "";
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            APIRepository.usage();
        }
        Logger logger = Logger.getLogger("apiscan.stdapis");
        try {
            APIRepository.Initialize(args[0]);
            APIRepository apiRep = APIRepository.Instance();
            switch (args.length) {
                case 1: {
                    System.out.println(apiRep);
                    break;
                }
                case 2: {
                    System.out.println(apiRep.apis.get(args[1]));
                    break;
                }
                case 3: {
                    System.out.println(apiRep.isClassPartOf(args[2], args[1]));
                    break;
                }
                default: {
                    APIRepository.usage();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: java " + APIRepository.class.getName() + " <file_name> [api_name_version] [class_name]");
        System.out.println("\nExamples:\n");
        System.out.println("java " + APIRepository.class.getName() + " src/standard-apis.xml ejb_jar_2.0 javax.ejb.Timer");
        System.out.println("The above command prints true if javax.ejb.Timer is part of ejb_api_2.0 API.\n");
        System.out.println("java " + APIRepository.class.getName() + " src/standard-apis.xml ejb_jar_2.0");
        System.out.println("The above command prints details about all classes and packages for ejb_api_2.0 API.\n");
        System.out.println("java " + APIRepository.class.getName() + " src/standard-apis.xml");
        System.out.println("The above command prints details about all APIs.\n");
        System.exit(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class API {
        private String name_version;
        private ArrayList<APIRef> apiRefs = new ArrayList();
        ArrayList<String> packages = new ArrayList();
        ArrayList<String> patterns = new ArrayList();
        ArrayList<String> classes = new ArrayList();

        public API(Element node) {
            if (node.getTagName().equals("api")) {
                this.name_version = node.getAttribute("name_version");
                NodeList refNodes = node.getElementsByTagName("api_ref");
                for (int loopIndex = 0; loopIndex < refNodes.getLength(); ++loopIndex) {
                    this.apiRefs.add(new APIRef((Element)refNodes.item(loopIndex)));
                }
                NodeList pkgsNodes = node.getElementsByTagName("packages");
                for (int i = 0; i < pkgsNodes.getLength(); ++i) {
                    Element pkgsNode = (Element)pkgsNodes.item(i);
                    NodeList children = pkgsNode.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node next = children.item(j);
                        if (next.getNodeType() != 3) continue;
                        String names = next.getNodeValue().trim();
                        StringTokenizer st = new StringTokenizer(names);
                        while (st.hasMoreTokens()) {
                            this.packages.add(st.nextToken());
                        }
                    }
                }
                NodeList patternsNodes = node.getElementsByTagName("patterns");
                for (int i = 0; i < patternsNodes.getLength(); ++i) {
                    Element patternsNode = (Element)patternsNodes.item(i);
                    NodeList children = patternsNode.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node next = children.item(j);
                        if (next.getNodeType() != 3) continue;
                        String names = next.getNodeValue().trim();
                        StringTokenizer st = new StringTokenizer(names);
                        while (st.hasMoreTokens()) {
                            this.patterns.add(st.nextToken());
                        }
                    }
                }
                NodeList classesNodes = node.getElementsByTagName("classes");
                for (int i = 0; i < classesNodes.getLength(); ++i) {
                    Element classesNode = (Element)classesNodes.item(i);
                    String package_name = classesNode.getAttribute("package").trim();
                    NodeList children = classesNode.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node next = children.item(j);
                        if (next.getNodeType() != 3) continue;
                        String names = next.getNodeValue().trim();
                        StringTokenizer st = new StringTokenizer(names);
                        while (st.hasMoreTokens()) {
                            String clsName = package_name + "." + st.nextToken();
                            this.classes.add(clsName);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException(node.toString());
            }
        }

        public Collection<String> getPackages() {
            ArrayList<String> results = new ArrayList<String>();
            Iterator<APIRef> i = this.apiRefs.iterator();
            while (i.hasNext()) {
                results.addAll(i.next().deref().getPackages());
            }
            results.addAll(this.packages);
            return results;
        }

        public Collection<String> getPatterns() {
            ArrayList<String> results = new ArrayList<String>();
            Iterator<APIRef> i = this.apiRefs.iterator();
            while (i.hasNext()) {
                results.addAll(i.next().deref().getPatterns());
            }
            results.addAll(this.patterns);
            return results;
        }

        public Collection<String> getClasses() {
            ArrayList<String> results = new ArrayList<String>();
            Iterator<APIRef> i = this.apiRefs.iterator();
            while (i.hasNext()) {
                results.addAll(i.next().deref().getClasses());
            }
            results.addAll(this.classes);
            return results;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<api name_version=\"" + this.name_version + "\">");
            sb.append("\n\t<classes>");
            Iterator<String> i = this.getClasses().iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t").append(i.next().toString());
            }
            sb.append("\n\t</classes>");
            sb.append("\n\t<packages>");
            i = this.getPackages().iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t").append(i.next().toString());
            }
            sb.append("\n\t</packages>");
            sb.append("\n\t<patterns>");
            i = this.getPatterns().iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t").append(i.next().toString());
            }
            sb.append("\n\t</patterns>");
            sb.append("\n</api>");
            return sb.toString();
        }
    }

    class APIRef {
        private String api_name_version;

        public APIRef(Element node) {
            if (!node.getTagName().equals("api_ref")) {
                throw new IllegalArgumentException(node.toString());
            }
            this.api_name_version = node.getAttribute("api_name_version");
        }

        public APIRef(String api_name_version) {
            this.api_name_version = api_name_version;
        }

        public API deref() {
            API result = (API)APIRepository.this.apis.get(this.api_name_version);
            if (result == null) {
                throw new NullPointerException("No API with name_version [" + this.api_name_version + "]");
            }
            return result;
        }
    }
}

