/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.apiscan.packaging.Archive;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ExtensionRef;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class OptPkgDependencySatisfied
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        try {
            String earURI = this.getAbstractArchiveUri(descriptor);
            Archive jar = new Archive(new File(earURI));
            ExtensionRef[] extRefs = jar.getExtensionRefs();
            Archive[] allOptPkgs = Archive.getAllOptPkgsInstalledInJRE();
            ArrayList<ExtensionRef> notFounds = new ArrayList<ExtensionRef>();
            for (int i = 0; i < extRefs.length; ++i) {
                ExtensionRef ref = extRefs[i];
                boolean found = false;
                for (int j = 0; j < allOptPkgs.length; ++j) {
                    if (!ref.isSatisfiedBy(allOptPkgs[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                notFounds.add(ref);
            }
            if (notFounds.isEmpty()) {
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All opt package dependency satisfied for this ear file."));
                result.passed("");
            } else {
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Some dependencies could not be satisfied for this ear file. See info below..."));
                Iterator i = notFounds.iterator();
                while (i.hasNext()) {
                    result.addErrorDetails(i.next().toString());
                }
            }
        }
        catch (IOException e) {
            result.failed(e.toString());
        }
        return result;
    }
}

