/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.List;

public class RmiIIOPUtils {
    public static boolean isValidRmiIIOPInterface(Class RMIIIOPinterface) {
        boolean validInterface = false;
        Class c = RMIIIOPinterface;
        block0: do {
            if (RMIIIOPinterface.getName().equals("java.rmi.Remote")) {
                validInterface = true;
                break;
            }
            Class<?>[] interfaces = RMIIIOPinterface.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].getName().equals("java.rmi.Remote") || interfaces[i].getName().equals("javax.ejb.EJBObject") || interfaces[i].getName().equals("javax.ejb.EJBHome")) {
                    validInterface = true;
                    continue block0;
                }
                if (!RmiIIOPUtils.isValidRmiIIOPInterface(interfaces[i])) continue;
                return true;
            }
        } while ((RMIIIOPinterface = RMIIIOPinterface.getSuperclass()) != null && !validInterface);
        return validInterface;
    }

    public static boolean isValidRmiIIOPInterfaceMethods(Class RMIIIOPinterface) {
        Class c = RMIIIOPinterface;
        try {
            Class[] methodExceptionTypes;
            int i;
            Method[] methods = c.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                methodExceptionTypes = methods[i].getExceptionTypes();
                if (EjbUtils.isValidRemoteException(methodExceptionTypes)) continue;
                return false;
            }
            for (i = 0; i < methods.length; ++i) {
                methodExceptionTypes = methods[i].getExceptionTypes();
                if (RmiIIOPUtils.isValidRmiIIOPException(methodExceptionTypes)) continue;
                return false;
            }
            Field[] fields = c.getFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                if (RmiIIOPUtils.isValidRmiIIOPField(fields[i2])) continue;
                return false;
            }
        }
        catch (Throwable t) {
            Verifier.debug(t);
            return false;
        }
        return true;
    }

    public static boolean isValidRmiIIOPParameters(Class[] RMIIIOPparams) {
        if (RMIIIOPparams.length > 0) {
            for (int ii = 0; ii < RMIIIOPparams.length; ++ii) {
                Class c = RMIIIOPparams[ii];
                if (RmiIIOPUtils.isValidRmiIDLPrimitiveType(c) || RmiIIOPUtils.isValidRmiIIOPValueType(c) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(c) || RmiIIOPUtils.isJavaLangStringType(c) || RmiIIOPUtils.isValidRmiIIOPException(RMIIIOPparams) || c.getName().equals("java.lang.Object") || RmiIIOPUtils.isValidRmiIIOPCORBAObjectType(c) || RmiIIOPUtils.isValidRmiIIOPIDLEntityType(c)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isValidRmiIIOPCORBAObjectType(Class RMIIIOPvaluetype) {
        Class c = RMIIIOPvaluetype;
        boolean validInterface = false;
        block0: do {
            Class<?>[] interfaces = c.getInterfaces();
            block1: for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].getName().equals("org.omg.CORBA.Object")) {
                    validInterface = true;
                    continue block0;
                }
                Class<?> superClass = interfaces[i];
                do {
                    if (!superClass.getName().equals("org.omg.CORBA.Object")) continue;
                    validInterface = true;
                    continue block1;
                } while ((superClass = superClass.getSuperclass()) != null && !validInterface);
            }
        } while ((c = c.getSuperclass()) != null && !validInterface);
        return validInterface;
    }

    public static boolean isValidRmiIIOPIDLEntityType(Class RMIIIOPvaluetype) {
        Class c = RMIIIOPvaluetype;
        boolean validInterface = false;
        block0: do {
            Class<?>[] interfaces = c.getInterfaces();
            block1: for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].getName().equals("org.omg.CORBA.portable.IDLEntity")) {
                    validInterface = true;
                    continue block0;
                }
                Class<?> superClass = interfaces[i];
                do {
                    if (!superClass.getName().equals("org.omg.CORBA.portable.IDLEntity")) continue;
                    validInterface = true;
                    continue block1;
                } while ((superClass = superClass.getSuperclass()) != null && !validInterface);
            }
        } while ((c = c.getSuperclass()) != null && !validInterface);
        return validInterface;
    }

    public static boolean isValidRmiIIOPValueType(Class RMIIIOPvaluetype) {
        Class c = RMIIIOPvaluetype;
        boolean validInterface = false;
        boolean badOne = false;
        if (c.getName().equals("java.lang.Object")) {
            return true;
        }
        validInterface = Serializable.class.isAssignableFrom(c);
        if (!validInterface) {
            return false;
        }
        badOne = Remote.class.isAssignableFrom(c);
        if (badOne) {
            return false;
        }
        return validInterface;
    }

    public static boolean isValidRmiIIOPField(Field RMIIIOPField) {
        boolean validPrimitiveType = false;
        if (RmiIIOPUtils.isValidRmiIDLPrimitiveType(RMIIIOPField) || RMIIIOPField.getType().equals(String.class)) {
            validPrimitiveType = true;
        }
        return validPrimitiveType;
    }

    public static boolean isValidRmiIDLPrimitiveType(Field RMIIIOPField) {
        boolean validPrimitiveType = false;
        if (RMIIIOPField.getType().getName().equals("void") || RMIIIOPField.getType().getName().equals("boolean") || RMIIIOPField.getType().getName().equals("byte") || RMIIIOPField.getType().getName().equals("char") || RMIIIOPField.getType().getName().equals("short") || RMIIIOPField.getType().getName().equals("int") || RMIIIOPField.getType().getName().equals("long") || RMIIIOPField.getType().getName().equals("float") || RMIIIOPField.getType().getName().equals("double")) {
            validPrimitiveType = true;
        }
        return validPrimitiveType;
    }

    private static boolean isValidRmiIIOPInterfaceType(Class interfaceClass) {
        return interfaceClass.isInterface();
    }

    public static boolean isValidRmiIDLPrimitiveType(Class primitiveClass) {
        boolean validPrimitiveType = false;
        if (primitiveClass.getName().equals("void") || primitiveClass.getName().equals("boolean") || primitiveClass.getName().equals("byte") || primitiveClass.getName().equals("char") || primitiveClass.getName().equals("short") || primitiveClass.getName().equals("int") || primitiveClass.getName().equals("long") || primitiveClass.getName().equals("float") || primitiveClass.getName().equals("double")) {
            validPrimitiveType = true;
        }
        return validPrimitiveType;
    }

    public static boolean isJavaLangStringType(Class jlsClass) {
        boolean validJlsType = false;
        if (jlsClass.getName().equals("java.lang.String")) {
            validJlsType = true;
        }
        return validJlsType;
    }

    public static boolean isValidRmiIIOPException(Class[] RMIIIOPexceptions) {
        boolean throwsRemoteException = false;
        for (int kk = 0; kk < RMIIIOPexceptions.length; ++kk) {
            if (!RMIIIOPexceptions[kk].getName().equals("java.rmi.RemoteException") && !RMIIIOPexceptions[kk].getName().equals("RemoteException")) continue;
            throwsRemoteException = true;
            break;
        }
        return throwsRemoteException;
    }

    public static boolean isValidRmiIIOPReturnType(Class RMIIIOPReturnType) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(RMIIIOPReturnType) || RmiIIOPUtils.isValidRmiIIOPValueType(RMIIIOPReturnType) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(RMIIIOPReturnType) || RmiIIOPUtils.isJavaLangStringType(RMIIIOPReturnType) || RmiIIOPUtils.isValidRmiIIOPCORBAObjectType(RMIIIOPReturnType) || RMIIIOPReturnType.getName().equals("java.lang.Object") || RmiIIOPUtils.isValidRmiIIOPIDLEntityType(RMIIIOPReturnType);
    }

    public static boolean isValidSerializableType(Class c) {
        return Serializable.class.isAssignableFrom(c);
    }

    public static boolean isPersistentFieldTypeValid(Class CmpField, String HomeClass, String RemoteClass2) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(CmpField) || RmiIIOPUtils.isValidSerializableType(CmpField) || CmpField.getName().equals(HomeClass) || CmpField.getName().equals(RemoteClass2);
    }

    public static boolean isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(Class[] ejbFindExceptions, Class[] findExceptions) {
        boolean oneFailed = false;
        if (Arrays.equals(ejbFindExceptions, findExceptions)) {
            return true;
        }
        List<Class> ejbFindList = Arrays.asList(ejbFindExceptions);
        List<Class> findList = Arrays.asList(findExceptions);
        if (!ejbFindList.isEmpty()) {
            for (Class nextEjbFindMethodException : ejbFindList) {
                if (findList.contains(nextEjbFindMethodException) || RmiIIOPUtils.isSuperClassofClass("java.lang.RuntimeException", nextEjbFindMethodException)) continue;
                oneFailed = true;
                break;
            }
            return !oneFailed;
        }
        return true;
    }

    private static boolean isSuperClassofClass(String superClass, Class fromClass) {
        boolean validSuperClass = false;
        Class c = fromClass;
        do {
            if (!c.getName().equals(superClass)) continue;
            validSuperClass = true;
            break;
        } while ((c = c.getSuperclass()) != null && !validSuperClass);
        return validSuperClass;
    }
}

