/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class EjbClassStaticFieldsFinal
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            Class<?> c = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            boolean oneFailed = false;
            boolean badField = false;
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers;
                badField = false;
                if (fields[i].getName().indexOf("$") == -1 && Modifier.isStatic(modifiers = fields[i].getModifiers())) {
                    if (Modifier.isFinal(modifiers)) continue;
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    badField = true;
                }
                if (!badField) continue;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Field [ {0} ] defined within bean class [ {1} ] is defined as static, but not defined as final.  An enterprise Bean must not use read/write static fields. Using read-only static fields is allowed.", new Object[]{fields[i].getName(), descriptor.getEjbClassName()}));
            }
            if (!oneFailed) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "This bean class [ {0} ] has defined any and all static fields as final.", new Object[]{descriptor.getEjbClassName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
        }
        catch (Exception e) {
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: [ {0} ] class encountered [ {1} ]", new Object[]{descriptor.getEjbClassName(), e.getMessage()}));
        }
        catch (Throwable t) {
            result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.warning(smh.getLocalString(this.getClass().getName() + ".warningException", "Warning: [ {0} ] class encountered [ {1} ]. Cannot access fields of class [ {2} ] which is external to [ {3} ].", new Object[]{descriptor.getEjbClassName(), t.toString(), t.getMessage(), descriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri()}));
        }
        return result;
    }
}

