/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class BusinessMethodMatchesWithDD
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor, "Remote");
            }
            if (descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor, "Local");
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Business method(s) are valid."));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String intf, EjbDescriptor descriptor, String methodIntf) {
        try {
            Class<?> intfClass = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
            boolean found = false;
            HashSet allMethods = new HashSet();
            for (Set methodDescriptors : descriptor.getPermissionedMethodsByPermission().values()) {
                if (methodDescriptors == null) continue;
                allMethods.addAll(methodDescriptors);
            }
            Enumeration e = descriptor.getMethodContainerTransactions().keys();
            while (e.hasMoreElements()) {
                allMethods.add(e.nextElement());
            }
            for (Method remoteMethod : intfClass.getMethods()) {
                found = false;
                if (remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
                if (!(remoteMethod.getName().startsWith("ejb") || remoteMethod.getName().equals("class$") || remoteMethod.getName().equals("setSessionContext"))) {
                    for (MethodDescriptor methodDescriptor : allMethods) {
                        if (!methodDescriptor.getName().equals(remoteMethod.getName()) || !MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(remoteMethod, methodIntf).getParameterClassNames())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Business method [ {0} ] is not defined in the deployment descriptor.", new Object[]{remoteMethod.getName()}));
            }
        }
        catch (Exception e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Component interface [ {0} ] does not exist or is not loadable within bean [ {1} ].", new Object[]{intf, descriptor.getName()}));
        }
    }
}

