/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;

public class EjbFinderMethodException
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Bean".equals(persistence)) {
                boolean ejbFindMethodFound = false;
                boolean throwsRemoteException = false;
                boolean throwsFinderException = false;
                boolean isValidFinderException = false;
                boolean oneFailed = false;
                int foundWarning = 0;
                int foundAtLeastOne = 0;
                try {
                    Context context = this.getVerifierContext();
                    ClassLoader jcl = context.getClassLoader();
                    Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        for (int j = 0; j < ejbFinderMethods.length; ++j) {
                            throwsRemoteException = false;
                            throwsFinderException = false;
                            ejbFindMethodFound = false;
                            if (!ejbFinderMethods[j].getName().startsWith("ejbFind")) continue;
                            ejbFindMethodFound = true;
                            ++foundAtLeastOne;
                            Class[] exceptions = ejbFinderMethods[j].getExceptionTypes();
                            if (EjbUtils.isValidRemoteException(exceptions)) {
                                throwsRemoteException = true;
                            }
                            if (EjbUtils.isValidFinderException(exceptions)) {
                                throwsFinderException = true;
                            }
                            if (ejbFindMethodFound && !throwsRemoteException && throwsFinderException) {
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] declares [ {1} ] method, which properly does not throw java.rmi.RemoteException, but throws FinderException", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                                continue;
                            }
                            if (ejbFindMethodFound && throwsRemoteException) {
                                if (descriptor instanceof EjbCMPEntityDescriptor) {
                                    if (((EjbCMPEntityDescriptor)descriptor).getCMPVersion() == 2) {
                                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{descriptor.getEjbClassName(), ejbFinderMethods[j].getName()}));
                                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".error", "Error: Compatibility Note:\n An [ {0} ] method was found, but\n EJB 1.0 allowed the ejbFind<METHOD> method to throw the \n java.rmi.RemoteException to indicate a non-application\n exception. This practice was deprecated in EJB 1.1\n ---an EJB 2.0 compliant enterprise bean must\n throw the javax.ejb.EJBException or another \n RuntimeException to indicate non-application exceptions\n to the Container. ", new Object[]{ejbFinderMethods[j].getName()}));
                                        oneFailed = true;
                                        continue;
                                    }
                                    ++foundWarning;
                                    result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                    result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{descriptor.getEjbClassName(), ejbFinderMethods[j].getName()}));
                                    result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "Error: Compatibility Note:\n An [ {0} ] method was found, but\n EJB 1.0 allowed the ejbFind<METHOD> method to throw the \n java.rmi.RemoteException to indicate a non-application\n exception. This practice is deprecated in EJB 1.1\n ---an EJB 1.1 compliant enterprise bean should\n throw the javax.ejb.EJBException or another \n RuntimeException to indicate non-application exceptions\n to the Container. ", new Object[]{ejbFinderMethods[j].getName()}));
                                    continue;
                                }
                                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any ejbFind<METHOD>(...) methods.", new Object[]{descriptor.getEjbClassName()}));
                                continue;
                            }
                            if (!ejbFindMethodFound || throwsFinderException) continue;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{descriptor.getEjbClassName(), ejbFinderMethods[j].getName()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".error1", "Error: ejbFind[Method] [ {0} ] does not throw FinderException", new Object[]{ejbFinderMethods[j].getName()}));
                            oneFailed = true;
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && foundAtLeastOne == 0);
                    if (foundAtLeastOne == 0) {
                        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any ejbFind<METHOD>(...) methods.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e) {
                    Verifier.debug(e);
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundAtLeastOne == 0) {
                    result.setStatus(3);
                } else if (foundWarning > 0) {
                    result.setStatus(2);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{"Bean", descriptor.getName(), persistence}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

