/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.io.IOException;
import java.io.InputStream;

public class WSDLFileCheck
extends WSTest
implements WSCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        InputStream deploymentEntry = null;
        String wsdlUri = descriptor.getWebService().getWsdlFileUri();
        try {
            String uri = this.getAbstractArchiveUri(descriptor);
            FileArchive arch = new FileArchive();
            arch.open(uri);
            deploymentEntry = arch.getEntry(wsdlUri);
            if (deploymentEntry == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "WSDL file does not exist in the archive at uri [{0}].", new Object[]{wsdlUri}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "WSDL file exists in the archive at uri [{0}].", new Object[]{wsdlUri}));
            }
        }
        catch (Exception e) {
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (deploymentEntry != null) {
                    deploymentEntry.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }
}

