/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.util.io.ProcessStreamDrainerWorker;

public class ProcessStreamDrainer {
    private final Process process;
    private final Thread errThread;
    private final Thread outThread;
    private final String processName;
    private final boolean redirectStandardStreams;
    private static final String ERROR_DRAINER = "StderrDrainer";
    private static final String OUT_DRAINER = "StdoutDrainer";

    public static ProcessStreamDrainer drain(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, false);
        psd.drain();
        return psd;
    }

    public static ProcessStreamDrainer redirect(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, true);
        psd.drain();
        return psd;
    }

    public final void waitFor() throws InterruptedException {
        this.errThread.join();
        this.outThread.join();
    }

    private ProcessStreamDrainer(String processName, Process process, boolean redirect) {
        if (process == null) {
            throw new NullPointerException("Internal Error: null Process object");
        }
        this.process = process;
        this.processName = processName == null || processName.length() <= 0 ? "UnknownProcessName" : processName;
        this.redirectStandardStreams = redirect;
        ProcessStreamDrainerWorker worker = this.redirectStandardStreams ? new ProcessStreamDrainerWorker(process.getInputStream(), System.out) : new ProcessStreamDrainerWorker(process.getInputStream());
        this.outThread = new Thread((Runnable)worker, processName + "-" + OUT_DRAINER);
        this.outThread.setDaemon(true);
        worker = this.redirectStandardStreams ? new ProcessStreamDrainerWorker(process.getErrorStream(), System.err) : new ProcessStreamDrainerWorker(process.getErrorStream());
        this.errThread = new Thread((Runnable)worker, processName + "-" + ERROR_DRAINER);
        this.errThread.setDaemon(true);
    }

    private void drain() {
        this.outThread.start();
        this.errThread.start();
    }
}

