/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.web.stats.HTTPListenerStatsImpl;
import java.util.LinkedList;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCRequestStatsImpl
implements PWCRequestStats {
    private GenericStatsImpl baseStatsImpl;
    private long startTime;
    private LinkedList<HTTPListenerStatsImpl> httpListenerStats = new LinkedList();
    private MutableCountStatistic countRequests;
    private MutableCountStatistic countBytesReceived;
    private MutableCountStatistic countBytesTransmitted;
    private MutableCountStatistic rateBytesTransmitted;
    private MutableCountStatistic maxByteTransmissionRate;
    private MutableCountStatistic countOpenConnections;
    private MutableCountStatistic maxOpenConnections;
    private MutableCountStatistic count2xx;
    private MutableCountStatistic count3xx;
    private MutableCountStatistic count4xx;
    private MutableCountStatistic count5xx;
    private MutableCountStatistic countOther;
    private MutableCountStatistic count200;
    private MutableCountStatistic count302;
    private MutableCountStatistic count304;
    private MutableCountStatistic count400;
    private MutableCountStatistic count401;
    private MutableCountStatistic count403;
    private MutableCountStatistic count404;
    private MutableCountStatistic count503;

    public PWCRequestStatsImpl(String domain) {
        this.baseStatsImpl = new GenericStatsImpl(PWCRequestStats.class, (Object)this);
        this.initializeStatistics();
    }

    public void addHttpListenerStats(HTTPListenerStatsImpl stats) {
        this.httpListenerStats.add(stats);
    }

    public StringStatistic getMethod() {
        String lastMethod = "unknown";
        long lastRequestTime = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            HTTPListenerStatsImpl listener = this.httpListenerStats.get(i);
            if (listener.getLastRequestCompletionTime() <= lastRequestTime) continue;
            lastRequestTime = listener.getLastRequestCompletionTime();
            lastMethod = listener.getLastRequestMethod();
        }
        return new StringStatisticImpl(lastMethod, "method", "String", "Method of the last request serviced", this.startTime, System.currentTimeMillis());
    }

    public StringStatistic getUri() {
        String lastURI = "unknown";
        long lastRequestTime = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            HTTPListenerStatsImpl listener = this.httpListenerStats.get(i);
            if (listener.getLastRequestCompletionTime() <= lastRequestTime) continue;
            lastRequestTime = listener.getLastRequestCompletionTime();
            lastURI = listener.getLastRequestURI();
        }
        return new StringStatisticImpl(lastURI, "uri", "String", "URI of the last request serviced", this.startTime, System.currentTimeMillis());
    }

    public CountStatistic getCountRequests() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getRequestCountLong();
        }
        this.countRequests.setCount(count);
        return (CountStatistic)this.countRequests.unmodifiableView();
    }

    public CountStatistic getCountBytesReceived() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getBytesReceivedLong();
        }
        this.countBytesReceived.setCount(count);
        return (CountStatistic)this.countBytesReceived.unmodifiableView();
    }

    public CountStatistic getCountBytesTransmitted() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getBytesSentLong();
        }
        this.countBytesTransmitted.setCount(count);
        return (CountStatistic)this.countBytesTransmitted.unmodifiableView();
    }

    public CountStatistic getRateBytesTransmitted() {
        this.rateBytesTransmitted.setCount(0L);
        return (CountStatistic)this.rateBytesTransmitted.unmodifiableView();
    }

    public CountStatistic getMaxByteTransmissionRate() {
        this.maxByteTransmissionRate.setCount(0L);
        return (CountStatistic)this.maxByteTransmissionRate.unmodifiableView();
    }

    public CountStatistic getCountOpenConnections() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCountOpenConnectionsLong();
        }
        this.countOpenConnections.setCount(count);
        return (CountStatistic)this.countOpenConnections.unmodifiableView();
    }

    public CountStatistic getMaxOpenConnections() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getMaxOpenConnectionsLong();
        }
        this.maxOpenConnections.setCount(count);
        return (CountStatistic)this.maxOpenConnections.unmodifiableView();
    }

    public CountStatistic getCount2xx() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount2xxLong();
        }
        this.count2xx.setCount(count);
        return (CountStatistic)this.count2xx.unmodifiableView();
    }

    public CountStatistic getCount3xx() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount3xxLong();
        }
        this.count3xx.setCount(count);
        return (CountStatistic)this.count3xx.unmodifiableView();
    }

    public CountStatistic getCount4xx() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount4xxLong();
        }
        this.count4xx.setCount(count);
        return (CountStatistic)this.count4xx.unmodifiableView();
    }

    public CountStatistic getCount5xx() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount5xxLong();
        }
        this.count5xx.setCount(count);
        return (CountStatistic)this.count5xx.unmodifiableView();
    }

    public CountStatistic getCountOther() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCountOtherLong();
        }
        this.countOther.setCount(count);
        return (CountStatistic)this.countOther.unmodifiableView();
    }

    public CountStatistic getCount200() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount200Long();
        }
        this.count200.setCount(count);
        return (CountStatistic)this.count200.unmodifiableView();
    }

    public CountStatistic getCount302() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount302Long();
        }
        this.count302.setCount(count);
        return (CountStatistic)this.count302.unmodifiableView();
    }

    public CountStatistic getCount304() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount304Long();
        }
        this.count304.setCount(count);
        return (CountStatistic)this.count304.unmodifiableView();
    }

    public CountStatistic getCount400() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount400Long();
        }
        this.count400.setCount(count);
        return (CountStatistic)this.count400.unmodifiableView();
    }

    public CountStatistic getCount401() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount401Long();
        }
        this.count401.setCount(count);
        return (CountStatistic)this.count401.unmodifiableView();
    }

    public CountStatistic getCount403() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount403Long();
        }
        this.count403.setCount(count);
        return (CountStatistic)this.count403.unmodifiableView();
    }

    public CountStatistic getCount404() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount404Long();
        }
        this.count404.setCount(count);
        return (CountStatistic)this.count404.unmodifiableView();
    }

    public CountStatistic getCount503() {
        long count = 0L;
        int size = this.httpListenerStats.size();
        for (int i = 0; i < size; ++i) {
            count += this.httpListenerStats.get(i).getCount503Long();
        }
        this.count503.setCount(count);
        return (CountStatistic)this.count503.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String name) {
        return this.baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        this.startTime = System.currentTimeMillis();
        CountStatisticImpl c = new CountStatisticImpl("CountRequests");
        this.countRequests = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountBytesReceived");
        this.countBytesReceived = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountBytesTransmitted");
        this.countBytesTransmitted = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("RateBytesTransmitted");
        this.rateBytesTransmitted = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxByteTransmissionRate");
        this.maxByteTransmissionRate = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountOpenConnections");
        this.countOpenConnections = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxOpenConnections");
        this.maxOpenConnections = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count2xx");
        this.count2xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count3xx");
        this.count3xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count4xx");
        this.count4xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count5xx");
        this.count5xx = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountOther");
        this.countOther = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count200");
        this.count200 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count302");
        this.count302 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count304");
        this.count304 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count400");
        this.count400 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count401");
        this.count401 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count403");
        this.count403 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count404");
        this.count404 = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("Count503");
        this.count503 = new MutableCountStatisticImpl((CountStatistic)c);
    }
}

