/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.JarPathElement;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.xml.sax.InputSource;

public final class TldConfig {
    private static HashSet<String> noTldListeners;
    private static Log log;
    private static final String FILE_URL_PREFIX = "file:";
    private static final int FILE_URL_PREFIX_LEN;
    private static boolean cacheListeners;
    private static HashSet<String> systemTldUris;
    private static HashSet<String> systemTldUrisJsf;
    private Context context = null;
    private static final StringManager sm;
    private Digester tldDigester = null;
    private boolean isCurrentTldLocal = false;
    private String currentTldUri;
    private boolean tldValidation = false;
    private boolean tldNamespaceAware = false;
    private boolean rescan = true;
    private static boolean scanParent;
    private ArrayList listeners = new ArrayList();
    private HashMap<String, String[]> tldUriToLocationMap = new HashMap();
    private String currentTldResourcePath;
    private String currentTldJarFile;
    private String currentTldJarEntryName;
    private boolean useMyFaces;

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
    }

    public static void setNoTldListeners(String jarNames) {
        if (jarNames != null) {
            if (noTldListeners == null) {
                noTldListeners = new HashSet();
            } else {
                noTldListeners.clear();
            }
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldListeners.add(tokenizer.nextToken());
            }
        }
    }

    public static void setNoTldListeners(HashSet set) {
        noTldListeners = set;
    }

    public static void setScanParentTldListener(boolean scan) {
        scanParent = scan;
    }

    public static boolean getScanParentTldListener() {
        return scanParent;
    }

    public static void setCacheListeners(boolean cache) {
        cacheListeners = cache;
    }

    public static boolean isCacheListeners() {
        return cacheListeners;
    }

    public static void setSingleProcess(boolean isSingleProcess) {
        cacheListeners = isSingleProcess;
    }

    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    public boolean getTldValidation() {
        return this.tldValidation;
    }

    public boolean getTldNamespaceAware() {
        return this.tldNamespaceAware;
    }

    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        this.tldNamespaceAware = tldNamespaceAware;
    }

    public boolean isRescan() {
        return this.rescan;
    }

    public void setRescan(boolean rescan) {
        this.rescan = rescan;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
        this.useMyFaces = ((StandardContext)context).isUseMyFaces();
    }

    public void addApplicationListener(String s) {
        if (log.isDebugEnabled()) {
            log.debug("Add tld listener " + s);
        }
        if (!((!this.isCurrentTldLocal || systemTldUris.contains(this.currentTldUri) || systemTldUrisJsf.contains(this.currentTldUri) && !this.useMyFaces) && (this.isCurrentTldLocal || systemTldUrisJsf.contains(this.currentTldUri) && this.useMyFaces))) {
            this.listeners.add(s);
        }
    }

    public void setTldUri(String uri) {
        this.currentTldUri = uri;
        if (this.isCurrentTldLocal && !systemTldUris.contains(this.currentTldUri) && (!systemTldUrisJsf.contains(this.currentTldUri) || this.useMyFaces) && this.tldUriToLocationMap.get(this.currentTldUri) == null) {
            String[] currentTldLocation = new String[2];
            if (this.currentTldResourcePath != null) {
                currentTldLocation[0] = this.currentTldResourcePath;
            } else if (this.currentTldJarFile != null && this.currentTldJarEntryName != null) {
                currentTldLocation[0] = FILE_URL_PREFIX + this.currentTldJarFile;
                currentTldLocation[1] = this.currentTldJarEntryName;
            }
            this.tldUriToLocationMap.put(this.currentTldUri, currentTldLocation);
        }
    }

    public String[] getTldListeners() {
        String[] result = new String[this.listeners.size()];
        this.listeners.toArray(result);
        return result;
    }

    public void execute() throws Exception {
        long lastModified;
        long t1 = System.currentTimeMillis();
        File tldCache = null;
        if (log.isDebugEnabled()) {
            log.debug("Create/use TLD listener cache? " + TldConfig.isCacheListeners());
        }
        if (this.context instanceof StandardContext && TldConfig.isCacheListeners()) {
            File workDir = (File)((StandardContext)this.context).getServletContext().getAttribute("javax.servlet.context.tempdir");
            tldCache = new File(workDir, "tldCache.ser");
        }
        if (!this.rescan && tldCache != null && tldCache.exists()) {
            try {
                this.processCache(tldCache);
                return;
            }
            catch (Throwable t) {
                log.warn("Error scanning " + tldCache, t);
            }
        }
        Set resourcePaths = this.tldScanResourcePaths();
        Map jarPaths = this.getJarPaths();
        if (tldCache != null && tldCache.exists() && (lastModified = this.getLastModified(resourcePaths, jarPaths)) < tldCache.lastModified()) {
            try {
                this.processCache(tldCache);
                return;
            }
            catch (Throwable t) {
                log.warn("Error scanning " + tldCache, t);
            }
        }
        Iterator paths = resourcePaths.iterator();
        while (paths.hasNext()) {
            this.tldScanTld((String)paths.next());
        }
        if (jarPaths != null) {
            for (JarPathElement elem : jarPaths.values()) {
                this.tldScanJar(elem.getJarFile(), elem.getIsLocal());
            }
        }
        String[] list = this.getTldListeners();
        if (tldCache != null) {
            log.debug("Saving tld cache: " + tldCache + " " + list.length);
            try {
                FileOutputStream out = new FileOutputStream(tldCache);
                ObjectOutputStream oos = new ObjectOutputStream(out);
                oos.writeObject(list);
                oos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding tld listeners:" + list.length);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            this.context.addApplicationListener(list[i]);
        }
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setTldScanTime(t2 - t1);
        }
        this.context.getServletContext().setAttribute("com.sun.jsp.tldUriToLocationMap", this.tldUriToLocationMap);
    }

    private long getLastModified(Set resourcePaths, Map jarPaths) throws Exception {
        long lastModified = 0L;
        for (String path : resourcePaths) {
            URL url = this.context.getServletContext().getResource(path);
            if (url == null) {
                log.debug("Null url " + path);
                break;
            }
            long lastM = url.openConnection().getLastModified();
            if (lastM > lastModified) {
                lastModified = lastM;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Last modified " + path + " " + lastM);
        }
        if (jarPaths != null) {
            for (JarPathElement elem : jarPaths.values()) {
                File jarFile = elem.getJarFile();
                long lastM = jarFile.lastModified();
                if (lastM > lastModified) {
                    lastModified = lastM;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Last modified " + jarFile.getAbsolutePath() + " " + lastM);
            }
        }
        return lastModified;
    }

    private void processCache(File tldCache) throws Exception {
        FileInputStream in = new FileInputStream(tldCache);
        ObjectInputStream ois = new ObjectInputStream(in);
        String[] list = (String[])ois.readObject();
        if (log.isDebugEnabled()) {
            log.debug("Reusing tldCache " + tldCache + " " + list.length);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            this.context.getLoader().getClassLoader().loadClass(list[i]);
            this.context.addApplicationListener(list[i]);
        }
        ois.close();
    }

    private Digester createTldDigester() {
        return DigesterFactory.newDigester(false, this.tldNamespaceAware, new TldRuleSet());
    }

    private void tldScanJar(File file) throws Exception {
        this.tldScanJar(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanJar(File file, boolean isLocal) throws Exception {
        JarFile jarFile = null;
        String name = null;
        String jarPath = file.getAbsolutePath();
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                if (log.isTraceEnabled()) {
                    log.trace("  Processing TLD at '" + name + "'");
                }
                this.currentTldJarFile = jarPath;
                this.currentTldJarEntryName = name;
                try {
                    this.tldScanStream(new InputSource(jarFile.getInputStream(entry)), isLocal);
                }
                catch (Exception e) {
                    log.error(sm.getString("contextConfig.tldEntryException", (Object)name, (Object)jarPath, this.context.getPath()), e);
                }
            }
        }
        catch (Exception e) {
            log.error(sm.getString("contextConfig.tldJarException", (Object)jarPath, this.context.getPath()), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void tldScanStream(InputSource resourceStream) throws Exception {
        this.tldScanStream(resourceStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanStream(InputSource resourceStream, boolean isLocal) throws Exception {
        if (this.tldDigester == null) {
            this.tldDigester = this.createTldDigester();
        }
        Digester digester = this.tldDigester;
        synchronized (digester) {
            try {
                this.tldDigester.push(this);
                this.isCurrentTldLocal = isLocal;
                this.tldDigester.parse(resourceStream);
            }
            finally {
                this.isCurrentTldLocal = false;
                this.currentTldUri = null;
                this.currentTldJarFile = null;
                this.currentTldJarEntryName = null;
                this.currentTldResourcePath = null;
                this.tldDigester.push(null);
                this.tldDigester.clear();
            }
        }
    }

    private void tldScanTld(String resourcePath) throws Exception {
        InputStream tldStream;
        if (log.isDebugEnabled()) {
            log.debug(" Scanning TLD at resource path '" + resourcePath + "'");
        }
        if ((tldStream = this.context.getServletContext().getResourceAsStream(resourcePath)) == null) {
            throw new ServletException(sm.getString("contextConfig.tldResourcePath", resourcePath));
        }
        InputSource inputSource = new InputSource(tldStream);
        this.currentTldResourcePath = resourcePath;
        try {
            this.tldScanStream(inputSource, true);
        }
        catch (Exception e) {
            throw new ServletException(sm.getString("contextConfig.tldFileException", (Object)resourcePath, this.context.getPath()), (Throwable)e);
        }
    }

    private Set tldScanResourcePaths() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace(" Accumulating TLD resource paths");
        }
        HashSet<String> resourcePaths = new HashSet<String>();
        if (log.isTraceEnabled()) {
            log.trace("  Scanning <taglib> elements in web.xml");
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String resourcePath = this.context.findTaglib(taglibs[i]);
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/WEB-INF/" + resourcePath;
            }
            if (log.isTraceEnabled()) {
                log.trace("   Adding path '" + resourcePath + "' for URI '" + taglibs[i] + "'");
            }
            this.tldUriToLocationMap.put(taglibs[i], new String[]{resourcePath, null});
            resourcePaths.add(resourcePath);
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            this.tldScanResourcePathsWebInf(resources, "/WEB-INF", resourcePaths);
        }
        return resourcePaths;
    }

    private void tldScanResourcePathsWebInf(DirContext resources, String rootPath, Set tldPaths) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("  Scanning TLDs in " + rootPath + " subdirectory");
        }
        try {
            NamingEnumeration<NameClassPair> items = resources.list(rootPath);
            while (items.hasMoreElements()) {
                NameClassPair item = (NameClassPair)items.nextElement();
                String resourcePath = rootPath + "/" + item.getName();
                if (resourcePath.startsWith("/WEB-INF/tags")) continue;
                if (resourcePath.endsWith(".tld")) {
                    if (log.isTraceEnabled()) {
                        log.trace("   Adding path '" + resourcePath + "'");
                    }
                    tldPaths.add(resourcePath);
                    continue;
                }
                this.tldScanResourcePathsWebInf(resources, resourcePath, tldPaths);
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    private Map getJarPaths() {
        ClassLoader webappLoader;
        HashMap<String, JarPathElement> jarPathMap = null;
        ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    String path;
                    File file = new File(RequestUtil.URLDecode(urls[i].getFile()));
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (!file.exists() || !(path = file.getAbsolutePath()).endsWith(".jar") || loader != webappLoader && noTldListeners != null && noTldListeners.contains(file.getName())) continue;
                    JarPathElement elem = new JarPathElement(file, loader == webappLoader);
                    if (jarPathMap == null) {
                        jarPathMap = new HashMap<String, JarPathElement>();
                        jarPathMap.put(path, elem);
                        continue;
                    }
                    if (jarPathMap.containsKey(path)) continue;
                    jarPathMap.put(path, elem);
                }
            }
            if (scanParent || this.context.isJsfApplication()) {
                loader = loader.getParent();
                continue;
            }
            loader = null;
        }
        return jarPathMap;
    }

    static {
        log = LogFactory.getLog(TldConfig.class);
        FILE_URL_PREFIX_LEN = FILE_URL_PREFIX.length();
        cacheListeners = true;
        systemTldUris = new HashSet();
        systemTldUrisJsf = new HashSet();
        systemTldUrisJsf.add("http://java.sun.com/jsf/core");
        systemTldUrisJsf.add("http://java.sun.com/jsf/html");
        systemTldUris.add("http://java.sun.com/jsp/jstl/core");
        sm = StringManager.getManager("org.apache.catalina.startup");
        scanParent = false;
    }
}

