/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletInputStream;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.tomcat5.InputBuffer;

public class CoyoteInputStream
extends ServletInputStream {
    private static final StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");
    protected InputBuffer ib;

    public CoyoteInputStream(InputBuffer ib) {
        this.ib = ib;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ib = null;
    }

    public int read() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.readByte();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.readByte();
    }

    public int available() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.available();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.available();
    }

    public int read(final byte[] b) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b, 0, b.length);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, 0, b.length);
    }

    public int read(final byte[] b, final int off, final int len) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b, off, len);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, off, len);
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        return super.readLine(b, off, len);
    }

    public void close() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        CoyoteInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.ib.close();
        }
    }
}

