/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.jbi.jsf.bean.JBIComponentConfigBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.webui.jsf.model.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class InstallationBean {
    public static final String DEFAULT_PE_TARGET = "server";
    private static Logger sLog = JBILogger.getInstance();
    private Option[] mAllTargets = null;
    private String[] mTargetNames = new String[]{"server"};
    private boolean mIsAlertNeeded;
    private String mResultDetails;
    private String mResultSummary;
    private boolean mUploadSelected;

    public Properties installValidatedArchive(Properties aSource, String aTarget) {
        Properties result = aSource;
        String jbiType = aSource.getProperty("type");
        String archiveName = aSource.getProperty("archiveName");
        String archivePath = aSource.getProperty("path");
        result = this.tryInstallToOneTarget(archiveName, archivePath, jbiType, aTarget, result);
        return result;
    }

    public Properties installValidatedArchive(Properties aSource) {
        String TARGET_DOMAIN = "domain";
        Properties result = aSource;
        sLog.fine("InstallationBean.installValidatedArchive(" + aSource + "), mTargetNames=" + this.mTargetNames);
        String archivePath = aSource.getProperty("path");
        String jbiType = aSource.getProperty("type");
        String archiveName = aSource.getProperty("archiveName");
        if (null != this.mTargetNames) {
            if (0 == this.mTargetNames.length) {
                sLog.fine("InstallationBean.installValidatedArchive(" + aSource + ") install to \"domain\"");
                result = this.tryInstallToOneTarget(null, archivePath, jbiType, "domain", result);
            } else {
                for (int i = 0; i < this.mTargetNames.length; ++i) {
                    sLog.fine("InstallationBean.installValidatedArchive(" + aSource + ") install to \"" + this.mTargetNames[i] + "\"");
                    result = this.tryInstallToOneTarget(archiveName, archivePath, jbiType, this.mTargetNames[i], result);
                }
            }
        }
        sLog.fine("InstallationBean.installValidatedArchive(), result=" + result);
        return result;
    }

    private Properties tryInstallToOneTarget(String anArchiveName, String anArchivePath, String aJbiType, String aTargetName, Properties aSource) {
        Properties result = aSource;
        this.mIsAlertNeeded = false;
        String installResult = "unknown";
        try {
            installResult = this.installValidatedArchiveToTarget(anArchiveName, anArchivePath, aJbiType, aTargetName);
            result.setProperty("success-result", installResult);
            sLog.fine("InstallationBean.tryInstallToOneTarget(...), result=" + result);
        }
        catch (JBIRemoteException jbiRemoteEx) {
            jbiRemoteEx.printStackTrace(System.err);
            JBIManagementMessage mgmtMsg = BeanUtilities.extractJBIManagementMessage((Exception)((Object)jbiRemoteEx));
            if (mgmtMsg == null) {
                String internalErrorMsg = I18nUtilities.getResourceString("jbi.internal.error.invalid.remote.exception");
                result.setProperty("internal-error", internalErrorMsg);
            }
            String msg = mgmtMsg.getMessage();
            result.setProperty("failure-result", msg);
        }
        sLog.fine("InstallationBean.tryInstallToOneTarget(" + aTargetName + ", " + aJbiType + ", <properties>), result=" + result);
        return result;
    }

    private String installValidatedArchiveToTarget(String anArchiveName, String anArchivePath, String aJbiType, String aTarget) throws JBIRemoteException {
        String result = "";
        sLog.fine("InstallationBean.installValidatedArihiveToTarget(" + anArchivePath + ", " + aJbiType + ", " + aTarget);
        JBIAdminCommands jac = BeanUtilities.getClient();
        if (null != jac) {
            if ("binding-component".equals(aJbiType) || "service-engine".equals(aJbiType)) {
                JBIComponentConfigBean configBean = BeanUtilities.getJBIComponentConfigBean();
                Properties configProps = configBean.getConfigurationProperties();
                result = configProps == null || configProps.size() == 0 ? (anArchiveName != null ? jac.installComponentFromDomain(anArchiveName, aTarget) : jac.installComponent(anArchivePath, aTarget)) : (anArchiveName != null ? jac.installComponentFromDomain(anArchiveName, configProps, aTarget) : jac.installComponent(anArchivePath, configProps, aTarget));
            } else if ("service-assembly".equals(aJbiType)) {
                result = anArchiveName != null ? jac.deployServiceAssemblyFromDomain(anArchiveName, aTarget) : jac.deployServiceAssembly(anArchivePath, aTarget);
            } else if ("shared-library".equals(aJbiType)) {
                result = anArchiveName != null ? jac.installSharedLibraryFromDomain(anArchiveName, aTarget) : jac.installSharedLibrary(anArchivePath, aTarget);
            }
        } else {
            sLog.fine("InstallationBean.installValidatedArchiveToTarget() TBD generate internal error alert, and log");
            this.mIsAlertNeeded = true;
            this.mResultSummary = I18nUtilities.getResourceString("jbi.ee.install.impossible");
            this.mResultDetails = I18nUtilities.getResourceString("jbi.ee.install.impossible.details");
        }
        sLog.fine("InstallationBean.installValdidatedArchiveToTargetToTarget(...), result=" + result);
        return result;
    }

    public String getResultDetails() {
        this.mIsAlertNeeded = false;
        sLog.fine("InstallationBean.getResultDetails()=" + this.mResultDetails + ")");
        return this.mResultDetails;
    }

    public String getResultSummary() {
        sLog.fine("InstallationBean.getResultSummary()=" + this.mResultSummary + ")");
        return this.mResultSummary;
    }

    public Boolean getIsAlertNeeded() {
        Boolean result = null;
        result = new Boolean(this.mIsAlertNeeded);
        sLog.fine("InstallationBean.isAlertNeeded()=" + result + ")");
        return result;
    }

    public boolean getUploadSelected() {
        sLog.fine("InstallationBean.getUploadSelected()=" + this.mUploadSelected + ")");
        return this.mUploadSelected;
    }

    public void setUploadPathSelected(boolean uploadSelected) {
        sLog.fine("InstallationBean.setUploadSelected(" + uploadSelected + ")");
        this.mUploadSelected = uploadSelected;
    }

    public String[] getTargetNames() {
        return this.mTargetNames;
    }

    public void setTargetNames(String[] aTargetNames) {
        this.mTargetNames = aTargetNames;
    }

    public List getTargetNameList() throws JBIRemoteException {
        ArrayList<String> targetNameList = null;
        targetNameList = new ArrayList<String>();
        targetNameList.add("Target 1");
        targetNameList.add("Target 2");
        targetNameList.add("Target 3");
        return targetNameList;
    }

    public void setAllTargetOptionList() {
        try {
            List targetList = this.getTargetNameList();
            if (targetList != null && targetList.size() != 0) {
                this.mAllTargets = new Option[targetList.size()];
                for (int i = 0; i < targetList.size(); ++i) {
                    String targetName = targetList.get(i).toString();
                    this.mAllTargets[i] = new Option((Object)targetList.get(i).toString(), targetList.get(i).toString());
                }
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("Unable to obtain Target option list.");
            jbiRemoteEx.printStackTrace(System.err);
            this.mIsAlertNeeded = true;
            this.mResultSummary = I18nUtilities.getResourceString("jbi.ee.domain.list.not.found");
            this.mResultDetails = jbiRemoteEx.getMessage();
        }
    }

    public Option[] getAllTargetOptionList() {
        if (this.mAllTargets == null) {
            this.setAllTargetOptionList();
        }
        return this.mAllTargets;
    }
}

