/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.common;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtils {
    public static Document buildDomDocument(String xmlText) {
        StringReader reader = new StringReader(xmlText);
        return XmlUtils.buildDomDocument(reader);
    }

    public static Document buildDomDocument(Reader xmlReader) {
        Document xmlDoc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new DefaultHandler(){

                public void fatalError(SAXParseException e) throws SAXException {
                    throw new SAXException(e.getMessage());
                }
            });
            InputSource is = new InputSource(xmlReader);
            xmlDoc = docBuilder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlDoc;
    }

    public static Element getElement(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        return nodeList != null ? (Element)nodeList.item(0) : null;
    }

    public static Element getElement(Element element, String tagName) {
        Element childElement = null;
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList != null && nodeList.getLength() > 0) {
            childElement = (Element)nodeList.item(0);
        }
        return childElement;
    }

    public static Element getChildElement(Element element, String tagName) {
        NodeList list = XmlUtils.getChildElements(element, tagName);
        Element childElement = null;
        if (list != null && list.getLength() > 0) {
            childElement = (Element)list.item(0);
        }
        return childElement;
    }

    public static NodeList getChildElements(Element element, String tagName) {
        NodeList nodeList = element.getChildNodes();
        NodeListImpl list = new NodeListImpl();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            String elementName;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(elementName = XmlUtils.getElementName((Element)node)).equals(tagName)) continue;
            list.add(node);
        }
        return list;
    }

    public static String getElementName(Element element) {
        String tagName = element.getTagName();
        return XmlUtils.getName(tagName);
    }

    public static String getName(String name) {
        int lastIdx = name.lastIndexOf(58);
        if (lastIdx >= 0) {
            return name.substring(lastIdx + 1);
        }
        return name;
    }

    public static String getTextData(Element element) {
        return XmlUtils.getText(element).getData();
    }

    public static Text getText(Element element) {
        Node node = null;
        element.normalize();
        node = element.getFirstChild();
        if (node == null || !(node instanceof Text)) {
            node = element.getOwnerDocument().createTextNode("");
            element.appendChild(node);
        }
        return (Text)node;
    }

    public static class NodeListImpl
    extends ArrayList
    implements NodeList {
        public int getLength() {
            return this.size();
        }

        public Node item(int aIndex) {
            return (Node)this.get(aIndex);
        }
    }
}

